/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00060\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\f\u0010\u001c\u001a\u00020\u0006*\u00020\u0006H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "freeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "(Lorg/jetbrains/kotlin/types/KotlinType;Ljava/util/Collection;)V", "", "getFreeParameters", "()Ljava/util/Set;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "checkIsSubtypeOf", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "otherType", "checkIsSuperTypeOf", "equals", "", "other", "hashCode", "", "matchedSubstitutor", "matchKind", "Lorg/jetbrains/kotlin/idea/util/FuzzyType$MatchKind;", "addUsedTypeParameters", "", "", "toOriginal", "MatchKind", "ide-common"})
public final class FuzzyType {
    @NotNull
    private final KotlinType type;
    @NotNull
    private final Set<TypeParameterDescriptor> freeParameters;

    /*
     * WARNING - void declaration
     */
    public FuzzyType(@NotNull KotlinType type, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(freeParameters, (String)"freeParameters");
        this.type = type;
        Collection<? extends TypeParameterDescriptor> collection = freeParameters;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Collection collection2 = new HashSet();
            boolean bl2 = false;
            boolean bl3 = false;
            Iterable $this$_init__u24lambda_u2d0 = collection2;
            boolean bl4 = false;
            this.addUsedTypeParameters((Set<TypeParameterDescriptor>)$this$_init__u24lambda_u2d0, this.getType());
            HashSet usedTypeParameters = collection2;
            collection2 = usedTypeParameters;
            bl2 = false;
            if (!collection2.isEmpty()) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object object;
                TypeParameterDescriptor it;
                Object object2;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = freeParameters;
                boolean $i$f$map = false;
                $this$_init__u24lambda_u2d0 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
                    object2 = destination$iv$iv;
                    boolean bl5 = false;
                    object = this.toOriginal(it);
                    object2.add(object);
                }
                Set originalFreeParameters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                $this$map$iv = usedTypeParameters;
                object2 = this;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (TypeParameterDescriptor)element$iv$iv;
                    boolean bl6 = false;
                    if (!originalFreeParameters.contains(this.toOriginal(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = (List)destination$iv$iv;
                ((FuzzyType)object2).freeParameters = CollectionsKt.toSet((Iterable)((Iterable)object));
            } else {
                this.freeParameters = SetsKt.emptySet();
            }
        } else {
            this.freeParameters = SetsKt.emptySet();
        }
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @NotNull
    public final Set<TypeParameterDescriptor> getFreeParameters() {
        return this.freeParameters;
    }

    private final TypeParameterDescriptor toOriginal(TypeParameterDescriptor $this$toOriginal) {
        CallableMemberDescriptor callableMemberDescriptor;
        DeclarationDescriptor declarationDescriptor = $this$toOriginal.getContainingDeclaration();
        CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor = declarationDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor : null;
        if (callableMemberDescriptor == null) {
            return $this$toOriginal;
        }
        CallableMemberDescriptor callableDescriptor = callableMemberDescriptor;
        Object object = callableDescriptor.getOriginal();
        if (object == null) {
            String string = Intrinsics.stringPlus((String)"original = null for ", (Object)callableDescriptor);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        declarationDescriptor = object;
        DeclarationDescriptor original = declarationDescriptor;
        List list = original.getTypeParameters();
        if (list == null) {
            String string = Intrinsics.stringPlus((String)"typeParameters = null for ", (Object)original);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        object = list;
        CallableMemberDescriptor typeParameters = object;
        object = typeParameters.get($this$toOriginal.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeParameters[index]");
        return (TypeParameterDescriptor)object;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FuzzyType && Intrinsics.areEqual((Object)((FuzzyType)other).type, (Object)this.type) && Intrinsics.areEqual(((FuzzyType)other).freeParameters, this.freeParameters);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    private final void addUsedTypeParameters(Set<TypeParameterDescriptor> $this$addUsedTypeParameters, KotlinType type) {
        TypeParameterDescriptor typeParameter;
        Object object = type.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = typeParameter = object instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)object : null;
        if (typeParameter != null && $this$addUsedTypeParameters.add(typeParameter)) {
            object = typeParameter.getUpperBounds();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeParameter.upperBounds");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.addUsedTypeParameters($this$addUsedTypeParameters, it);
            }
        }
        for (TypeProjection argument : type.getArguments()) {
            if (argument.isStarProjection()) continue;
            KotlinType kotlinType = argument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"argument.type");
            this.addUsedTypeParameters($this$addUsedTypeParameters, kotlinType);
        }
    }

    @Nullable
    public final TypeSubstitutor checkIsSubtypeOf(@NotNull FuzzyType otherType) {
        Intrinsics.checkNotNullParameter((Object)otherType, (String)"otherType");
        return this.matchedSubstitutor(otherType, MatchKind.IS_SUBTYPE);
    }

    @Nullable
    public final TypeSubstitutor checkIsSuperTypeOf(@NotNull FuzzyType otherType) {
        Intrinsics.checkNotNullParameter((Object)otherType, (String)"otherType");
        return this.matchedSubstitutor(otherType, MatchKind.IS_SUPERTYPE);
    }

    @Nullable
    public final TypeSubstitutor checkIsSubtypeOf(@NotNull KotlinType otherType) {
        Intrinsics.checkNotNullParameter((Object)otherType, (String)"otherType");
        return this.checkIsSubtypeOf(FuzzyTypeUtils.toFuzzyType(otherType, CollectionsKt.emptyList()));
    }

    @Nullable
    public final TypeSubstitutor checkIsSuperTypeOf(@NotNull KotlinType otherType) {
        Intrinsics.checkNotNullParameter((Object)otherType, (String)"otherType");
        return this.checkIsSuperTypeOf(FuzzyTypeUtils.toFuzzyType(otherType, CollectionsKt.emptyList()));
    }

    /*
     * WARNING - void declaration
     */
    private final TypeSubstitutor matchedSubstitutor(FuzzyType otherType, MatchKind matchKind) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        TypeParameterDescriptor typeParameterDescriptor;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (KotlinTypeKt.isError((KotlinType)this.type)) {
            return null;
        }
        if (KotlinTypeKt.isError((KotlinType)otherType.type)) {
            return null;
        }
        if (TypeUtilsKt.isUnit((KotlinType)otherType.type) && matchKind == MatchKind.IS_SUBTYPE) {
            return TypeSubstitutor.EMPTY;
        }
        if (this.freeParameters.isEmpty() && otherType.freeParameters.isEmpty()) {
            return FuzzyType.matchedSubstitutor$checkInheritance(this.type, matchKind, otherType.type) ? TypeSubstitutor.EMPTY : null;
        }
        ConstraintSystemBuilderImpl builder = new ConstraintSystemBuilderImpl(null, 1, null);
        TypeSubstitutor typeVariableSubstitutor = ConstraintSystem.Builder.DefaultImpls.registerTypeVariables$default((ConstraintSystem.Builder)((ConstraintSystem.Builder)builder), (CallHandle)((CallHandle)CallHandle.NONE.INSTANCE), (Collection)SetsKt.plus(this.freeParameters, (Iterable)otherType.freeParameters), (boolean)false, (int)4, null);
        KotlinType typeInSystem = typeVariableSubstitutor.substitute(this.type, Variance.INVARIANT);
        KotlinType otherTypeInSystem = typeVariableSubstitutor.substitute(otherType.type, Variance.INVARIANT);
        MatchKind matchKind2 = matchKind;
        int n = WhenMappings.$EnumSwitchMapping$0[matchKind2.ordinal()];
        switch (n) {
            case 1: {
                builder.addSubtypeConstraint(typeInSystem, otherTypeInSystem, ConstraintPositionKind.RECEIVER_POSITION.position());
                break;
            }
            case 2: {
                builder.addSubtypeConstraint(otherTypeInSystem, typeInSystem, ConstraintPositionKind.RECEIVER_POSITION.position());
            }
        }
        builder.fixVariables();
        ConstraintSystem constraintSystem = builder.build();
        if (constraintSystem.getStatus().hasContradiction()) {
            return null;
        }
        TypeSubstitutor substitutor = constraintSystem.getResultingSubstitutor();
        KotlinType kotlinType = substitutor.substitute(this.type, Variance.INVARIANT);
        if (kotlinType == null) {
            return null;
        }
        KotlinType kotlinType2 = kotlinType;
        KotlinType substitutedType = kotlinType2;
        if (KotlinTypeKt.isError((KotlinType)substitutedType)) {
            return TypeSubstitutor.EMPTY;
        }
        KotlinType kotlinType3 = substitutor.substitute(otherType.type, Variance.INVARIANT);
        if (kotlinType3 == null) {
            return null;
        }
        kotlinType = kotlinType3;
        KotlinType otherSubstitutedType = kotlinType;
        if (KotlinTypeKt.isError((KotlinType)otherSubstitutedType)) {
            return TypeSubstitutor.EMPTY;
        }
        if (!FuzzyType.matchedSubstitutor$checkInheritance(substitutedType, matchKind, otherSubstitutedType)) {
            return null;
        }
        kotlinType3 = substitutor.getSubstitution();
        TypeSubstitutor substitutorToKeepCapturedTypes2 = new DelegatedTypeSubstitution((TypeSubstitution)kotlinType3){
            {
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"substitution");
                super($super_call_param$1);
            }

            public boolean approximateCapturedTypes() {
                return false;
            }
        }.buildSubstitutor();
        Iterable iterable = constraintSystem.getTypeVariables();
        boolean $i$f$map = false;
        void var15_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeVariable typeVariable = (TypeVariable)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            typeParameterDescriptor = it.getOriginalTypeParameter();
            object.add(typeParameterDescriptor);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            TypeProjection typeProjection;
            TypeProjection substitutedProjection;
            TypeParameterDescriptor it;
            TypeParameterDescriptor bl = (TypeParameterDescriptor)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            TypeConstructor typeConstructor = it.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor, (String)"it.typeConstructor");
            typeParameterDescriptor = typeConstructor;
            it = (TypeParameterDescriptor)element$iv$iv;
            boolean bl3 = false;
            TypeProjectionImpl typeProjection2 = new TypeProjectionImpl(Variance.INVARIANT, (KotlinType)it.getDefaultType());
            TypeProjection typeProjection3 = substitutedProjection = substitutorToKeepCapturedTypes2.substitute((TypeProjection)typeProjection2);
            if (typeProjection3 == null) {
                typeProjection = (TypeProjection)typeProjection2;
            } else {
                TypeProjection typeProjection4 = typeProjection3;
                boolean bl4 = false;
                boolean bl5 = false;
                TypeProjection it2 = typeProjection4;
                boolean bl6 = false;
                TypeProjection typeProjection5 = !ErrorUtils.containsUninferredParameter((KotlinType)it2.getType()) ? typeProjection4 : null;
                typeProjection = typeProjection5 == null ? (TypeProjection)typeProjection2 : typeProjection5;
            }
            TypeProjection typeProjection6 = typeProjection;
            object.put(typeParameterDescriptor, typeProjection6);
        }
        Map substitutionMap = destination$iv$iv2;
        return TypeConstructorSubstitution.Companion.createByConstructorsMap(substitutionMap, true).buildSubstitutor();
    }

    private static final boolean matchedSubstitutor$checkInheritance(KotlinType $this$matchedSubstitutor_u24checkInheritance, MatchKind $matchKind, KotlinType otherType) {
        boolean bl;
        MatchKind matchKind = $matchKind;
        int n = WhenMappings.$EnumSwitchMapping$0[matchKind.ordinal()];
        switch (n) {
            case 1: {
                bl = TypeUtilsKt.isSubtypeOf((KotlinType)$this$matchedSubstitutor_u24checkInheritance, (KotlinType)otherType);
                break;
            }
            case 2: {
                bl = TypeUtilsKt.isSubtypeOf((KotlinType)otherType, (KotlinType)$this$matchedSubstitutor_u24checkInheritance);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/util/FuzzyType$MatchKind;", "", "(Ljava/lang/String;I)V", "IS_SUBTYPE", "IS_SUPERTYPE", "ide-common"})
    private static final class MatchKind
    extends Enum<MatchKind> {
        public static final /* enum */ MatchKind IS_SUBTYPE = new MatchKind();
        public static final /* enum */ MatchKind IS_SUPERTYPE = new MatchKind();
        private static final /* synthetic */ MatchKind[] $VALUES;

        public static MatchKind[] values() {
            MatchKind[] matchKindArray = $VALUES;
            MatchKind[] matchKindArray2 = new MatchKind[matchKindArray.length];
            System.arraycopy(matchKindArray, 0, matchKindArray2, 0, matchKindArray.length);
            return matchKindArray2;
        }

        public static MatchKind valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(MatchKind.class, value);
        }

        static {
            $VALUES = matchKindArray = new MatchKind[]{MatchKind.IS_SUBTYPE, MatchKind.IS_SUPERTYPE};
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MatchKind.values().length];
            nArray[MatchKind.IS_SUBTYPE.ordinal()] = 1;
            nArray[MatchKind.IS_SUPERTYPE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

