/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a \u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0015"}, d2={"combineIfNoConflicts", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "other", "freeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "hasConflictWith", "", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "isAlmostEverything", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "presentationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toFuzzyType", "ide-common"})
@JvmName(name="FuzzyTypeUtils")
public final class FuzzyTypeUtils {
    @Nullable
    public static final FuzzyType fuzzyReturnType(@NotNull CallableDescriptor $this$fuzzyReturnType) {
        FuzzyType fuzzyType;
        Intrinsics.checkNotNullParameter((Object)$this$fuzzyReturnType, (String)"<this>");
        KotlinType kotlinType = $this$fuzzyReturnType.getReturnType();
        if (kotlinType == null) {
            fuzzyType = null;
        } else {
            List list = $this$fuzzyReturnType.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType(kotlinType, list);
        }
        return fuzzyType;
    }

    @Nullable
    public static final FuzzyType fuzzyExtensionReceiverType(@NotNull CallableDescriptor $this$fuzzyExtensionReceiverType) {
        FuzzyType fuzzyType;
        Intrinsics.checkNotNullParameter((Object)$this$fuzzyExtensionReceiverType, (String)"<this>");
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$fuzzyExtensionReceiverType.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            fuzzyType = null;
        } else {
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            if (kotlinType == null) {
                fuzzyType = null;
            } else {
                List list = $this$fuzzyExtensionReceiverType.getTypeParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"typeParameters");
                fuzzyType = FuzzyTypeUtils.toFuzzyType(kotlinType, list);
            }
        }
        return fuzzyType;
    }

    @NotNull
    public static final FuzzyType makeNotNullable(@NotNull FuzzyType $this$makeNotNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNotNullable, (String)"<this>");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNotNullable((KotlinType)$this$makeNotNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNotNullable.getFreeParameters());
    }

    @NotNull
    public static final FuzzyType makeNullable(@NotNull FuzzyType $this$makeNullable) {
        Intrinsics.checkNotNullParameter((Object)$this$makeNullable, (String)"<this>");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNullable((KotlinType)$this$makeNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNullable.getFreeParameters());
    }

    @NotNull
    public static final TypeNullability nullability(@NotNull FuzzyType $this$nullability) {
        Intrinsics.checkNotNullParameter((Object)$this$nullability, (String)"<this>");
        return TypeUtilsKt.nullability((KotlinType)$this$nullability.getType());
    }

    public static final boolean isAlmostEverything(@NotNull FuzzyType $this$isAlmostEverything) {
        boolean bl;
        TypeParameterDescriptor typeParameterDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$isAlmostEverything, (String)"<this>");
        if ($this$isAlmostEverything.getFreeParameters().isEmpty()) {
            return false;
        }
        Object object = $this$isAlmostEverything.getType().getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor = object instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)object : null;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameter = typeParameterDescriptor;
        if (!$this$isAlmostEverything.getFreeParameters().contains(typeParameter)) {
            return false;
        }
        object = typeParameter.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeParameter.upperBounds");
        typeParameterDescriptor = (KotlinType)CollectionsKt.singleOrNull((List)object);
        return typeParameterDescriptor == null ? false : (bl = TypeUtilsKt.isAnyOrNullableAny((KotlinType)typeParameterDescriptor));
    }

    @NotNull
    public static final KotlinType presentationType(@NotNull FuzzyType $this$presentationType) {
        Intrinsics.checkNotNullParameter((Object)$this$presentationType, (String)"<this>");
        if ($this$presentationType.getFreeParameters().isEmpty()) {
            return $this$presentationType.getType();
        }
        HashMap map = new HashMap();
        Iterable iterable = $this$presentationType.getType().getArguments();
        List list2 = $this$presentationType.getType().getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"type.constructor.parameters");
        for (List list2 : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
            Object v1;
            TypeParameterDescriptor typeParameter;
            block3: {
                TypeProjection argument = (TypeProjection)list2.component1();
                typeParameter = (TypeParameterDescriptor)list2.component2();
                if (argument.getProjectionKind() != Variance.INVARIANT) continue;
                Iterable $this$firstOrNull$iv = $this$presentationType.getFreeParameters();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl = false;
                    SimpleType simpleType = it.getDefaultType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"it.defaultType");
                    if (!StrictEqualityTypeChecker.INSTANCE.strictEqualTypes((UnwrappedType)simpleType, argument.getType().unwrap())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            Object object = v1;
            if (object == null) continue;
            TypeParameterDescriptor equalToFreeParameter = object;
            object = map;
            TypeConstructor typeConstructor = equalToFreeParameter.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor, (String)"equalToFreeParameter.typeConstructor");
            SimpleType simpleType = typeParameter.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"typeParameter.defaultType");
            simpleType = TypeUtilsKt.createProjection((KotlinType)((KotlinType)simpleType), (Variance)Variance.INVARIANT, null);
            boolean bl = false;
            object.put(typeConstructor, simpleType);
        }
        list2 = TypeSubstitutor.create((Map)map);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"create(map)");
        List substitutor = list2;
        KotlinType kotlinType = substitutor.substitute($this$presentationType.getType(), Variance.INVARIANT);
        Intrinsics.checkNotNull((Object)kotlinType);
        list2 = kotlinType;
        return list2;
    }

    @NotNull
    public static final FuzzyType toFuzzyType(@NotNull KotlinType $this$toFuzzyType, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$toFuzzyType, (String)"<this>");
        Intrinsics.checkNotNullParameter(freeParameters, (String)"freeParameters");
        return new FuzzyType($this$toFuzzyType, freeParameters);
    }

    public static final boolean hasConflictWith(@NotNull TypeSubstitution $this$hasConflictWith, @NotNull TypeSubstitution other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$hasConflictWith, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            Intrinsics.checkNotNullParameter(freeParameters, (String)"freeParameters");
            Iterable $this$any$iv = freeParameters;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                    boolean bl3 = false;
                    SimpleType simpleType = parameter.getDefaultType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"parameter.defaultType");
                    SimpleType type = simpleType;
                    TypeProjection typeProjection = $this$hasConflictWith.get((KotlinType)type);
                    if (typeProjection == null) {
                        bl2 = false;
                    } else {
                        TypeProjection substituted1 = typeProjection;
                        TypeProjection typeProjection2 = other.get((KotlinType)type);
                        if (typeProjection2 == null) {
                            bl2 = false;
                        } else {
                            TypeProjection substituted2 = typeProjection2;
                            bl2 = !StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(substituted1.getType().unwrap(), substituted2.getType().unwrap()) || substituted1.getProjectionKind() != substituted2.getProjectionKind();
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final TypeSubstitutor combineIfNoConflicts(@NotNull TypeSubstitutor $this$combineIfNoConflicts, @NotNull TypeSubstitutor other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$combineIfNoConflicts, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter(freeParameters, (String)"freeParameters");
        TypeSubstitution typeSubstitution = $this$combineIfNoConflicts.getSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitution, (String)"this.substitution");
        TypeSubstitution typeSubstitution2 = typeSubstitution;
        typeSubstitution = other.getSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitution, (String)"other.substitution");
        if (FuzzyTypeUtils.hasConflictWith(typeSubstitution2, typeSubstitution, freeParameters)) {
            return null;
        }
        return TypeSubstitutor.createChainedSubstitutor((TypeSubstitution)$this$combineIfNoConflicts.getSubstitution(), (TypeSubstitution)other.getSubstitution());
    }
}

