/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.dependencies;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.dependencies.ExternalDependenciesResolver;
import kotlin.script.experimental.dependencies.RepositoryCoordinates;
import kotlin.script.experimental.dependencies.impl.ResolverUtilsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J%\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00140\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0004*\u00020\u000fH\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0004*\u00020\fH\u0002R\"\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lkotlin/script/experimental/dependencies/FileSystemDependenciesResolver;", "Lkotlin/script/experimental/dependencies/ExternalDependenciesResolver;", "paths", "", "Ljava/io/File;", "([Ljava/io/File;)V", "localRepos", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "acceptsArtifact", "", "artifactCoordinates", "", "acceptsRepository", "repositoryCoordinates", "Lkotlin/script/experimental/dependencies/RepositoryCoordinates;", "addRepository", "", "resolve", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toFilePath", "toRepositoryFileOrNull", "kotlin-scripting-dependencies"})
public final class FileSystemDependenciesResolver
implements ExternalDependenciesResolver {
    private final ArrayList<File> localRepos;

    private final File toRepositoryFileOrNull(@NotNull String $this$toRepositoryFileOrNull) {
        File file = new File($this$toRepositoryFileOrNull);
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        return it.exists() && it.isDirectory() ? file : null;
    }

    private final File toFilePath(@NotNull RepositoryCoordinates $this$toFilePath) {
        Object object;
        FileSystemDependenciesResolver fileSystemDependenciesResolver;
        block3: {
            block2: {
                fileSystemDependenciesResolver = this;
                object = ResolverUtilsKt.toRepositoryUrlOrNull($this$toFilePath);
                if (object == null) break block2;
                URL uRL = object;
                FileSystemDependenciesResolver fileSystemDependenciesResolver2 = fileSystemDependenciesResolver;
                boolean bl = false;
                boolean bl2 = false;
                URL it = uRL;
                boolean bl3 = false;
                URL uRL2 = Intrinsics.areEqual((Object)it.getProtocol(), (Object)"file") ? uRL : null;
                fileSystemDependenciesResolver = fileSystemDependenciesResolver2;
                object = uRL2;
                if (object != null && (object = ((URL)object).getPath()) != null) break block3;
            }
            object = $this$toFilePath.getString();
        }
        return fileSystemDependenciesResolver.toRepositoryFileOrNull((String)object);
    }

    @Override
    public void addRepository(@NotNull RepositoryCoordinates repositoryCoordinates) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        File file = this.toFilePath(repositoryCoordinates);
        if (file == null) {
            throw (Throwable)new IllegalArgumentException("Invalid repository location: '" + repositoryCoordinates + '\'');
        }
        File repoDir = file;
        this.localRepos.add(repoDir);
    }

    @Override
    @Nullable
    public Object resolve(@NotNull String artifactCoordinates, @NotNull Continuation<? super ResultWithDiagnostics<? extends List<? extends File>>> $completion) {
        if (!this.acceptsArtifact(artifactCoordinates)) {
            throw (Throwable)new IllegalArgumentException("Path is invalid");
        }
        boolean bl = false;
        List messages = new ArrayList();
        for (File repo : this.localRepos) {
            File file = repo == null ? new File(artifactCoordinates) : new File(repo, artifactCoordinates);
            if (!file.exists()) {
                messages.add("File '" + file + "' not found");
                continue;
            }
            if (!file.isFile() && !file.isDirectory()) {
                messages.add("Path '" + file + "' is neither file nor directory");
                continue;
            }
            return new ResultWithDiagnostics.Success((Object)CollectionsKt.listOf((Object)file), null, 2, null);
        }
        return ResolverUtilsKt.makeResolveFailureResult(messages);
    }

    @Override
    public boolean acceptsArtifact(@NotNull String artifactCoordinates) {
        Intrinsics.checkParameterIsNotNull((Object)artifactCoordinates, (String)"artifactCoordinates");
        return !StringsKt.isBlank((CharSequence)artifactCoordinates);
    }

    @Override
    public boolean acceptsRepository(@NotNull RepositoryCoordinates repositoryCoordinates) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryCoordinates, (String)"repositoryCoordinates");
        return this.toFilePath(repositoryCoordinates) != null;
    }

    public FileSystemDependenciesResolver(File ... paths) {
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        this.localRepos = CollectionsKt.arrayListOf((Object[])new File[]{null});
        for (File path : paths) {
            boolean bl = path.exists() && path.isDirectory();
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) continue;
            boolean bl4 = false;
            String string = "Invalid flat lib directory repository path '" + path + '\'';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        CollectionsKt.addAll((Collection)this.localRepos, (Object[])paths);
    }
}

