/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.SourceCode;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u00008\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a'\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u000e\b\u0004\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u001b\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u0082\u0002\u000e\n\f\b\u0000\u0012\u0002\u0018\u0000\u001a\u0004\u0010\u0000(\u0000\u001a\f\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u0007\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0012\u001a\u00020\u0006*\u00020\u000b\u001a\f\u0010\u0013\u001a\u00020\u0006*\u00020\u000bH\u0002\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00f2\u0001\u0004\n\u00020\b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"runReadAction", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isScript", "", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/kotlin/psi/KtFile;", "findScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "script", "Lkotlin/script/experimental/api/SourceCode;", "JAVA_CLASS_FILE_TYPE_DOT_DEFAULT_EXTENSION", "", "isNonScript", "isKotlinFileType", "kotlin-scripting-compiler-impl"})
@SourceDebugExtension(value={"SMAP\ndefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 definitions.kt\norg/jetbrains/kotlin/scripting/definitions/DefinitionsKt\n*L\n1#1,103:1\n29#1:104\n*S KotlinDebug\n*F\n+ 1 definitions.kt\norg/jetbrains/kotlin/scripting/definitions/DefinitionsKt\n*L\n61#1:104\n*E\n"})
public final class DefinitionsKt {
    @NotNull
    private static final String JAVA_CLASS_FILE_TYPE_DOT_DEFAULT_EXTENSION = ".class";

    public static final <T> T runReadAction(@NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$runReadAction = false;
        return (T)ApplicationManager.getApplication().runReadAction(new Computable(runnable){
            final /* synthetic */ Function0<T> $runnable;
            {
                this.$runnable = $runnable;
            }

            public final T compute() {
                return (T)this.$runnable.invoke();
            }
        });
    }

    public static final boolean isScript(@NotNull PsiFile $this$isScript) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$this$isScript, (String)"<this>");
        if (!($this$isScript instanceof KtFile)) {
            return false;
        }
        VirtualFile virtualFile2 = ((KtFile)$this$isScript).getVirtualFile();
        if (virtualFile2 == null && (virtualFile2 = ((KtFile)$this$isScript).getOriginalFile().getVirtualFile()) == null) {
            VirtualFile virtualFile3 = ((KtFile)$this$isScript).getViewProvider().getVirtualFile();
            virtualFile2 = virtualFile3;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
        }
        return !DefinitionsKt.isNonScript(virtualFile = virtualFile2);
    }

    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull PsiFile $this$findScriptDefinition) {
        ScriptDefinition scriptDefinition;
        Intrinsics.checkNotNullParameter((Object)$this$findScriptDefinition, (String)"<this>");
        if (DefinitionsKt.isScript($this$findScriptDefinition)) {
            Project project = ((KtFile)$this$findScriptDefinition).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            scriptDefinition = DefinitionsKt.findScriptDefinition(project, (SourceCode)new KtFileScriptSource((KtFile)$this$findScriptDefinition, null, 2, null));
        } else {
            scriptDefinition = null;
        }
        return scriptDefinition;
    }

    @Deprecated(message="Use PsiFile.findScriptDefinition() instead")
    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull VirtualFile $this$findScriptDefinition, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$findScriptDefinition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!$this$findScriptDefinition.isValid() || DefinitionsKt.isNonScript($this$findScriptDefinition)) {
            return null;
        }
        boolean $i$f$runReadAction = false;
        if (ApplicationManager.getApplication().runReadAction(new Computable(project, $this$findScriptDefinition){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $this_findScriptDefinition$inlined;
            {
                this.$project$inlined = project;
                this.$this_findScriptDefinition$inlined = virtualFile;
            }

            public final T compute() {
                boolean bl = false;
                PsiFile psiFile = PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$this_findScriptDefinition$inlined);
                return (T)(psiFile instanceof KtFile ? (KtFile)psiFile : null);
            }
        }) == null) {
            return null;
        }
        return DefinitionsKt.findScriptDefinition(project, (SourceCode)new VirtualFileScriptSource($this$findScriptDefinition, null, 2, null));
    }

    @NotNull
    public static final ScriptDefinition findScriptDefinition(@NotNull Project project, @NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        if (scriptDefinitionProvider == null) {
            throw new IllegalStateException("Unable to get script definition: ScriptDefinitionProvider is not configured.".toString());
        }
        ScriptDefinitionProvider scriptDefinitionProvider2 = scriptDefinitionProvider;
        ScriptDefinition scriptDefinition = scriptDefinitionProvider2.findDefinition(script);
        if (scriptDefinition == null) {
            ScriptDefinition scriptDefinition2;
            ScriptDefinition it = scriptDefinition2 = scriptDefinitionProvider2.getDefaultDefinition();
            boolean bl = false;
            Logger.getInstance((String)"org.jetbrains.kotlin.scripting.definitions").debug("Default definition is used for " + script.getLocationId());
            scriptDefinition = scriptDefinition2;
        }
        return scriptDefinition;
    }

    public static final boolean isNonScript(@NotNull VirtualFile $this$isNonScript) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNonScript, (String)"<this>");
        if ($this$isNonScript instanceof VirtualFileWindow) {
            bl = !DefinitionsKt.isKotlinFileType($this$isNonScript);
        } else if ($this$isNonScript.isDirectory()) {
            bl = true;
        } else {
            CharSequence charSequence = $this$isNonScript.getNameSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
            CharSequence nameSeq = charSequence;
            bl = StringsKt.endsWith$default((CharSequence)nameSeq, (CharSequence)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSeq, (CharSequence)".java", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSeq, (CharSequence)JAVA_CLASS_FILE_TYPE_DOT_DEFAULT_EXTENSION, (boolean)false, (int)2, null) || !DefinitionsKt.isKotlinFileType($this$isNonScript);
        }
        return bl;
    }

    private static final boolean isKotlinFileType(VirtualFile $this$isKotlinFileType) {
        CharSequence charSequence = $this$isKotlinFileType.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        if (StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)KotlinParserDefinition.STD_SCRIPT_EXT, (boolean)false, (int)2, null)) {
            return true;
        }
        FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
        return Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFile($this$isKotlinFileType), (Object)KotlinFileType.INSTANCE) || Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFileName($this$isKotlinFileType.getName()), (Object)KotlinFileType.INSTANCE);
    }
}

