/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptIdeConfigurationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.powerassert.diagram.SourceFile;
import org.jetbrains.kotlin.scripting.compiler.plugin.extensions.KotlinScriptExpressionExplainTransformer;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/extensions/ScriptingIrExplainGenerationExtension;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "project", "Lorg/jetbrains/kotlin/com/intellij/mock/MockProject;", "<init>", "(Lcom/intellij/mock/MockProject;)V", "getProject", "()Lcom/intellij/mock/MockProject;", "generate", "", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "kotlin-scripting-compiler"})
public final class ScriptingIrExplainGenerationExtension
implements IrGenerationExtension {
    @NotNull
    private final MockProject project;

    public ScriptingIrExplainGenerationExtension(@NotNull MockProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final MockProject getProject() {
        return this.project;
    }

    public void generate(@NotNull IrModuleFragment moduleFragment, @NotNull IrPluginContext pluginContext) {
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        for (IrFile file : moduleFragment.getFiles()) {
            Object object = JvmIrUtilsKt.getKtFile((IrFile)file);
            if (object == null || (object = DefinitionsKt.findScriptDefinition((PsiFile)((PsiFile)object))) == null || (object = (String)object.getCompilationConfiguration().get(ScriptIdeConfigurationKt.getExplainField((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)))) == null) {
                return;
            }
            Object explainFieldName = object;
            new KotlinScriptExpressionExplainTransformer(new SourceFile(file), pluginContext, (String)explainFieldName).visitFile(file);
        }
    }
}

