/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script.util.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0000\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"FILE_PROTOCOL", "", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "getResourcePathForClass", "Ljava/io/File;", "aClass", "Ljava/lang/Class;", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "toFile", "kotlin-script-util"})
public final class PathUtilKt {
    private static final String JAR_PROTOCOL = "jar";
    private static final String FILE_PROTOCOL = "file";
    private static final String JAR_SEPARATOR = "!/";
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        URL url = context.getResource(path);
        if (url == null) {
            String string = path;
            int n = 1;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string2);
        }
        return url != null ? PathUtilKt.extractRoot(url, path) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, (char)'\\', (boolean)false, (int)2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual((Object)protocol, (Object)FILE_PROTOCOL)) {
            String path;
            File file = PathUtilKt.toFile(resourceURL);
            if (file == null) {
                Intrinsics.throwNpe();
            }
            String string = path = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            String testPath = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            String testResourcePath = StringsKt.replace$default((String)resourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (StringsKt.endsWith((String)testPath, (String)testResourcePath, (boolean)true)) {
                String string2 = path;
                int n = 0;
                int n2 = path.length() - resourcePath.length();
                String string3 = string2.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                resultPath = string3;
            }
        } else if (Intrinsics.areEqual((Object)protocol, (Object)JAR_PROTOCOL)) {
            Pair<String, String> paths;
            String string = resourceURL.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resourceURL.file");
            Pair<String, String> pair = paths = PathUtilKt.splitJarUrl(string);
            if ((pair != null ? (String)pair.getFirst() : null) != null) {
                resultPath = new File((String)paths.getFirst()).getCanonicalPath();
            }
        }
        String string = resultPath;
        return string != null ? StringsKt.trimEnd((String)string, (char[])new char[]{File.separatorChar}) : null;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block13: {
            Integer n = StringsKt.indexOf$default((CharSequence)url, (String)JAR_SEPARATOR, (int)0, (boolean)false, (int)6, null);
            int it22 = ((Number)n).intValue();
            Integer n2 = it22 >= 0 ? n : null;
            if (n2 == null) {
                return null;
            }
            int pivot = n2;
            String it22 = url;
            int $i$a$1$takeIf22 = pivot + 2;
            String string = it22;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring($i$a$1$takeIf22);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            resourcePath = string2;
            String $i$a$1$takeIf22 = url;
            int n3 = 0;
            String string3 = $i$a$1$takeIf22;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n3, pivot);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarPath = string4;
            if (StringsKt.startsWith$default((String)jarPath, (String)"jar:", (boolean)false, (int)2, null)) {
                $i$a$1$takeIf22 = jarPath;
                n3 = 4;
                String string5 = $i$a$1$takeIf22;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                jarPath = string6;
            }
            if (StringsKt.startsWith$default((String)jarPath, (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                try {
                    File file = PathUtilKt.toFile(new URL(jarPath));
                    if (file == null) {
                        Intrinsics.throwNpe();
                    }
                    String string7 = file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"URL(jarPath).toFile()!!.path");
                    jarPath = StringsKt.replace$default((String)string7, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    String string8 = jarPath;
                    int n4 = FILE_PROTOCOL.length();
                    String string9 = string8;
                    if (string9 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string10 = string9.substring(n4);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string10;
                    if (StringsKt.startsWith$default((String)jarPath, (String)SCHEME_SEPARATOR, (boolean)false, (int)2, null)) {
                        string8 = jarPath;
                        n4 = SCHEME_SEPARATOR.length();
                        String string11 = string8;
                        if (string11 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string12 = string11.substring(n4);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                        jarPath = string12;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, (char)':', (boolean)false, (int)2, null)) break block13;
                    string8 = jarPath;
                    n4 = 1;
                    String string13 = string8;
                    if (string13 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string14 = string13.substring(n4);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string14;
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass) {
        Intrinsics.checkParameterIsNotNull(aClass, (String)"aClass");
        StringBuilder stringBuilder = new StringBuilder().append("/");
        String string = aClass.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aClass.name");
        String path = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        String string2 = PathUtilKt.getResourceRoot(aClass, path);
        if (string2 == null) {
            throw (Throwable)new IllegalStateException("Resource not found: " + path);
        }
        String resourceRoot = string2;
        File file = new File(resourceRoot).getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(resourceRoot).absoluteFile");
        return file;
    }

    @Nullable
    public static final File toFile(@NotNull URL $receiver) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            URI uRI = $receiver.toURI();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"toURI()");
            file = new File(uRI.getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            file = Intrinsics.areEqual((Object)$receiver.getProtocol(), (Object)FILE_PROTOCOL) ^ true ? null : new File($receiver.getFile());
        }
        return file;
    }
}

