/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.Progression;
import jet.ShortIterator;
import jet.ShortProgressionIterator;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public class ShortProgression
implements Progression<Short> {
    private final short start;
    private final short end;
    private final int increment;

    public ShortProgression(short start, short end, int increment) {
        if (increment == 0) {
            throw new IllegalArgumentException("Increment must be non-zero: " + increment);
        }
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Short getStart() {
        return this.start;
    }

    @Override
    public Short getEnd() {
        return this.end;
    }

    @Override
    public Integer getIncrement() {
        return this.increment;
    }

    public ShortIterator iterator() {
        return new ShortProgressionIterator(this.start, this.end, this.increment);
    }

    public String toString() {
        if (this.increment > 0) {
            return this.start + ".." + this.end + " step " + this.increment;
        }
        return this.start + " downTo " + this.end + " step " + -this.increment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortProgression shorts = (ShortProgression)o;
        if (this.end != shorts.end) {
            return false;
        }
        if (this.increment != shorts.increment) {
            return false;
        }
        return this.start == shorts.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.increment;
        return result;
    }
}

