/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.IntIterator;
import jet.IntProgressionIterator;
import jet.Progression;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public class IntProgression
implements Progression<Integer> {
    private final int start;
    private final int end;
    private final int increment;

    public IntProgression(int start, int end, int increment) {
        if (increment == 0) {
            throw new IllegalArgumentException("Increment must be non-zero: " + increment);
        }
        this.start = start;
        this.end = end;
        this.increment = increment;
    }

    @Override
    public Integer getStart() {
        return this.start;
    }

    @Override
    public Integer getEnd() {
        return this.end;
    }

    @Override
    public Integer getIncrement() {
        return this.increment;
    }

    public IntIterator iterator() {
        return new IntProgressionIterator(this.start, this.end, this.increment);
    }

    public String toString() {
        if (this.increment > 0) {
            return this.start + ".." + this.end + " step " + this.increment;
        }
        return this.start + " downTo " + this.end + " step " + -this.increment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntProgression sequence = (IntProgression)o;
        if (this.end != sequence.end) {
            return false;
        }
        if (this.increment != sequence.increment) {
            return false;
        }
        return this.start == sequence.start;
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + this.increment;
        return result;
    }
}

