/*
 * Decompiled with CFR 0.152.
 */
package jet.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jet.Function0;

public class Intrinsics {
    private static final Set<String> METHOD_NAMES_TO_SKIP = new HashSet<String>(Arrays.asList("throwNpe", "checkReturnedValueIsNotNull", "checkFieldIsNotNull", "checkParameterIsNotNull"));

    private Intrinsics() {
    }

    public static String stringPlus(String self, Object other) {
        return (self == null ? "null" : self) + (other == null ? "null" : other.toString());
    }

    public static void throwNpe() {
        throw new JetNullPointerException();
    }

    public static void checkReturnedValueIsNotNull(Object value, String className, String methodName) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException("Method specified as non-null returned null: " + className + "." + methodName);
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkFieldIsNotNull(Object value, String className, String fieldName) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException("Field specified as non-null contains null: " + className + "." + fieldName);
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkParameterIsNotNull(Object value, String paramName) {
        if (value == null) {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            StackTraceElement caller = stackTraceElements[2];
            String className = caller.getClassName();
            String methodName = caller.getMethodName();
            IllegalArgumentException exception = new IllegalArgumentException("Parameter specified as non-null contains null: method " + className + "." + methodName + ", parameter " + paramName);
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static <T> Class<T> getJavaClass(T self) {
        return self.getClass();
    }

    public static int compare(long thisVal, long anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int compare(int thisVal, int anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static boolean areEqual(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R stupidSync(Object lock, Function0<R> block) {
        Object object2 = lock;
        synchronized (object2) {
            return block.invoke();
        }
    }

    private static <T extends Throwable> T sanitizeStackTrace(T throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        boolean skip = true;
        for (StackTraceElement ste : stackTrace) {
            if (!skip) {
                list.add(ste);
                continue;
            }
            if (!"jet.runtime.Intrinsics".equals(ste.getClassName()) || !METHOD_NAMES_TO_SKIP.contains(ste.getMethodName())) continue;
            skip = false;
        }
        throwable.setStackTrace(list.toArray(new StackTraceElement[list.size()]));
        return throwable;
    }

    public static class SpreadBuilder
    extends ArrayList {
        public void addSpread(Object array) {
            if (array != null) {
                if (array instanceof Object[]) {
                    Object[] arr = (Object[])array;
                    if (arr.length > 0) {
                        this.ensureCapacity(this.size() + arr.length);
                        for (int i = 0; i < arr.length; ++i) {
                            this.add(arr[i]);
                        }
                    }
                } else if (array instanceof Collection) {
                    this.addAll((Collection)array);
                } else if (array instanceof Iterable) {
                    Iterator iterator = ((Iterable)array).iterator();
                    while (iterator.hasNext()) {
                        this.add(iterator.next());
                    }
                } else if (array instanceof Iterator) {
                    Iterator iterator = (Iterator)array;
                    while (iterator.hasNext()) {
                        this.add(iterator.next());
                    }
                } else {
                    throw new UnsupportedOperationException("Don't know how to spread " + array.getClass());
                }
            }
        }
    }

    private static class JetNullPointerException
    extends NullPointerException {
        private JetNullPointerException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            super.fillInStackTrace();
            return Intrinsics.sanitizeStackTrace(this);
        }
    }
}

