/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.LongIterator;
import jet.LongProgressionIterator;
import jet.Progression;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class LongRange
implements Range<Long>,
Progression<Long> {
    public static final LongRange EMPTY = new LongRange(1L, 0L);
    private final long start;
    private final long end;

    public LongRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean contains(Long item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public boolean contains(long item) {
        return this.start <= item && item <= this.end;
    }

    @Override
    public Long getStart() {
        return this.start;
    }

    @Override
    public Long getEnd() {
        return this.end;
    }

    @Override
    public Long getIncrement() {
        return 1L;
    }

    public LongIterator iterator() {
        return new LongProgressionIterator(this.start, this.end, 1L);
    }

    public String toString() {
        return this.start + ".." + this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongRange range = (LongRange)o;
        return this.end == range.end && this.start == range.start;
    }

    public int hashCode() {
        int result = (int)(this.start ^ this.start >>> 32);
        result = 31 * result + (int)(this.end ^ this.end >>> 32);
        return result;
    }
}

