/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isWriteToParcel", "", "parcelize.k2"})
@SourceDebugExtension(value={"SMAP\nFirParcelizeFunctionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirParcelizeFunctionChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeFunctionChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,38:1\n40#2:39\n*S KotlinDebug\n*F\n+ 1 FirParcelizeFunctionChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeFunctionChecker\n*L\n26#1:39\n*E\n"})
public final class FirParcelizeFunctionChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirParcelizeFunctionChecker INSTANCE = new FirParcelizeFunctionChecker();

    private FirParcelizeFunctionChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol containingClassSymbol;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeSimpleKotlinType coneSimpleKotlinType = declaration.getDispatchReceiverType();
        FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = coneSimpleKotlinType != null ? TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)((ConeKotlinType)coneSimpleKotlinType), (FirSession)context.getSession()) : null;
        if (!FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)containingClassSymbol, context.getSession())) {
            return;
        }
        if (!Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return;
        }
        if (this.isWriteToParcel(declaration)) {
            FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getOVERRIDING_WRITE_TO_PARCEL_IS_NOT_ALLOWED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        }
    }

    private final boolean isWriteToParcel(FirSimpleFunction $this$isWriteToParcel) {
        return $this$isWriteToParcel.getTypeParameters().isEmpty() && $this$isWriteToParcel.getValueParameters().size() == 2 && ConeBuiltinTypeUtilsKt.isInt((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)((FirValueParameter)$this$isWriteToParcel.getValueParameters().get(1)).getReturnTypeRef())) && ConeBuiltinTypeUtilsKt.isUnit((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)$this$isWriteToParcel.getReturnTypeRef()));
    }
}

