/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkDeprecatedAnnotations", "", "annotationCall", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isForbidden", "checkTypeParcelerUsage", "checkForRedundantTypeParceler", "enclosingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "annotationType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "checkWriteWithUsage", "checkIfTheContainingClassIsParcelize", "parcelize.k2"})
@SourceDebugExtension(value={"SMAP\nFirParcelizeAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirParcelizeAnnotationChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeAnnotationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1#2:158\n1#2:172\n1#2:189\n764#3:159\n855#3,2:160\n1601#3,9:162\n1853#3:171\n1854#3:173\n1610#3:174\n1772#3,4:175\n1601#3,9:179\n1853#3:188\n1854#3:190\n1610#3:191\n764#3:192\n855#3,2:193\n1745#3,2:195\n1724#3,3:197\n1747#3:200\n288#3,2:201\n*S KotlinDebug\n*F\n+ 1 FirParcelizeAnnotationChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeAnnotationChecker\n*L\n79#1:172\n109#1:189\n78#1:159\n78#1:160,2\n79#1:162,9\n79#1:171\n79#1:173\n79#1:174\n80#1:175,4\n109#1:179,9\n109#1:188\n109#1:190\n109#1:191\n110#1:192\n110#1:193,2\n111#1:195,2\n113#1:197,3\n111#1:200\n138#1:201,2\n*E\n"})
public final class FirParcelizeAnnotationChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirParcelizeAnnotationChecker INSTANCE = new FirParcelizeAnnotationChecker();

    private FirParcelizeAnnotationChecker() {
        super(MppCheckerKind.Platform);
    }

    public void check(@NotNull FirAnnotationCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeKotlinType coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)expression.getAnnotationTypeRef()), (FirSession)context.getSession());
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType annotationType = coneClassLikeType;
        FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)annotationType.getLookupTag(), (FirSession)context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol resolvedAnnotationSymbol = firRegularClassSymbol;
        ClassId annotationClassId = resolvedAnnotationSymbol.getClassId();
        if (ParcelizeNames.INSTANCE.getTYPE_PARCELER_CLASS_IDS().contains(annotationClassId)) {
            if (this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, true)) {
                this.checkTypeParcelerUsage(expression, context, reporter);
            }
        } else if (ParcelizeNames.INSTANCE.getWRITE_WITH_CLASS_IDS().contains(annotationClassId)) {
            if (this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, true)) {
                this.checkWriteWithUsage(expression, context, reporter);
            }
        } else if (ParcelizeNames.INSTANCE.getIGNORED_ON_PARCEL_CLASS_IDS().contains(annotationClassId)) {
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, false);
        } else if (ParcelizeNames.INSTANCE.getPARCELIZE_CLASS_CLASS_IDS().contains(annotationClassId) || ParcelizeNames.INSTANCE.getRAW_VALUE_ANNOTATION_CLASS_IDS().contains(annotationClassId)) {
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, false);
        }
    }

    private final boolean checkDeprecatedAnnotations(FirAnnotationCall annotationCall, ClassId annotationClassId, CheckerContext context, DiagnosticReporter reporter, boolean isForbidden) {
        if (Intrinsics.areEqual((Object)annotationClassId.getPackageFqName(), (Object)ParcelizeNames.INSTANCE.getDEPRECATED_RUNTIME_PACKAGE())) {
            KtDiagnosticFactory0 factory = isForbidden ? KtErrorsParcelize.INSTANCE.getFORBIDDEN_DEPRECATED_ANNOTATION() : KtErrorsParcelize.INSTANCE.getDEPRECATED_ANNOTATION();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotationCall.getSource()), (KtDiagnosticFactory0)factory, (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParcelerUsage(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
        Integer duplicatingAnnotationCount;
        Integer n;
        List list;
        List it = list = annotationCall.getTypeArguments();
        boolean bl = false;
        List list2 = it.size() == 2 ? list : null;
        if (list2 == null || (list2 = (FirTypeProjection)CollectionsKt.first((List)list2)) == null || (list2 = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)list2)) == null || (list2 = ConeTypeProjectionKt.getType((ConeTypeProjection)list2)) == null) {
            return;
        }
        List thisMappedType = list2;
        FirAnnotationContainer annotationContainer = (FirAnnotationContainer)CollectionsKt.lastOrNull((List)context.getAnnotationContainers());
        if (annotationContainer != null && (it = annotationContainer.getAnnotations()) != null) {
            int n2;
            void $this$count$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = it;
            boolean $i$f$filter22 = false;
            void var11_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirAnnotation it2 = (FirAnnotation)element$iv$iv;
                boolean bl2 = false;
                if (!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getTYPE_PARCELER_CLASS_IDS(), (Object)FirAnnotationUtilsKt.toAnnotationClassId((FirAnnotation)it2, (FirSession)context.getSession()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ConeKotlinType it$iv$iv;
                List list3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                FirAnnotation it3 = (FirAnnotation)element$iv$iv;
                boolean bl4 = false;
                List it4 = list3 = it3.getTypeArguments();
                boolean bl5 = false;
                List list4 = it4.size() == 2 ? list3 : null;
                if ((list4 != null && (list4 = (FirTypeProjection)CollectionsKt.first((List)list4)) != null && (list4 = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)list4)) != null ? ConeTypeProjectionKt.getType((ConeTypeProjection)list4) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ConeKotlinType it5 = (ConeKotlinType)element$iv;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it5, (Object)thisMappedType) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            n = n2;
        } else {
            n = duplicatingAnnotationCount = null;
        }
        if (duplicatingAnnotationCount != null && duplicatingAnnotationCount > 1) {
            FirTypeProjection firTypeProjection = (FirTypeProjection)CollectionsKt.firstOrNull((List)annotationCall.getTypeArguments());
            if (firTypeProjection == null || (firTypeProjection = firTypeProjection.getSource()) == null) {
                firTypeProjection = annotationCall.getSource();
            }
            FirTypeProjection reportElement = firTypeProjection;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getDUPLICATING_TYPE_PARCELERS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            return;
        }
        this.checkIfTheContainingClassIsParcelize(annotationCall, context, reporter);
        if (annotationContainer instanceof FirProperty && Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)((FirProperty)annotationContainer)), (Object)true)) {
            FirClass firClass = FirHelpersKt.findClosestClassOrObject((CheckerContext)context);
            if (firClass == null) {
                return;
            }
            FirClass enclosingClass = firClass;
            ConeClassLikeType coneClassLikeType = FirAnnotationUtilsKt.toAnnotationClassLikeType((FirAnnotation)((FirAnnotation)annotationCall), (FirSession)context.getSession());
            if (coneClassLikeType == null) {
                return;
            }
            ConeClassLikeType annotationType = coneClassLikeType;
            if (this.checkForRedundantTypeParceler(enclosingClass, annotationType, context)) {
                KtSourceElement ktSourceElement = annotationCall.getCalleeReference().getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = annotationCall.getSource();
                }
                KtSourceElement reportElement = ktSourceElement;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), KtErrorsParcelize.INSTANCE.getREDUNDANT_TYPE_PARCELER(), (Object)enclosingClass.getSymbol(), (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkForRedundantTypeParceler(FirClass enclosingClass, ConeClassLikeType annotationType, CheckerContext context) {
        boolean bl;
        block9: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Iterable iterable = enclosingClass.getAnnotations();
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ConeClassLikeType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                FirAnnotation it = (FirAnnotation)element$iv$iv;
                boolean bl3 = false;
                if (FirAnnotationUtilsKt.toAnnotationClassLikeType((FirAnnotation)it, (FirSession)context.getSession()) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv$iv;
                boolean bl5 = false;
                if (!(Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)it)), (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)annotationType))) && it.getTypeArguments().length == annotationType.getTypeArguments().length)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl6;
                    block8: {
                        void $this$all$iv;
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl7 = false;
                        Iterable element$iv$iv = ArraysKt.zip((Object[])it.getTypeArguments(), (Object[])annotationType.getTypeArguments());
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl6 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                Pair pair = (Pair)element$iv2;
                                boolean bl8 = false;
                                ConeTypeProjection first = (ConeTypeProjection)pair.component1();
                                ConeTypeProjection second = (ConeTypeProjection)pair.component2();
                                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)first);
                                ConeKotlinType coneKotlinType2 = ConeTypeProjectionKt.getType((ConeTypeProjection)second);
                                if (Intrinsics.areEqual((Object)(coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType, (FirSession)context.getSession()) : null), (Object)(coneKotlinType2 != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType2, (FirSession)context.getSession()) : null))) continue;
                                bl6 = false;
                                break block8;
                            }
                            bl6 = true;
                        }
                    }
                    if (!bl6) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkWriteWithUsage(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
        ConeKotlinType coneKotlinType;
        Iterable iterable;
        ConeKotlinType targetType;
        ConeKotlinType coneKotlinType2;
        FirTypeProjection parcelerType;
        block13: {
            block12: {
                Object v4;
                block11: {
                    void $this$firstOrNull$iv;
                    Object object;
                    FirTypeRef firTypeRef;
                    FirRegularClassSymbol parcelerTypeSymbol;
                    this.checkIfTheContainingClassIsParcelize(annotationCall, context, reporter);
                    FirTypeProjection firTypeProjection = (FirTypeProjection)CollectionsKt.singleOrNull((List)annotationCall.getTypeArguments());
                    if (firTypeProjection == null || (firTypeProjection = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)firTypeProjection)) == null || (firTypeProjection = ConeTypeProjectionKt.getType((ConeTypeProjection)firTypeProjection)) == null) {
                        return;
                    }
                    parcelerType = firTypeProjection;
                    FirRegularClassSymbol firRegularClassSymbol = parcelerTypeSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)parcelerType, (FirSession)context.getSession());
                    if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) != ClassKind.OBJECT) {
                        FirTypeProjection firTypeProjection2 = (FirTypeProjection)CollectionsKt.singleOrNull((List)annotationCall.getTypeArguments());
                        if (firTypeProjection2 == null || (firTypeProjection2 = firTypeProjection2.getSource()) == null) {
                            firTypeProjection2 = annotationCall.getSource();
                        }
                        FirTypeProjection reportElement = firTypeProjection2;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELER_SHOULD_BE_OBJECT(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                    }
                    FirTypeRef firTypeRef2 = firTypeRef = (object = CollectionsKt.lastOrNull((List)context.getAnnotationContainers())) instanceof FirTypeRef ? (FirTypeRef)object : null;
                    if (firTypeRef == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)firTypeRef)) == null || (coneKotlinType2 = TypeUtilsKt.withAttributes((ConeKotlinType)object, (ConeAttributes)ConeAttributes.Companion.getEmpty())) == null) {
                        return;
                    }
                    targetType = coneKotlinType2;
                    if (parcelerTypeSymbol == null || (object = SupertypeUtilsKt.getSuperTypes$default((FirClassLikeSymbol)((FirClassLikeSymbol)parcelerTypeSymbol), (FirSession)context.getSession(), (boolean)false, (boolean)false, (boolean)false, null, (int)30, null)) == null) break block12;
                    iterable = (Iterable)object;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)it)), (Object)ParcelizeNames.INSTANCE.getPARCELER_ID())) continue;
                        v4 = element$iv;
                        break block11;
                    }
                    v4 = null;
                }
                coneKotlinType2 = v4;
                if (coneKotlinType2 != null) break block13;
            }
            return;
        }
        ConeKotlinType parcelerSuperType = coneKotlinType2;
        coneKotlinType2 = (ConeTypeProjection)ArraysKt.singleOrNull((Object[])parcelerSuperType.getTypeArguments());
        if (coneKotlinType2 == null || (iterable = ConeTypeProjectionKt.getType((ConeTypeProjection)coneKotlinType2)) == null || (coneKotlinType = TypeUtilsKt.withAttributes((ConeKotlinType)iterable, (ConeAttributes)ConeAttributes.Companion.getEmpty())) == null) {
            return;
        }
        ConeKotlinType expectedType = coneKotlinType;
        if (!TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)targetType, (ConeKotlinType)expectedType, (FirSession)context.getSession(), (boolean)false, (int)4, null)) {
            FirTypeProjection firTypeProjection = (FirTypeProjection)CollectionsKt.singleOrNull((List)annotationCall.getTypeArguments());
            if (firTypeProjection == null || (firTypeProjection = firTypeProjection.getSource()) == null) {
                firTypeProjection = annotationCall.getSource();
            }
            FirTypeProjection reportElement = firTypeProjection;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), KtErrorsParcelize.INSTANCE.getPARCELER_TYPE_INCOMPATIBLE(), (Object)parcelerType, (Object)targetType, (DiagnosticContext)((DiagnosticContext)context), null, (int)32, null);
        }
    }

    private final void checkIfTheContainingClassIsParcelize(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
        FirClass firClass = FirHelpersKt.findClosestClassOrObject((CheckerContext)context);
        if (firClass == null) {
            return;
        }
        FirClass enclosingClass = firClass;
        if (!FirParcelizeClassCheckerKt.isParcelize(enclosingClass.getSymbol(), context.getSession())) {
            KtSourceElement ktSourceElement = annotationCall.getCalleeReference().getSource();
            if (ktSourceElement == null) {
                ktSourceElement = annotationCall.getSource();
            }
            KtSourceElement reportElement = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), KtErrorsParcelize.INSTANCE.getCLASS_SHOULD_BE_PARCELIZE(), (Object)enclosingClass.getSymbol(), (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
        }
    }
}

