/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import org.jetbrains.kotlin.fir.resolve.CallableIdUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.parcelize.BuiltinParcelableTypes;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u001f\u001a\u00020\u001a*\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010 \u001a\u00020\u001a*\u00020\u0003H\u0002J\u0012\u0010 \u001a\u00020\u001a*\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0014\u0010!\u001a\u00020\u001a*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizePropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkParcelableClassProperty", "property", "containingClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getCustomParcelerTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "annotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkParcelableType", "", "type", "customParcelerTypes", "getErasedUpperBound", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "hasParcelerAnnotation", "hasIgnoredOnParcel", "hasCustomParceler", "parcelize.k2"})
@SourceDebugExtension(value={"SMAP\nFirParcelizePropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirParcelizePropertyChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizePropertyChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,170:1\n56#2:171\n1609#3:172\n1853#3:173\n1854#3:175\n1610#3:176\n288#3,2:181\n1745#3,3:183\n1745#3,3:186\n1#4:174\n1#4:179\n37#5:177\n12253#6:178\n12254#6:180\n*S KotlinDebug\n*F\n+ 1 FirParcelizePropertyChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizePropertyChecker\n*L\n54#1:171\n81#1:172\n81#1:173\n81#1:175\n81#1:176\n129#1:181,2\n156#1:183,3\n165#1:186,3\n81#1:174\n98#1:177\n108#1:178\n108#1:180\n*E\n"})
public final class FirParcelizePropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirParcelizePropertyChecker INSTANCE = new FirParcelizePropertyChecker();

    private FirParcelizePropertyChecker() {
    }

    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirSession session = context.getSession();
        ConeSimpleKotlinType coneSimpleKotlinType = declaration.getDispatchReceiverType();
        if (coneSimpleKotlinType == null || (coneSimpleKotlinType = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)((ConeKotlinType)coneSimpleKotlinType), (FirSession)session)) == null) {
            return;
        }
        ConeSimpleKotlinType containingClassSymbol = coneSimpleKotlinType;
        if (FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)containingClassSymbol, session)) {
            boolean fromPrimaryConstructor;
            Boolean bl = DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)declaration);
            boolean bl2 = fromPrimaryConstructor = bl != null ? bl : false;
            if (!(fromPrimaryConstructor || !DeclarationAttributesKt.getHasBackingField((FirProperty)declaration) && declaration.getDelegate() == null || this.hasIgnoredOnParcel(declaration) || this.hasCustomParceler((FirRegularClassSymbol)containingClassSymbol, session))) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPROPERTY_WONT_BE_SERIALIZED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
            if (fromPrimaryConstructor) {
                this.checkParcelableClassProperty(declaration, (FirRegularClassSymbol)containingClassSymbol, context, reporter);
            }
        }
        if (Intrinsics.areEqual((Object)declaration.getName(), (Object)ParcelizeNames.INSTANCE.getCREATOR_NAME())) {
            FirClassLikeSymbol $this$isCompanion$iv = (FirClassLikeSymbol)containingClassSymbol;
            boolean $i$f$isCompanion = false;
            if ($this$isCompanion$iv.getRawStatus().isCompanion() && JavaUtilsKt.hasJvmFieldAnnotation((FirProperty)declaration, (FirSession)session)) {
                FirRegularClass outerClass;
                Object object = CollectionsKt.getOrNull((List)CollectionsKt.asReversed((List)context.getContainingDeclarations()), (int)1);
                FirRegularClass firRegularClass = outerClass = object instanceof FirRegularClass ? (FirRegularClass)object : null;
                if (outerClass != null && FirParcelizeClassCheckerKt.isParcelize((FirClassSymbol)outerClass.getSymbol(), session)) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getCREATOR_DEFINITION_IS_NOT_ALLOWED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                }
            }
        }
    }

    private final void checkParcelableClassProperty(FirProperty property, FirRegularClassSymbol containingClassSymbol, CheckerContext context, DiagnosticReporter reporter) {
        ConeKotlinType type = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)property.getReturnTypeRef()), (FirSession)context.getSession());
        if (type instanceof ConeErrorType || this.hasCustomParceler(containingClassSymbol, context.getSession()) || this.hasIgnoredOnParcel(property)) {
            return;
        }
        FirSession session = context.getSession();
        Set<ConeKotlinType> customParcelerTypes = this.getCustomParcelerTypes(CollectionsKt.plus((Collection)property.getAnnotations(), (Iterable)containingClassSymbol.getAnnotations()), session);
        if (!this.checkParcelableType(type, customParcelerTypes, session)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)property.getReturnTypeRef().getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_TYPE_NOT_SUPPORTED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ConeKotlinType> getCustomParcelerTypes(List<? extends FirAnnotation> annotations, FirSession session) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = annotations;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            FirAnnotation annotation = (FirAnnotation)element$iv;
            boolean bl2 = false;
            if (CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getTYPE_PARCELER_FQ_NAMES(), (Object)CallableIdUtilsKt.fqName((FirAnnotation)annotation, (FirSession)session)) && annotation.getTypeArguments().size() == 2) {
                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)((FirTypeProjection)annotation.getTypeArguments().get(0))));
                object = coneKotlinType != null ? TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)coneKotlinType, (FirSession)session) : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            ConeKotlinType it$iv = object;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final boolean checkParcelableType(ConeKotlinType type, Set<? extends ConeKotlinType> customParcelerTypes, FirSession session) {
        ConeClassLikeType symbol;
        ConeClassLikeType upperBound;
        block13: {
            block12: {
                if (this.hasParcelerAnnotation(type, session) || customParcelerTypes.contains(type)) {
                    return true;
                }
                upperBound = this.getErasedUpperBound(type, session);
                ConeClassLikeType coneClassLikeType = upperBound;
                if (coneClassLikeType == null || (coneClassLikeType = TypeUtilsKt.toRegularClassSymbol((ConeClassLikeType)coneClassLikeType, (FirSession)session)) == null) {
                    return false;
                }
                symbol = coneClassLikeType;
                if (symbol.getClassKind().isSingleton()) break block12;
                ClassKind $this$isEnumClass$iv = symbol.getClassKind();
                boolean $i$f$isEnumClass = false;
                if (!($this$isEnumClass$iv == ClassKind.ENUM_CLASS)) break block13;
            }
            return true;
        }
        String fqName = symbol.getClassId().asFqNameString();
        if (BuiltinParcelableTypes.INSTANCE.getPARCELABLE_BASE_TYPE_FQNAMES().contains(fqName)) {
            return true;
        }
        if (BuiltinParcelableTypes.INSTANCE.getPARCELABLE_CONTAINER_FQNAMES().contains(fqName)) {
            boolean bl;
            block11: {
                ConeTypeProjection[] $this$all$iv = upperBound.getTypeArguments();
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl2;
                    ConeTypeProjection element$iv;
                    ConeTypeProjection projection = element$iv = $this$all$iv[i];
                    boolean bl3 = false;
                    if (ConeTypeProjectionKt.getType((ConeTypeProjection)projection) != null) {
                        ConeKotlinType it;
                        boolean bl4 = false;
                        bl2 = INSTANCE.checkParcelableType(it, customParcelerTypes, session);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
            return bl;
        }
        ConeInferenceContext $this$checkParcelableType_u24lambda_u243 = TypeComponentsKt.getTypeContext((FirSession)session);
        boolean bl = false;
        return $this$checkParcelableType_u24lambda_u243.anySuperTypeConstructor((KotlinTypeMarker)type, (Function1)new Function1<SimpleTypeMarker, Boolean>(session){
            final /* synthetic */ FirSession $session;
            {
                this.$session = $session;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(SimpleTypeMarker it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof ConeKotlinType) {
                    ClassId classId = ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)it));
                    if (CollectionsKt.contains((Iterable)BuiltinParcelableTypes.INSTANCE.getPARCELABLE_SUPERTYPE_FQNAMES(), (Object)(classId != null ? classId.asFqNameString() : null)) || FunctionalTypeUtilsKt.isSomeFunctionType((ConeKotlinType)((ConeKotlinType)it), (FirSession)this.$session)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
    }

    private final ConeClassLikeType getErasedUpperBound(ConeKotlinType $this$getErasedUpperBound, FirSession session) {
        ConeClassLikeType coneClassLikeType;
        ConeKotlinType coneKotlinType = $this$getErasedUpperBound;
        if (coneKotlinType instanceof ConeClassLikeType) {
            coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)((ConeClassLikeType)$this$getErasedUpperBound), (FirSession)session, null, (int)2, null);
        } else if (coneKotlinType instanceof ConeTypeParameterType) {
            FirResolvedTypeRef firResolvedTypeRef;
            Object v2;
            List bounds;
            block6: {
                bounds = ((ConeTypeParameterType)$this$getErasedUpperBound).getLookupTag().getTypeParameterSymbol().getResolvedBounds();
                Iterable $this$firstOrNull$iv = bounds;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirRegularClassSymbol kind;
                    FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
                    boolean bl = false;
                    FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)((FirTypeRef)it)), (FirSession)session);
                    if (!(firRegularClassSymbol == null || (firRegularClassSymbol = firRegularClassSymbol.getClassKind()) == null ? false : (kind = firRegularClassSymbol) != ClassKind.INTERFACE && kind != ClassKind.ANNOTATION_CLASS)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            if ((firResolvedTypeRef = (FirResolvedTypeRef)v2) == null) {
                firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.first((List)bounds);
            }
            FirResolvedTypeRef representativeBound = firResolvedTypeRef;
            coneClassLikeType = this.getErasedUpperBound(FirTypeUtilsKt.getConeType((FirTypeRef)((FirTypeRef)representativeBound)), session);
        } else {
            coneClassLikeType = null;
        }
        return coneClassLikeType;
    }

    private final boolean hasParcelerAnnotation(ConeKotlinType $this$hasParcelerAnnotation, FirSession session) {
        for (FirAnnotation annotation : CustomAnnotationTypeAttributeKt.getCustomAnnotations((ConeKotlinType)$this$hasParcelerAnnotation)) {
            FqName fqName = CallableIdUtilsKt.fqName((FirAnnotation)annotation, (FirSession)session);
            if (!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getRAW_VALUE_ANNOTATION_FQ_NAMES(), (Object)fqName) && !CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getWRITE_WITH_FQ_NAMES(), (Object)fqName)) continue;
            return true;
        }
        return false;
    }

    private final boolean hasIgnoredOnParcel(FirProperty $this$hasIgnoredOnParcel) {
        Object object;
        return this.hasIgnoredOnParcel($this$hasIgnoredOnParcel.getAnnotations()) || ((object = $this$hasIgnoredOnParcel.getGetter()) != null && (object = object.getAnnotations()) != null ? this.hasIgnoredOnParcel((List<? extends FirAnnotation>)object) : false);
    }

    private final boolean hasIgnoredOnParcel(List<? extends FirAnnotation> $this$hasIgnoredOnParcel) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasIgnoredOnParcel;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AnnotationUseSiteTarget target;
                    FirAnnotation it = (FirAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!(!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getIGNORED_ON_PARCEL_CLASS_IDS(), (Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)it.getAnnotationTypeRef()))) ? false : (target = it.getUseSiteTarget()) == null || target == AnnotationUseSiteTarget.PROPERTY || target == AnnotationUseSiteTarget.PROPERTY_GETTER)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasCustomParceler(FirRegularClassSymbol $this$hasCustomParceler, FirSession session) {
        boolean bl;
        block4: {
            FirRegularClassSymbol firRegularClassSymbol = $this$hasCustomParceler.getCompanionObjectSymbol();
            if (firRegularClassSymbol == null) {
                return false;
            }
            FirRegularClassSymbol companionObjectSymbol = firRegularClassSymbol;
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes((FirClassLikeSymbol)((FirClassLikeSymbol)companionObjectSymbol), (boolean)true, (boolean)true, (FirSession)session);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)it)), (Object)ParcelizeNames.INSTANCE.getPARCELER_ID())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }
}

