/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.diagnostic;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.parcelize.diagnostic.ErrorsParcelize;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/parcelize/diagnostic/DefaultErrorMessagesParcelize;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DefaultErrorMessages$Extension;", "<init>", "()V", "MAP", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticFactoryToRendererMap;", "getMap", "parcelize.k1"})
public final class DefaultErrorMessagesParcelize
implements DefaultErrorMessages.Extension {
    @NotNull
    public static final DefaultErrorMessagesParcelize INSTANCE = new DefaultErrorMessagesParcelize();
    @NotNull
    private static final DiagnosticFactoryToRendererMap MAP = new DiagnosticFactoryToRendererMap("Parcelize");

    private DefaultErrorMessagesParcelize() {
    }

    @NotNull
    public DiagnosticFactoryToRendererMap getMap() {
        return MAP;
    }

    static {
        MAP.put(ErrorsParcelize.PARCELABLE_SHOULD_BE_CLASS, "'Parcelable' should be a class");
        MAP.put(ErrorsParcelize.PARCELABLE_DELEGATE_IS_NOT_ALLOWED, "Delegating 'Parcelable' is not allowed");
        MAP.put(ErrorsParcelize.PARCELABLE_SHOULD_NOT_BE_ENUM_CLASS, "'Parcelable' should not be a 'enum class'");
        MAP.put(ErrorsParcelize.PARCELABLE_SHOULD_BE_INSTANTIABLE, "'Parcelable' should not be an 'abstract' class");
        MAP.put(ErrorsParcelize.PARCELABLE_CANT_BE_INNER_CLASS, "'Parcelable' can't be an inner class");
        MAP.put(ErrorsParcelize.PARCELABLE_CANT_BE_LOCAL_CLASS, "'Parcelable' can't be a local class");
        MAP.put(ErrorsParcelize.NO_PARCELABLE_SUPERTYPE, "No 'Parcelable' supertype");
        MAP.put(ErrorsParcelize.PARCELABLE_SHOULD_HAVE_PRIMARY_CONSTRUCTOR, "'Parcelable' should have a primary constructor");
        MAP.put(ErrorsParcelize.PARCELABLE_PRIMARY_CONSTRUCTOR_IS_EMPTY, "The primary constructor is empty, no data will be serialized to 'Parcel'");
        MAP.put(ErrorsParcelize.PARCELABLE_CONSTRUCTOR_PARAMETER_SHOULD_BE_VAL_OR_VAR, "'Parcelable' constructor parameter should be 'val' or 'var'");
        MAP.put(ErrorsParcelize.PROPERTY_WONT_BE_SERIALIZED, "Property would not be serialized into a 'Parcel'. Add '@IgnoredOnParcel' annotation to remove the warning");
        MAP.put(ErrorsParcelize.OVERRIDING_WRITE_TO_PARCEL_IS_NOT_ALLOWED, "Overriding 'writeToParcel' is not allowed. Use 'Parceler' companion object instead");
        MAP.put(ErrorsParcelize.CREATOR_DEFINITION_IS_NOT_ALLOWED, "'CREATOR' definition is not allowed. Use 'Parceler' companion object instead");
        MAP.put(ErrorsParcelize.PARCELABLE_TYPE_NOT_SUPPORTED, "Type is not directly supported by 'Parcelize'. Annotate the parameter type with '@RawValue' if you want it to be serialized using 'writeValue()'");
        MAP.put(ErrorsParcelize.PARCELER_SHOULD_BE_OBJECT, "Parceler should be an object");
        MAP.put(ErrorsParcelize.PARCELER_TYPE_INCOMPATIBLE, "Parceler type {0} is incompatible with {1}", (DiagnosticParameterRenderer)Renderers.RENDER_TYPE_WITH_ANNOTATIONS, (DiagnosticParameterRenderer)Renderers.RENDER_TYPE_WITH_ANNOTATIONS);
        MAP.put(ErrorsParcelize.DUPLICATING_TYPE_PARCELERS, "Duplicating ''TypeParceler'' annotations");
        MAP.put(ErrorsParcelize.REDUNDANT_TYPE_PARCELER, "This ''TypeParceler'' is already provided for {0}", (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT);
        MAP.put(ErrorsParcelize.CLASS_SHOULD_BE_PARCELIZE, "{0} should be annotated with ''@Parcelize''", (DiagnosticParameterRenderer)Renderers.RENDER_CLASS_OR_OBJECT);
        MAP.put(ErrorsParcelize.INAPPLICABLE_IGNORED_ON_PARCEL, "'@IgnoredOnParcel' is only applicable to class properties");
        MAP.put(ErrorsParcelize.INAPPLICABLE_IGNORED_ON_PARCEL_CONSTRUCTOR_PROPERTY, "'@IgnoredOnParcel' is inapplicable to properties without default value declared in the primary constructor");
        MAP.put(ErrorsParcelize.FORBIDDEN_DEPRECATED_ANNOTATION, "Parceler-related annotations from package 'kotlinx.android.parcel' are forbidden. Change package to 'kotlinx.parcelize'");
        MAP.put(ErrorsParcelize.DEPRECATED_ANNOTATION, "Parcelize annotations from package 'kotlinx.android.parcel' are deprecated. Change package to 'kotlinx.parcelize'");
        MAP.put(ErrorsParcelize.DEPRECATED_PARCELER, "'kotlinx.android.parcel.Parceler' is deprecated. Use 'kotlinx.parcelize.Parceler' instead");
    }
}

