/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkDeprecatedAnnotations", "", "annotationCall", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isForbidden", "checkIfTheContainingClassIsParcelize", "checkTypeParcelerUsage", "checkWriteWithUsage", "parcelize.k2"})
@SourceDebugExtension(value={"SMAP\nFirParcelizeAnnotationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirParcelizeAnnotationChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeAnnotationChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,143:1\n1#2:144\n1#2:158\n766#3:145\n857#3,2:146\n1603#3,9:148\n1855#3:157\n1856#3:159\n1612#3:160\n1774#3,4:161\n*S KotlinDebug\n*F\n+ 1 FirParcelizeAnnotationChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeAnnotationChecker\n*L\n80#1:158\n79#1:145\n79#1:146,2\n80#1:148,9\n80#1:157\n80#1:159\n80#1:160\n81#1:161,4\n*E\n"})
public final class FirParcelizeAnnotationChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirParcelizeAnnotationChecker INSTANCE = new FirParcelizeAnnotationChecker();

    private FirParcelizeAnnotationChecker() {
    }

    public void check(@NotNull FirAnnotationCall expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeKotlinType coneKotlinType = TypeExpansionUtilsKt.fullyExpandedType((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)expression.getAnnotationTypeRef()), (FirSession)context.getSession());
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType annotationType = coneClassLikeType;
        FirRegularClassSymbol firRegularClassSymbol = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)annotationType.getLookupTag(), (FirSession)context.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol resolvedAnnotationSymbol = firRegularClassSymbol;
        ClassId annotationClassId = resolvedAnnotationSymbol.getClassId();
        if (ParcelizeNames.INSTANCE.getTYPE_PARCELER_CLASS_IDS().contains(annotationClassId)) {
            if (this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, true)) {
                this.checkTypeParcelerUsage(expression, context, reporter);
            }
        } else if (ParcelizeNames.INSTANCE.getWRITE_WITH_CLASS_IDS().contains(annotationClassId)) {
            if (this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, true)) {
                this.checkWriteWithUsage(expression, context, reporter);
            }
        } else if (ParcelizeNames.INSTANCE.getIGNORED_ON_PARCEL_CLASS_IDS().contains(annotationClassId)) {
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, false);
        } else if (ParcelizeNames.INSTANCE.getPARCELIZE_CLASS_CLASS_IDS().contains(annotationClassId) ? true : ParcelizeNames.INSTANCE.getRAW_VALUE_ANNOTATION_CLASS_IDS().contains(annotationClassId)) {
            this.checkDeprecatedAnnotations(expression, annotationClassId, context, reporter, false);
        }
    }

    private final boolean checkDeprecatedAnnotations(FirAnnotationCall annotationCall, ClassId annotationClassId, CheckerContext context, DiagnosticReporter reporter, boolean isForbidden) {
        if (Intrinsics.areEqual((Object)annotationClassId.getPackageFqName(), (Object)ParcelizeNames.INSTANCE.getDEPRECATED_RUNTIME_PACKAGE())) {
            KtDiagnosticFactory0 factory = isForbidden ? KtErrorsParcelize.INSTANCE.getFORBIDDEN_DEPRECATED_ANNOTATION() : KtErrorsParcelize.INSTANCE.getDEPRECATED_ANNOTATION();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotationCall.getSource()), (KtDiagnosticFactory0)factory, (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParcelerUsage(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
        Integer duplicatingAnnotationCount;
        Integer n;
        List list;
        List it = list = annotationCall.getTypeArguments();
        boolean bl = false;
        List list2 = it.size() == 2 ? list : null;
        if (list2 == null || (list2 = (FirTypeProjection)CollectionsKt.first((List)list2)) == null || (list2 = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)list2)) == null || (list2 = ConeTypeProjectionKt.getType((ConeTypeProjection)list2)) == null) {
            return;
        }
        List thisMappedType = list2;
        FirAnnotationContainer annotationContainer = (FirAnnotationContainer)CollectionsKt.lastOrNull((List)context.getAnnotationContainers());
        if (annotationContainer != null && (it = annotationContainer.getAnnotations()) != null) {
            int n2;
            void $this$count$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = it;
            boolean $i$f$filter22 = false;
            void var11_13 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirAnnotation it2 = (FirAnnotation)element$iv$iv;
                boolean bl2 = false;
                if (!CollectionsKt.contains((Iterable)ParcelizeNames.INSTANCE.getTYPE_PARCELER_CLASS_IDS(), (Object)FirAnnotationUtilsKt.toAnnotationClassId((FirAnnotation)it2, (FirSession)context.getSession()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ConeKotlinType it$iv$iv;
                List list3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                FirAnnotation it3 = (FirAnnotation)element$iv$iv;
                boolean bl4 = false;
                List it4 = list3 = it3.getTypeArguments();
                boolean bl5 = false;
                List list4 = it4.size() == 2 ? list3 : null;
                if ((list4 != null && (list4 = (FirTypeProjection)CollectionsKt.first((List)list4)) != null && (list4 = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)list4)) != null ? ConeTypeProjectionKt.getType((ConeTypeProjection)list4) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ConeKotlinType it5 = (ConeKotlinType)element$iv;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it5, (Object)thisMappedType) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            n = n2;
        } else {
            n = duplicatingAnnotationCount = null;
        }
        if (duplicatingAnnotationCount != null && duplicatingAnnotationCount > 1) {
            FirTypeProjection firTypeProjection = (FirTypeProjection)CollectionsKt.firstOrNull((List)annotationCall.getTypeArguments());
            if (firTypeProjection == null || (firTypeProjection = firTypeProjection.getSource()) == null) {
                firTypeProjection = annotationCall.getSource();
            }
            FirTypeProjection reportElement = firTypeProjection;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getDUPLICATING_TYPE_PARCELERS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            return;
        }
        this.checkIfTheContainingClassIsParcelize(annotationCall, context, reporter);
        if (annotationContainer instanceof FirProperty && Intrinsics.areEqual((Object)DeclarationAttributesKt.getFromPrimaryConstructor((FirProperty)((FirProperty)annotationContainer)), (Object)true)) {
            FirClass firClass = FirHelpersKt.findClosestClassOrObject((CheckerContext)context);
            if (firClass == null) {
                return;
            }
            FirClass enclosingClass = firClass;
            ConeClassLikeType coneClassLikeType = FirAnnotationUtilsKt.toAnnotationClassLikeType((FirAnnotation)((FirAnnotation)annotationCall), (FirSession)context.getSession());
            if (coneClassLikeType == null) {
                return;
            }
            ConeClassLikeType annotationType = coneClassLikeType;
            if (FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)((FirDeclaration)enclosingClass), (ConeClassLikeType)annotationType, (FirSession)context.getSession())) {
                KtSourceElement ktSourceElement = annotationCall.getCalleeReference().getSource();
                if (ktSourceElement == null) {
                    ktSourceElement = annotationCall.getSource();
                }
                KtSourceElement reportElement = ktSourceElement;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), KtErrorsParcelize.INSTANCE.getREDUNDANT_TYPE_PARCELER(), (Object)enclosingClass.getSymbol(), (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
            }
        }
    }

    private final void checkWriteWithUsage(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
        ConeKotlinType[] coneKotlinTypeArray;
        FirTypeRef firTypeRef;
        this.checkIfTheContainingClassIsParcelize(annotationCall, context, reporter);
        FirTypeProjection firTypeProjection = (FirTypeProjection)CollectionsKt.singleOrNull((List)annotationCall.getTypeArguments());
        if (firTypeProjection == null || (firTypeProjection = FirTypeUtilsKt.toConeTypeProjection((FirTypeProjection)firTypeProjection)) == null || (firTypeProjection = ConeTypeProjectionKt.getType((ConeTypeProjection)firTypeProjection)) == null) {
            return;
        }
        FirTypeProjection parcelerType = firTypeProjection;
        FirRegularClassSymbol firRegularClassSymbol = TypeUtilsKt.toRegularClassSymbol((ConeKotlinType)parcelerType, (FirSession)context.getSession());
        if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) != ClassKind.OBJECT) {
            FirTypeProjection firTypeProjection2 = (FirTypeProjection)CollectionsKt.singleOrNull((List)annotationCall.getTypeArguments());
            if (firTypeProjection2 == null || (firTypeProjection2 = firTypeProjection2.getSource()) == null) {
                firTypeProjection2 = annotationCall.getSource();
            }
            FirTypeProjection reportElement = firTypeProjection2;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELER_SHOULD_BE_OBJECT(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
        if ((firTypeRef = (coneKotlinTypeArray = CollectionsKt.lastOrNull((List)context.getAnnotationContainers())) instanceof FirTypeRef ? (FirTypeRef)coneKotlinTypeArray : null) == null || (firTypeRef = FirTypeUtilsKt.getConeType((FirTypeRef)firTypeRef)) == null || (firTypeRef = TypeUtilsKt.withAttributes((ConeKotlinType)firTypeRef, (ConeAttributes)ConeAttributes.Companion.getEmpty())) == null) {
            return;
        }
        FirTypeRef targetType = firTypeRef;
        coneKotlinTypeArray = new ConeKotlinType[]{targetType};
        ConeClassLikeTypeImpl expectedType = new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)TypeConstructionUtilsKt.toLookupTag((ClassId)ParcelizeNames.INSTANCE.getPARCELER_ID()), (ConeTypeProjection[])coneKotlinTypeArray, false, null, 8, null);
        if (!TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)parcelerType, (ConeKotlinType)((ConeKotlinType)expectedType), (FirSession)context.getSession(), (boolean)false, (int)4, null)) {
            FirTypeProjection firTypeProjection3 = (FirTypeProjection)CollectionsKt.singleOrNull((List)annotationCall.getTypeArguments());
            if (firTypeProjection3 == null || (firTypeProjection3 = firTypeProjection3.getSource()) == null) {
                firTypeProjection3 = annotationCall.getSource();
            }
            FirTypeProjection reportElement = firTypeProjection3;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), KtErrorsParcelize.INSTANCE.getPARCELER_TYPE_INCOMPATIBLE(), (Object)parcelerType, (Object)targetType, (DiagnosticContext)((DiagnosticContext)context), null, (int)32, null);
        }
    }

    private final void checkIfTheContainingClassIsParcelize(FirAnnotationCall annotationCall, CheckerContext context, DiagnosticReporter reporter) {
        FirClass firClass = FirHelpersKt.findClosestClassOrObject((CheckerContext)context);
        if (firClass == null) {
            return;
        }
        FirClass enclosingClass = firClass;
        if (!FirParcelizeClassCheckerKt.isParcelize(enclosingClass.getSymbol(), context.getSession())) {
            KtSourceElement ktSourceElement = annotationCall.getCalleeReference().getSource();
            if (ktSourceElement == null) {
                ktSourceElement = annotationCall.getSource();
            }
            KtSourceElement reportElement = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)reportElement), KtErrorsParcelize.INSTANCE.getCLASS_SHOULD_BE_PARCELIZE(), (Object)enclosingClass.getSymbol(), (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
        }
    }
}

