/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.IgnoredOnParcel;
import kotlinx.parcelize.TypeParceler;
import kotlinx.parcelize.WriteWith;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.parcelize.ParcelizeAnnotationChecker;
import org.jetbrains.kotlin.parcelize.ParcelizeResolveExtensionKt;
import org.jetbrains.kotlin.parcelize.diagnostic.ErrorsParcelize;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\"\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0013\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0014\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/parcelize/ParcelizeAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkIfTheContainingClassIsParcelize", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIgnoredOnParcelUsage", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "checkTypeParcelerUsage", "checkWriteWithUsage", "Companion", "parcelize-compiler"})
public final class ParcelizeAnnotationChecker
implements CallChecker {
    private static final List<FqName> TYPE_PARCELER_FQ_NAMES;
    private static final List<FqName> WRITE_WITH_FQ_NAMES;
    private static final List<FqName> IGNORED_ON_PARCEL_FQ_NAMES;
    @NotNull
    public static final Companion Companion;

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        if (!(callableDescriptor instanceof ClassConstructorDescriptor)) {
            callableDescriptor = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)callableDescriptor;
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        ClassDescriptor classDescriptor = constructorDescriptor.getConstructedClass();
        boolean bl = false;
        boolean bl2 = false;
        ClassDescriptor it = classDescriptor;
        boolean bl3 = false;
        ClassDescriptor classDescriptor2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor2, (String)"it");
        Object object = classDescriptor2.getKind() == ClassKind.ANNOTATION_CLASS ? classDescriptor : null;
        if (object == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"constructorDescriptor.co\u2026OTATION_CLASS } ?: return");
        ClassDescriptor annotationClass = object;
        Call call = resolvedCall.getCall();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"resolvedCall.call");
        KtElement ktElement = call.getCallElement();
        Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"resolvedCall.call.callElement");
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)ktElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtAnnotationEntry.class, (boolean)false);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)annotationEntry;
        boolean $i$f$getStrictParentOfType = false;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtModifierListOwner.class, (boolean)true);
        if (ktModifierListOwner == null) {
            return;
        }
        KtModifierListOwner annotationOwner = ktModifierListOwner;
        if (TYPE_PARCELER_FQ_NAMES.contains(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)))) {
            this.checkTypeParcelerUsage(resolvedCall, annotationEntry, context, annotationOwner);
        }
        if (WRITE_WITH_FQ_NAMES.contains(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)))) {
            this.checkWriteWithUsage(resolvedCall, annotationEntry, context, annotationOwner);
        }
        if (IGNORED_ON_PARCEL_FQ_NAMES.contains(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)))) {
            this.checkIgnoredOnParcelUsage(annotationEntry, context, annotationOwner);
        }
    }

    private final void checkIgnoredOnParcelUsage(KtAnnotationEntry annotationEntry, CallCheckerContext context, KtModifierListOwner element) {
        if (element instanceof KtParameter && PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), KtDeclaration.class) instanceof KtPrimaryConstructor) {
            context.getTrace().report((Diagnostic)ErrorsParcelize.INAPPLICABLE_IGNORED_ON_PARCEL_CONSTRUCTOR_PROPERTY.on((PsiElement)annotationEntry));
        } else if (!(element instanceof KtProperty) || !(PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), KtDeclaration.class) instanceof KtClass)) {
            context.getTrace().report((Diagnostic)ErrorsParcelize.INAPPLICABLE_IGNORED_ON_PARCEL.on((PsiElement)annotationEntry));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeParcelerUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context, KtModifierListOwner element) {
        int duplicatingAnnotationCount;
        int n;
        void $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)context.getTrace().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element);
        if (declarationDescriptor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"context.trace[BindingCon\u2026IPTOR, element] ?: return");
        DeclarationDescriptor descriptor = declarationDescriptor;
        KotlinType kotlinType = resolvedCall.getTypeArguments().values();
        boolean bl = false;
        boolean bl2 = false;
        Object it2 = kotlinType;
        boolean bl3 = false;
        Object object = it2.size() == 2 ? kotlinType : null;
        if (object == null || (object = (KotlinType)CollectionsKt.first((Iterable)((Iterable)object))) == null) {
            return;
        }
        KotlinType thisMappedType = object;
        Iterable $this$filter$iv = (Iterable)descriptor.getAnnotations();
        boolean $i$f$filter = false;
        it2 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AnnotationDescriptor)element$iv$iv;
            boolean bl4 = false;
            if (!CollectionsKt.contains((Iterable)TYPE_PARCELER_FQ_NAMES, (Object)it.getFqName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            KotlinType kotlinType2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl5 = false;
            AnnotationDescriptor it3 = (AnnotationDescriptor)element$iv$iv;
            boolean bl6 = false;
            List list = it3.getType().getArguments();
            boolean bl7 = false;
            boolean bl8 = false;
            List args = list;
            boolean bl9 = false;
            List list2 = args.size() == 2 ? list : null;
            if ((list2 != null && (list2 = (TypeProjection)CollectionsKt.first((List)list2)) != null ? list2.getType() : null) == null) continue;
            kotlinType2 = kotlinType2;
            boolean bl10 = false;
            boolean bl11 = false;
            KotlinType it$iv$iv = kotlinType2;
            boolean bl12 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$count$iv = (List)destination$iv$iv;
        boolean $i$f$count22 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                KotlinType it4 = (KotlinType)element$iv;
                boolean bl13 = false;
                if (!Intrinsics.areEqual((Object)it4, (Object)thisMappedType)) continue;
                int n2 = ++count$iv;
                bl13 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = duplicatingAnnotationCount = count$iv;
        }
        if (duplicatingAnnotationCount > 1) {
            List list = annotationEntry.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntry.typeArguments");
            KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.firstOrNull((List)list);
            KtElementImplStub reportElement = ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)annotationEntry;
            context.getTrace().report((Diagnostic)ErrorsParcelize.DUPLICATING_TYPE_PARCELERS.on((PsiElement)reportElement));
            return;
        }
        KtModifierListOwner $i$f$count22 = element;
        KtClassOrObject containingClass = $i$f$count22 instanceof KtClassOrObject ? (KtClassOrObject)element : ($i$f$count22 instanceof KtParameter ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)element)) : null);
        this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context);
        if (element instanceof KtParameter) {
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDeclaration.class, (boolean)true) instanceof KtPrimaryConstructor) {
                ClassDescriptor containingClassDescriptor = (ClassDescriptor)context.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass);
                AnnotationDescriptor thisAnnotationDescriptor = (AnnotationDescriptor)context.getTrace().get((ReadOnlySlice)BindingContext.ANNOTATION, (Object)annotationEntry);
                if (containingClass != null && containingClassDescriptor != null && thisAnnotationDescriptor != null) {
                    boolean bl14;
                    block16: {
                        Iterable $this$any$iv = (Iterable)containingClassDescriptor.getAnnotations();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl14 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (AnnotationDescriptor)element$iv;
                                boolean bl15 = false;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)thisAnnotationDescriptor.getType())) continue;
                                bl14 = true;
                                break block16;
                            }
                            bl14 = false;
                        }
                    }
                    if (bl14) {
                        KtUserType ktUserType;
                        KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
                        Object object2 = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
                        if (!(object2 instanceof KtUserType)) {
                            object2 = null;
                        }
                        KtElement reportElement = (ktUserType = (KtUserType)object2) != null && (ktUserType = ktUserType.getReferenceExpression()) != null ? (KtElement)ktUserType : (KtElement)annotationEntry;
                        context.getTrace().report((Diagnostic)ErrorsParcelize.REDUNDANT_TYPE_PARCELER.on((PsiElement)reportElement, (Object)containingClass));
                    }
                }
            }
        }
    }

    private final void checkWriteWithUsage(ResolvedCall<?> resolvedCall, KtAnnotationEntry annotationEntry, CallCheckerContext context, KtModifierListOwner element) {
        Object v5;
        Function0 $fun$reportElement$1;
        KotlinType actualType;
        block10: {
            if (!(element instanceof KtTypeReference)) {
                return;
            }
            KotlinType kotlinType = (KotlinType)context.getTrace().get((ReadOnlySlice)BindingContext.TYPE, (Object)element);
            if (kotlinType == null || (kotlinType = TypeUtilsKt.replaceAnnotations((KotlinType)kotlinType, (Annotations)Annotations.Companion.getEMPTY())) == null) {
                return;
            }
            actualType = kotlinType;
            KotlinType kotlinType2 = (KotlinType)CollectionsKt.singleOrNull((Iterable)resolvedCall.getTypeArguments().values());
            if (kotlinType2 == null) {
                return;
            }
            KotlinType parcelerType = kotlinType2;
            ClassifierDescriptor classifierDescriptor = parcelerType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof ClassDescriptor)) {
                classifierDescriptor = null;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor parcelerClass = classDescriptor;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject containingClass = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            this.checkIfTheContainingClassIsParcelize(containingClass, annotationEntry, context);
            $fun$reportElement$1 = new Function0<KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>>>(annotationEntry){
                final /* synthetic */ KtAnnotationEntry $annotationEntry;

                @NotNull
                public final KtElementImplStub<? extends StubElement<? extends KtElementImplStub<?>>> invoke() {
                    List list = this.$annotationEntry.getTypeArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntry.typeArguments");
                    KtTypeProjection ktTypeProjection = (KtTypeProjection)CollectionsKt.singleOrNull((List)list);
                    return ktTypeProjection != null ? (KtElementImplStub)ktTypeProjection : (KtElementImplStub)this.$annotationEntry;
                }
                {
                    this.$annotationEntry = ktAnnotationEntry;
                    super(0);
                }
            };
            if (parcelerClass.getKind() != ClassKind.OBJECT) {
                context.getTrace().report((Diagnostic)ErrorsParcelize.PARCELER_SHOULD_BE_OBJECT.on((PsiElement)$fun$reportElement$1.invoke()));
                return;
            }
            checkWriteWithUsage.2 $fun$fqName$2 = checkWriteWithUsage.2.INSTANCE;
            SimpleType simpleType = parcelerClass.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"parcelerClass.defaultType");
            Iterable $this$firstOrNull$iv = TypeUtilsKt.supertypes((KotlinType)((KotlinType)simpleType));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KotlinType it = (KotlinType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)checkWriteWithUsage.2.INSTANCE.invoke(it), (Object)ParcelizeResolveExtensionKt.getPARCELER_FQNAME())) continue;
                v5 = element$iv;
                break block10;
            }
            v5 = null;
        }
        KotlinType kotlinType = v5;
        if (kotlinType == null) {
            return;
        }
        KotlinType parcelerSuperType = kotlinType;
        TypeProjection typeProjection = (TypeProjection)CollectionsKt.singleOrNull((List)parcelerSuperType.getArguments());
        if (typeProjection == null || (typeProjection = typeProjection.getType()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"parcelerSuperType.argume\u2026eOrNull()?.type ?: return");
        TypeProjection expectedType = typeProjection;
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)actualType, (KotlinType)expectedType)) {
            context.getTrace().report((Diagnostic)ErrorsParcelize.PARCELER_TYPE_INCOMPATIBLE.on((PsiElement)$fun$reportElement$1.invoke(), (Object)expectedType, (Object)actualType));
        }
    }

    private final void checkIfTheContainingClassIsParcelize(KtClassOrObject containingClass, KtAnnotationEntry annotationEntry, CallCheckerContext context) {
        ClassDescriptor containingClassDescriptor;
        if (containingClass != null && (containingClassDescriptor = (ClassDescriptor)context.getTrace().get((ReadOnlySlice)BindingContext.CLASS, (Object)containingClass)) != null && !ParcelizeResolveExtensionKt.isParcelize(containingClassDescriptor)) {
            KtUserType ktUserType;
            KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
            Object object = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
            if (!(object instanceof KtUserType)) {
                object = null;
            }
            KtElement reportElement = (ktUserType = (KtUserType)object) != null && (ktUserType = ktUserType.getReferenceExpression()) != null ? (KtElement)ktUserType : (KtElement)annotationEntry;
            context.getTrace().report((Diagnostic)ErrorsParcelize.CLASS_SHOULD_BE_PARCELIZE.on((PsiElement)reportElement, (Object)containingClass));
        }
    }

    static {
        Companion = new Companion(null);
        TYPE_PARCELER_FQ_NAMES = CollectionsKt.listOf((Object[])new FqName[]{new FqName(TypeParceler.class.getName()), new FqName(kotlinx.android.parcel.TypeParceler.class.getName())});
        WRITE_WITH_FQ_NAMES = CollectionsKt.listOf((Object[])new FqName[]{new FqName(WriteWith.class.getName()), new FqName(kotlinx.android.parcel.WriteWith.class.getName())});
        IGNORED_ON_PARCEL_FQ_NAMES = CollectionsKt.listOf((Object[])new FqName[]{new FqName(IgnoredOnParcel.class.getName()), new FqName(kotlinx.android.parcel.IgnoredOnParcel.class.getName())});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/parcelize/ParcelizeAnnotationChecker$Companion;", "", "()V", "IGNORED_ON_PARCEL_FQ_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "getIGNORED_ON_PARCEL_FQ_NAMES", "()Ljava/util/List;", "TYPE_PARCELER_FQ_NAMES", "getTYPE_PARCELER_FQ_NAMES", "WRITE_WITH_FQ_NAMES", "getWRITE_WITH_FQ_NAMES", "parcelize-compiler"})
    public static final class Companion {
        @NotNull
        public final List<FqName> getTYPE_PARCELER_FQ_NAMES() {
            return TYPE_PARCELER_FQ_NAMES;
        }

        @NotNull
        public final List<FqName> getWRITE_WITH_FQ_NAMES() {
            return WRITE_WITH_FQ_NAMES;
        }

        @NotNull
        public final List<FqName> getIGNORED_ON_PARCEL_FQ_NAMES() {
            return IGNORED_ON_PARCEL_FQ_NAMES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

