/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.noarg.fir.FirNoArgPredicateMatcher;
import org.jetbrains.kotlin.noarg.fir.KtErrorsNoArg;
import org.jetbrains.kotlin.noarg.fir.NoArgAnnotationNameProviderKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/noarg/fir/FirNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isNoArgConstructor", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "kotlin-noarg-compiler-plugin.k2"})
@SourceDebugExtension(value={"SMAP\nFirNoArgDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNoArgDeclarationChecker.kt\norg/jetbrains/kotlin/noarg/fir/FirNoArgDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n35#2:44\n51#2:45\n808#3,11:46\n2632#3,3:57\n1734#3,3:60\n*S KotlinDebug\n*F\n+ 1 FirNoArgDeclarationChecker.kt\norg/jetbrains/kotlin/noarg/fir/FirNoArgDeclarationChecker\n*L\n28#1:44\n29#1:45\n33#1:46,11\n33#1:57,3\n40#1:60,3\n*E\n"})
public final class FirNoArgDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirNoArgDeclarationChecker INSTANCE = new FirNoArgDeclarationChecker();

    private FirNoArgDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean bl;
        FirRegularClassSymbol superClassSymbol;
        FirNoArgPredicateMatcher matcher;
        KtSourceElement source;
        block11: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            KtSourceElement ktSourceElement = declaration.getSource();
            if (ktSourceElement == null) {
                return;
            }
            source = ktSourceElement;
            if (declaration.getClassKind() != ClassKind.CLASS) {
                return;
            }
            matcher = NoArgAnnotationNameProviderKt.getNoArgPredicateMatcher(context.getSession());
            if (!matcher.isAnnotated(declaration.getSymbol())) {
                return;
            }
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsNoArg.INSTANCE.getNOARG_ON_INNER_CLASS_ERROR(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            } else {
                FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)declaration;
                boolean $i$f$isLocal = false;
                if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsNoArg.INSTANCE.getNOARG_ON_LOCAL_CLASS_ERROR(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                }
            }
            superClassSymbol = SupertypeUtilsKt.getSuperClassSymbolOrAny((FirRegularClassSymbol)declaration.getSymbol(), (FirSession)context.getSession());
            Iterable $this$filterIsInstance$iv = superClassSymbol.getDeclarationSymbols();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirConstructorSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.isNoArgConstructor(it)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl && !matcher.isAnnotated(superClassSymbol)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsNoArg.INSTANCE.getNO_NOARG_CONSTRUCTOR_IN_SUPERCLASS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    private final boolean isNoArgConstructor(FirConstructorSymbol $this$isNoArgConstructor) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = $this$isNoArgConstructor.getValueParameterSymbols();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (it.getHasDefaultValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

