/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.library;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.library.KonanLibrary;
import org.jetbrains.kotlin.konan.library.SearchPathResolverWithTarget;
import org.jetbrains.kotlin.konan.library.impl.KonanLibraryImplKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryProperResolverWithAttributes;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003BM\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\rH\u0016J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/konan/library/KonanLibraryProperResolver;", "Lorg/jetbrains/kotlin/library/KotlinLibraryProperResolverWithAttributes;", "Lorg/jetbrains/kotlin/konan/library/KonanLibrary;", "Lorg/jetbrains/kotlin/konan/library/SearchPathResolverWithTarget;", "repositories", "", "", "directLibs", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "distributionKlib", "localKonanDir", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/konan/target/KonanTarget;Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;)V", "distPlatformHead", "Lorg/jetbrains/kotlin/konan/file/File;", "getDistPlatformHead", "()Lorg/jetbrains/kotlin/konan/file/File;", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "getTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "libraryComponentBuilder", "file", "isDefault", "libraryMatch", "candidate", "unresolved", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "kotlin-native-utils"})
public final class KonanLibraryProperResolver
extends KotlinLibraryProperResolverWithAttributes<KonanLibrary>
implements SearchPathResolverWithTarget<KonanLibrary> {
    @NotNull
    private final KonanTarget target;
    @NotNull
    private final Logger logger;

    @NotNull
    public List<KonanLibrary> libraryComponentBuilder(@NotNull File file, boolean isDefault) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return KonanLibraryImplKt.createKonanLibraryComponents(file, this.getTarget(), isDefault);
    }

    @Nullable
    public File getDistPlatformHead() {
        String string = this.getDistributionKlib();
        return string != null && (string = FileKt.File((String)string)) != null && (string = string.child("platform")) != null ? string.child(this.getTarget().getVisibleName()) : null;
    }

    public boolean libraryMatch(@NotNull KonanLibrary candidate2, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        KonanTarget resolverTarget = this.getTarget();
        String candidatePath = candidate2.getLibraryFile().getAbsolutePath();
        if (!candidate2.getTargetList().contains(resolverTarget.getVisibleName())) {
            this.getLogger().warning("skipping " + candidatePath + ". The target doesn't match. Expected '" + resolverTarget + "', found " + candidate2.getTargetList());
            return false;
        }
        return super.libraryMatch((KotlinLibrary)candidate2, unresolved);
    }

    @Override
    @NotNull
    public KonanTarget getTarget() {
        return this.target;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    public KonanLibraryProperResolver(@NotNull List<String> repositories, @NotNull List<String> directLibs, @NotNull KonanTarget target, @Nullable String distributionKlib, @Nullable String localKonanDir, boolean skipCurrentDir, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter(directLibs, (String)"directLibs");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(repositories, directLibs, distributionKlib, localKonanDir, skipCurrentDir, logger, CollectionsKt.listOf((Object)"kotlin.native.cinterop"));
        this.target = target;
        this.logger = logger;
    }
}

