/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.jetbrains.kotlin.gradle.plugin.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanCompileConfig;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanInteropLibrary;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanLibrary;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanPluginKt;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanProgram;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.Call;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanArtifactTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanBuildingTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompileLibraryTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompileProgramTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanCompileTask;
import shadow.org.jetbrains.kotlin.gradle.plugin.tasks.KonanInteropTask;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J:\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00062\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\u0007*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u0007*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u0007*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0018\u0010\u0015\u001a\u00020\u0007*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0018\u0010\u0017\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Lshadow/org/jetbrains/kotlin/gradle/plugin/tasks/KonanGenerateCMakeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "host", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "asCMakeSourceList", "", "", "Lorg/gradle/api/file/FileCollection;", "getAsCMakeSourceList", "(Lorg/gradle/api/file/FileCollection;)Ljava/util/List;", "cMakeCompilerOpts", "Lshadow/org/jetbrains/kotlin/gradle/plugin/tasks/KonanInteropTask;", "getCMakeCompilerOpts", "(Lorg/jetbrains/kotlin/gradle/plugin/tasks/KonanInteropTask;)Ljava/lang/String;", "cMakeLibraries", "Lshadow/org/jetbrains/kotlin/gradle/plugin/tasks/KonanCompileTask;", "getCMakeLibraries", "(Lorg/jetbrains/kotlin/gradle/plugin/tasks/KonanCompileTask;)Ljava/lang/String;", "cMakeLinkerOpts", "getCMakeLinkerOpts", "cMakeSources", "getCMakeSources", "crossPlatformPath", "getCrossPlatformPath", "(Ljava/lang/String;)Ljava/lang/String;", "relativePath", "Ljava/io/File;", "getRelativePath", "(Ljava/io/File;)Ljava/io/File;", "generateCMake", "", "generateCMakeLists", "projectName", "interops", "Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanInteropLibrary;", "libraries", "Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanLibrary;", "programs", "Lorg/jetbrains/kotlin/gradle/plugin/konan/KonanProgram;", "kotlin-native-gradle-plugin"})
public class KonanGenerateCMakeTask
extends DefaultTask {
    private final KonanTarget host = HostManager.Companion.getHost();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generateCMake() {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        void $receiver$iv$iv3;
        Iterable $receiver$iv;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.toList((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer(project))));
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv3) {
            if (!(element$iv$iv instanceof KonanInteropLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List interops = (List)destination$iv$iv;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Iterable $receiver$iv2 = CollectionsKt.toList((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer(project2))));
        destination$iv$iv = $receiver$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            if (!(element$iv$iv instanceof KonanLibrary)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List libraries2 = (List)destination$iv$iv2;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Iterable $receiver$iv3 = CollectionsKt.toList((Iterable)((Iterable)((Object)KonanPluginKt.getKonanArtifactsContainer(project3))));
        destination$iv$iv2 = $receiver$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KonanProgram)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List programs = (List)destination$iv$iv3;
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        String string = project4.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String cMakeLists = this.generateCMakeLists(string, interops, libraries2, programs);
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        FilesKt.writeText$default((File)new File(project5.getProjectDir(), "CMakeLists.txt"), (String)cMakeLists, null, (int)2, null);
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        new File(project6.getProjectDir(), "KotlinCMakeModule").mkdir();
    }

    private final String generateCMakeLists(String projectName, List<? extends KonanInteropLibrary> interops, List<? extends KonanLibrary> libraries2, List<? extends KonanProgram> programs) {
        Call call;
        KonanBuildingTask task;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $receiver;
        String cMakeCurrentListDir = "${CMAKE_CURRENT_LIST_DIR}";
        StringBuilder stringBuilder3 = $receiver = (stringBuilder2 = new StringBuilder());
        Iterator<KonanCompileConfig> iterator = StringsKt.trimIndent((String)("\n                cmake_minimum_required(VERSION 3.8)\n\n                set(CMAKE_MODULE_PATH " + cMakeCurrentListDir + "/KotlinCMakeModule)\n\n                project(" + projectName + " Kotlin)\n            "));
        StringBuilder stringBuilder4 = stringBuilder3.append((String)((Object)iterator));
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        StringsKt.appendln((StringBuilder)$receiver);
        for (KonanInteropLibrary konanInteropLibrary : interops) {
            if ((KonanInteropTask)konanInteropLibrary.get$kotlin_native_gradle_plugin(this.host) == null) {
                continue;
            }
            stringBuilder = $receiver;
            Call call2 = new Call("cinterop").arg("NAME", konanInteropLibrary.getName());
            String string = this.getRelativePath(((KonanInteropTask)task).getDefFile()).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.defFile.relativePath.toString()");
            call = call2.arg("DEF_FILE", this.getCrossPlatformPath(string)).arg("COMPILER_OPTS", this.getCMakeCompilerOpts((KonanInteropTask)task));
            StringBuilder stringBuilder5 = stringBuilder.append(call);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
        }
        for (KonanLibrary konanLibrary : libraries2) {
            if ((KonanCompileLibraryTask)konanLibrary.get$kotlin_native_gradle_plugin(this.host) == null) {
                continue;
            }
            stringBuilder = $receiver;
            call = new Call("konanc_library").arg("NAME", konanLibrary.getName()).arg("SOURCES", this.getCMakeSources((KonanCompileTask)task)).arg("LIBRARIES", this.getCMakeLibraries((KonanCompileTask)task)).arg("LINKER_OPTS", this.getCMakeLinkerOpts((KonanCompileTask)task));
            StringBuilder stringBuilder6 = stringBuilder.append(call);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
        }
        for (KonanProgram konanProgram : programs) {
            if ((KonanCompileProgramTask)konanProgram.get$kotlin_native_gradle_plugin(this.host) == null) {
                continue;
            }
            stringBuilder = $receiver;
            call = new Call("konanc_executable").arg("NAME", konanProgram.getName()).arg("SOURCES", this.getCMakeSources((KonanCompileTask)task)).arg("LIBRARIES", this.getCMakeLibraries((KonanCompileTask)task)).arg("LINKER_OPTS", this.getCMakeLinkerOpts((KonanCompileTask)task));
            StringBuilder stringBuilder7 = stringBuilder.append(call);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final File getRelativePath(@NotNull File $receiver) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        return FilesKt.relativeTo((File)$receiver, (File)file);
    }

    private final String getCrossPlatformPath(@NotNull String $receiver) {
        return this.host.getFamily() == Family.MINGW ? StringsKt.replace$default((String)$receiver, (char)'\\', (char)'/', (boolean)false, (int)4, null) : $receiver;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAsCMakeSourceList(@NotNull FileCollection $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Set set = $receiver.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"files");
        Iterable iterable = $receiver$iv = (Iterable)set;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = this.getRelativePath((File)v1).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.relativePath.toString()");
            String string2 = this.getCrossPlatformPath(string);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String getCMakeCompilerOpts(@NotNull KonanInteropTask $receiver) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = $receiver.getIncludeDirs().getAllHeadersDirs();
        Collection collection2 = $receiver.getCompilerOpts();
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("-I");
            String string = it.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
            String string2 = stringBuilder.append(this.getCrossPlatformPath(string)).toString();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String getCMakeSources(@NotNull KonanCompileTask $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver.getAllSources();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FileCollection it = (FileCollection)element$iv$iv;
            Iterable list$iv$iv = this.getAsCMakeSourceList(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getCMakeLibraries(@NotNull KonanCompileTask $receiver) {
        String string;
        Object it;
        Collection<String> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        List list;
        List $receiver2 = list = (List)new ArrayList();
        Iterable iterable = $receiver.getLibraries().getArtifacts();
        List list2 = $receiver2;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            KonanBuildingTask konanBuildingTask = (KonanBuildingTask)item$iv$iv;
            collection = destination$iv$iv;
            string = ((KonanArtifactTask)it).getArtifactName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list2.addAll((Collection)collection);
        $receiver2.addAll((Collection)$receiver.getLibraries().getNamedKlibs());
        $receiver$iv = $receiver.getLibraries().getFiles();
        list2 = $receiver2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (FileCollection)element$iv$iv;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (File)item$iv$iv;
            collection = destination$iv$iv;
            Object object = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it");
            String string2 = ((File)object).getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.canonicalPath");
            string = this.getCrossPlatformPath(string2);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(collection);
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getCMakeLinkerOpts(@NotNull KonanCompileTask $receiver) {
        return StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)$receiver.getLinkerOpts(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }
}

