/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.library.impl;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.konan.library.KonanLibraryLayout;
import org.jetbrains.kotlin.konan.library.impl.DirectFromZip;
import org.jetbrains.kotlin.konan.library.impl.FileExtractor;
import org.jetbrains.kotlin.konan.library.impl.KonanLibraryLayoutImpl;
import org.jetbrains.kotlin.konan.library.impl.KonanLibraryLayoutImplKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.util.UtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/konan/library/impl/ZippedKonanLibraryLayout;", "Lorg/jetbrains/kotlin/konan/library/impl/KonanLibraryLayoutImpl;", "klibFile", "Lorg/jetbrains/kotlin/konan/file/File;", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "(Lorg/jetbrains/kotlin/konan/file/File;Lorg/jetbrains/kotlin/konan/target/KonanTarget;)V", "getKlibFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "libDir", "getLibDir", "libraryName", "", "getLibraryName", "()Ljava/lang/String;", "getTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "inPlace", "T", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/konan/library/KonanLibraryLayout;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "realFiles", "kotlin-native-shared"})
final class ZippedKonanLibraryLayout
implements KonanLibraryLayoutImpl {
    @NotNull
    private final String libraryName;
    @NotNull
    private final File libDir;
    @NotNull
    private final File klibFile;
    @Nullable
    private final KonanTarget target;

    @Override
    @NotNull
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    @NotNull
    public File getLibDir() {
        return this.libDir;
    }

    @Override
    public <T> T realFiles(@NotNull Function1<? super KonanLibraryLayout, ? extends T> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Object object = action.invoke((Object)new FileExtractor(this));
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return (T)object;
    }

    @Override
    public <T> T inPlace(@NotNull Function1<? super KonanLibraryLayout, ? extends T> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return ZipUtilKt.withZipFileSystem(this.klibFile, (Function1)new Function1<FileSystem, T>(this, action){
            final /* synthetic */ ZippedKonanLibraryLayout this$0;
            final /* synthetic */ Function1 $action;

            public final T invoke(@NotNull FileSystem zipFileSystem) {
                Intrinsics.checkParameterIsNotNull((Object)zipFileSystem, (String)"zipFileSystem");
                return (T)this.$action.invoke((Object)new DirectFromZip(this.this$0, zipFileSystem));
            }
            {
                this.this$0 = zippedKonanLibraryLayout;
                this.$action = function1;
                super(1);
            }
        });
    }

    @NotNull
    public final File getKlibFile() {
        return this.klibFile;
    }

    @Override
    @Nullable
    public KonanTarget getTarget() {
        return this.target;
    }

    public ZippedKonanLibraryLayout(@NotNull File klibFile, @Nullable KonanTarget target2) {
        Intrinsics.checkParameterIsNotNull((Object)klibFile, (String)"klibFile");
        this.klibFile = klibFile;
        this.target = target2;
        KonanLibraryLayoutImplKt.zippedKonanLibraryChecks(this.klibFile);
        this.libraryName = UtilKt.removeSuffixIfPresent(this.klibFile.getPath(), ".klib");
        this.libDir = new File("/");
    }

    @Override
    @NotNull
    public File getManifestFile() {
        return KonanLibraryLayoutImpl.DefaultImpls.getManifestFile(this);
    }

    @Override
    @NotNull
    public File getResourcesDir() {
        return KonanLibraryLayoutImpl.DefaultImpls.getResourcesDir(this);
    }

    @Override
    @NotNull
    public File getTargetsDir() {
        return KonanLibraryLayoutImpl.DefaultImpls.getTargetsDir(this);
    }

    @Override
    @NotNull
    public File getTargetDir() {
        return KonanLibraryLayoutImpl.DefaultImpls.getTargetDir(this);
    }

    @Override
    @NotNull
    public File getKotlinDir() {
        return KonanLibraryLayoutImpl.DefaultImpls.getKotlinDir(this);
    }

    @Override
    @NotNull
    public File getNativeDir() {
        return KonanLibraryLayoutImpl.DefaultImpls.getNativeDir(this);
    }

    @Override
    @NotNull
    public File getIncludedDir() {
        return KonanLibraryLayoutImpl.DefaultImpls.getIncludedDir(this);
    }

    @Override
    @NotNull
    public File getLinkdataDir() {
        return KonanLibraryLayoutImpl.DefaultImpls.getLinkdataDir(this);
    }

    @Override
    @NotNull
    public File getModuleHeaderFile() {
        return KonanLibraryLayoutImpl.DefaultImpls.getModuleHeaderFile(this);
    }

    @Override
    @NotNull
    public File getDataFlowGraphFile() {
        return KonanLibraryLayoutImpl.DefaultImpls.getDataFlowGraphFile(this);
    }

    @Override
    @NotNull
    public File packageFragmentsDir(@NotNull String packageName2) {
        Intrinsics.checkParameterIsNotNull((Object)packageName2, (String)"packageName");
        return KonanLibraryLayoutImpl.DefaultImpls.packageFragmentsDir(this, packageName2);
    }

    @Override
    @NotNull
    public File packageFragmentFile(@NotNull String packageFqName, @NotNull String partName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)partName, (String)"partName");
        return KonanLibraryLayoutImpl.DefaultImpls.packageFragmentFile(this, packageFqName, partName);
    }
}

