/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.experimental.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.experimental.internal.AbstractKotlinNativeBinary;
import org.jetbrains.kotlin.gradle.plugin.experimental.sourcesets.KotlinNativeSourceSet;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanCompilerRunner;
import org.jetbrains.kotlin.gradle.plugin.konan.KonanPluginKt;
import org.jetbrains.kotlin.konan.target.CompilerOutputKind;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import shadow.org.jetbrains.kotlin.gradle.tasks.CompilerPluginOptions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010;\u001a\u00020<H\u0015J\b\u0010=\u001a\u00020\rH\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0012\u0010@\u001a\u00020<2\b\u0010A\u001a\u0004\u0018\u00010\rH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8G\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00070(8G\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001bR\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0019\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020302\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\u000702X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020\r8G\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u000fR\u0011\u00109\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001e\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/experimental/tasks/KotlinNativeCompile;", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "binary", "Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/AbstractKotlinNativeBinary;", "(Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/AbstractKotlinNativeBinary;)V", "additionalCompilerOptions", "", "", "getAdditionalCompilerOptions", "()Ljava/util/Collection;", "getBinary$kotlin_native_gradle_plugin", "()Lorg/jetbrains/kotlin/gradle/plugin/experimental/internal/AbstractKotlinNativeBinary;", "commonSources", "Lorg/gradle/api/file/FileCollection;", "getCommonSources", "()Lorg/gradle/api/file/FileCollection;", "compilerPluginClasspath", "getCompilerPluginClasspath", "setCompilerPluginClasspath", "(Lorg/gradle/api/file/FileCollection;)V", "compilerPluginOptions", "Lshadow/org/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "getCompilerPluginOptions", "()Lorg/jetbrains/kotlin/gradle/tasks/CompilerPluginOptions;", "debuggable", "", "getDebuggable", "()Z", "entryPoint", "getEntryPoint", "()Ljava/lang/String;", "kind", "Lorg/jetbrains/kotlin/konan/target/CompilerOutputKind;", "getKind", "()Lorg/jetbrains/kotlin/konan/target/CompilerOutputKind;", "libraries", "Lorg/gradle/api/artifacts/Configuration;", "getLibraries", "()Lorg/gradle/api/artifacts/Configuration;", "linkerOpts", "", "getLinkerOpts", "()Ljava/util/List;", "optimized", "getOptimized", "outputFile", "Ljava/io/File;", "getOutputFile", "()Ljava/io/File;", "outputLocationProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "getOutputLocationProvider", "()Lorg/gradle/api/provider/Provider;", "outputPathProvider", "sources", "getSources", "target", "getTarget", "compile", "", "getClasspath", "getSource", "Lorg/gradle/api/file/FileTree;", "setClasspath", "configuration", "kotlin-native-gradle-plugin"})
public class KotlinNativeCompile
extends AbstractCompile {
    @NotNull
    private final CompilerPluginOptions compilerPluginOptions;
    @Nullable
    private FileCollection compilerPluginClasspath;
    private final Provider<String> outputPathProvider;
    @NotNull
    private final Provider<? extends FileSystemLocation> outputLocationProvider;
    @NotNull
    private final AbstractKotlinNativeBinary binary;

    @InputFiles
    @NotNull
    public final FileCollection getSources() {
        return this.binary.getSources();
    }

    @NotNull
    public FileTree getSource() {
        FileTree fileTree = this.getSources().getAsFileTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"sources.asFileTree");
        return fileTree;
    }

    private final FileCollection getCommonSources() {
        KotlinNativeSourceSet kotlinNativeSourceSet;
        KotlinNativeSourceSet $receiver = kotlinNativeSourceSet = this.binary.getSourceSet();
        FileCollection fileCollection = $receiver.getCommonMultiplatformSources().plus((FileCollection)$receiver.getCommonNativeSources());
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"getCommonMultiplatformSo\u2026 getCommonNativeSources()");
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"with(binary.sourceSet) {\u2026NativeSources()\n        }");
        return fileCollection;
    }

    @InputFiles
    @NotNull
    public final Configuration getLibraries() {
        Configuration configuration = this.binary.getKlibs();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"binary.klibs");
        return configuration;
    }

    @NotNull
    public FileCollection getClasspath() {
        return (FileCollection)this.getLibraries();
    }

    public void setClasspath(@Nullable FileCollection configuration) {
        throw (Throwable)new UnsupportedOperationException("Use klibs to set compile classpath in Kotlin/Native");
    }

    @Input
    public final boolean getOptimized() {
        return this.binary.getOptimized();
    }

    @Input
    public final boolean getDebuggable() {
        return this.binary.getDebuggable();
    }

    @Input
    @NotNull
    public final CompilerOutputKind getKind() {
        return this.binary.getKind();
    }

    @Input
    @NotNull
    public final String getTarget() {
        return this.binary.getKonanTarget().getName();
    }

    @Input
    @NotNull
    public final Collection<String> getAdditionalCompilerOptions() {
        return this.binary.getAdditionalCompilerOptions();
    }

    @Input
    @NotNull
    public final List<String> getLinkerOpts() {
        return this.binary.getLinkerOpts();
    }

    @Optional
    @Input
    @Nullable
    public final String getEntryPoint() {
        return this.binary.getComponent().getEntryPoint();
    }

    @NotNull
    public final CompilerPluginOptions getCompilerPluginOptions() {
        return this.compilerPluginOptions;
    }

    @Nullable
    public final FileCollection getCompilerPluginClasspath() {
        return this.compilerPluginClasspath;
    }

    public final void setCompilerPluginClasspath(@Nullable FileCollection fileCollection) {
        this.compilerPluginClasspath = fileCollection;
    }

    @NotNull
    public final File getOutputFile() {
        Object object = this.outputLocationProvider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputLocationProvider.get()");
        File file = ((FileSystemLocation)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputLocationProvider.get().asFile");
        return file;
    }

    @NotNull
    public final Provider<? extends FileSystemLocation> getOutputLocationProvider() {
        return this.outputLocationProvider;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    protected void compile() {
        void $receiver$iv$iv;
        Object it;
        String it2;
        Object pluginClasspath;
        List list;
        this.getOutputFile().getParentFile().mkdirs();
        List $receiver = list = (List)new ArrayList();
        String string = this.getOutputFile().getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputFile.absolutePath");
        KonanPluginKt.addArg($receiver, "-o", string);
        KonanPluginKt.addKey($receiver, "-opt", this.getOptimized());
        KonanPluginKt.addKey($receiver, "-g", this.getDebuggable());
        KonanPluginKt.addKey($receiver, "-ea", this.getDebuggable());
        KonanPluginKt.addArg($receiver, "-target", this.getTarget());
        String string2 = this.getKind().name();
        Object object = "-p";
        Collection<Object> collection = $receiver;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String string5 = string4;
        KonanPluginKt.addArg((List<String>)collection, (String)object, string5);
        $receiver.add("-Xmulti-platform");
        KonanPluginKt.addArgIfNotNull($receiver, "-entry", this.getEntryPoint());
        FileCollection fileCollection = this.compilerPluginClasspath;
        if (fileCollection != null) {
            Iterator $receiver$iv$iv2;
            Iterable $receiver$iv;
            string2 = fileCollection;
            pluginClasspath = string2;
            Iterable iterable = $receiver$iv = (Iterable)pluginClasspath;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void it3;
                Object item$iv$iv = iterator.next();
                File file = (File)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                void v4 = it3;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
                String string6 = v4.getCanonicalPath();
                collection2.add(string6);
            }
            $receiver$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            for (Object element$iv : $receiver$iv) {
                String path = (String)element$iv;
                $receiver.add("-Xplugin=" + path);
            }
            $receiver$iv = this.compilerPluginOptions.getArguments();
            for (Object element$iv : $receiver$iv) {
                it2 = (String)element$iv;
                $receiver.add("-P" + it2);
            }
        }
        $receiver.addAll(this.getAdditionalCompilerOptions());
        Set set = this.getLibraries().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"libraries.files");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            it = (File)element$iv;
            File file = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            String string7 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it.absolutePath");
            KonanPluginKt.addArg($receiver, "-l", string7);
        }
        KonanPluginKt.addListArg($receiver, "-linker-options", this.getLinkerOpts());
        Set set2 = this.getSources().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"sources.files");
        $receiver$iv = set2;
        collection = $receiver;
        pluginClasspath = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            File $i$f$forEach = (File)item$iv$iv;
            object = destination$iv$iv;
            String string8 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"it");
            string5 = ((File)((Object)string8)).getAbsolutePath();
            object.add(string5);
        }
        object = (List)destination$iv$iv;
        collection.addAll((Collection)object);
        Set set3 = this.getCommonSources().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"commonSources.files");
        $receiver$iv = set3;
        for (Object item$iv : $receiver$iv) {
            it = (File)item$iv;
            collection = $receiver;
            StringBuilder stringBuilder = new StringBuilder().append("-Xcommon-sources=");
            Object object2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it");
            object = stringBuilder.append(((File)object2).getAbsolutePath()).toString();
            collection.add(object);
        }
        List args = list;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        new KonanCompilerRunner(project, null, false, 6, null).run(args);
    }

    @NotNull
    public final AbstractKotlinNativeBinary getBinary$kotlin_native_gradle_plugin() {
        return this.binary;
    }

    @Inject
    public KotlinNativeCompile(@NotNull AbstractKotlinNativeBinary binary) {
        Provider provider;
        Provider provider2;
        Intrinsics.checkParameterIsNotNull((Object)binary, (String)"binary");
        this.binary = binary;
        super.dependsOn(new Object[]{"checkKonanCompiler"});
        this.compilerPluginOptions = new CompilerPluginOptions();
        Provider provider3 = this.getProject().provider((Callable)new Callable<String>(this){
            final /* synthetic */ KotlinNativeCompile this$0;

            @NotNull
            public final String call() {
                AbstractKotlinNativeBinary abstractKotlinNativeBinary;
                AbstractKotlinNativeBinary $receiver = abstractKotlinNativeBinary = this.this$0.getBinary$kotlin_native_gradle_plugin();
                String root = $receiver.getOutputRootName$kotlin_native_gradle_plugin();
                String prefix = $receiver.getKind().prefix($receiver.getKonanTarget());
                String suffix = $receiver.getKind().suffix($receiver.getKonanTarget());
                String baseName = (String)$receiver.getBaseName().get();
                String fileName = prefix + baseName + suffix;
                if ($receiver.getKind() == CompilerOutputKind.FRAMEWORK || $receiver.getKind() == CompilerOutputKind.STATIC || $receiver.getKind() == CompilerOutputKind.DYNAMIC || $receiver.getKind() == CompilerOutputKind.PROGRAM && Intrinsics.areEqual((Object)$receiver.getKonanTarget(), (Object)KonanTarget.WASM32.INSTANCE)) {
                    fileName = StringsKt.replace$default((String)fileName, (char)'-', (char)'_', (boolean)false, (int)4, null);
                }
                return root + '/' + this.this$0.getBinary$kotlin_native_gradle_plugin().getNames().getDirName() + '/' + fileName;
            }
            {
                this.this$0 = kotlinNativeCompile;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)provider3, (String)"project.provider {\n     \u2026fileName\"\n        }\n    }");
        this.outputPathProvider = provider3;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ProjectLayout projectLayout = project.getLayout();
        KotlinNativeCompile kotlinNativeCompile = this;
        ProjectLayout $receiver = projectLayout;
        if (this.getKind() == CompilerOutputKind.FRAMEWORK) {
            DirectoryProperty directoryProperty;
            DirectoryProperty $receiver2 = directoryProperty = this.newOutputDirectory();
            $receiver2.set($receiver.getBuildDirectory().dir(this.outputPathProvider));
            this.getOutputs().dir((Object)$receiver2);
            DirectoryProperty directoryProperty2 = directoryProperty;
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty2, (String)"newOutputDirectory().app\u2026s.dir(this)\n            }");
            provider2 = (Provider)directoryProperty2;
        } else {
            RegularFileProperty regularFileProperty;
            RegularFileProperty $receiver3 = regularFileProperty = this.newOutputFile();
            $receiver3.set($receiver.getBuildDirectory().file(this.outputPathProvider));
            this.getOutputs().file((Object)$receiver3);
            RegularFileProperty regularFileProperty2 = regularFileProperty;
            Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty2, (String)"newOutputFile().apply {\n\u2026.file(this)\n            }");
            provider2 = (Provider)regularFileProperty2;
        }
        kotlinNativeCompile.outputLocationProvider = provider = provider2;
        this.setDestinationDir(this.getProject().provider((Callable)new Callable<File>(){

            @Override
            public final File call() {
                return this.getKind() == CompilerOutputKind.FRAMEWORK ? this.getOutputFile() : this.getOutputFile().getParentFile();
            }
        }));
        this.setSourceCompatibility("1.6");
        this.setTargetCompatibility("1.6");
    }
}

