/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmSymbolsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.DeepCopyIrTreeWithDeclarationsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrBuilderWithPluginContext;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrPredicatesKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerForEnumsGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerSearchUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.extensions.SerializationPluginContext;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u0010\u001a\u00020\f*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializerForEnumsGenerator;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializerIrGenerator;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "compilerContext", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;)V", "serialDescImplClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getSerialDescImplClass", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "generateLoad", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "generateSave", "addElementsContentToDescriptor", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "localDescriptor", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "addFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "instantiateNewDescriptor", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "correctThis", "kotlin-maven-serialization"})
@SourceDebugExtension(value={"SMAP\nSerializerForEnumsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializerForEnumsGenerator.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializerForEnumsGenerator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n346#2,12:112\n1549#3:124\n1620#3,3:125\n*S KotlinDebug\n*F\n+ 1 SerializerForEnumsGenerator.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializerForEnumsGenerator\n*L\n77#1:112,12\n104#1:124\n104#1:125,3\n*E\n"})
public final class SerializerForEnumsGenerator
extends SerializerIrGenerator {
    @NotNull
    private final IrClassSymbol serialDescImplClass;

    public SerializerForEnumsGenerator(@NotNull IrClass irClass, @NotNull SerializationPluginContext compilerContext) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)compilerContext, (String)"compilerContext");
        super(irClass, compilerContext, null);
        this.serialDescImplClass = SerializerSearchUtilKt.getClassFromInternalSerializationPackage(compilerContext, "EnumDescriptor");
    }

    @Override
    public void generateSave(@NotNull IrSimpleFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.addFunctionBody((IrFunction)function, (Function2)new Function2<IrBlockBodyBuilder, IrSimpleFunction, Unit>(this){
            final /* synthetic */ SerializerForEnumsGenerator this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull IrBlockBodyBuilder $this$addFunctionBody, @NotNull IrSimpleFunction saveFunc) {
                Intrinsics.checkNotNullParameter((Object)$this$addFunctionBody, (String)"$this$addFunctionBody");
                Intrinsics.checkNotNullParameter((Object)saveFunc, (String)"saveFunc");
                IrClassSymbol encoderClass = SerializerSearchUtilKt.getClassFromRuntime(this.this$0.getCompilerContext(), "Encoder", new FqName[0]);
                IrProperty irProperty = this.this$0.getIrAnySerialDescProperty();
                Object object = irProperty != null ? irProperty.getGetter() : null;
                Intrinsics.checkNotNull((Object)object);
                IrSimpleFunctionSymbol descriptorGetterSymbol = object.getSymbol();
                IrSimpleFunctionSymbol encodeEnum = JvmSymbolsKt.functionByName((IrClassSymbol)encoderClass, (String)"encodeEnum");
                IrCall serialDescGetter = ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionBody), (IrType)((IrSimpleFunction)descriptorGetterSymbol.getOwner()).getReturnType(), (IrExpression)generateSave.1.invoke$irThis($this$addFunctionBody, saveFunc), (IrFunctionSymbol)((IrFunctionSymbol)descriptorGetterSymbol));
                IrClass irClass = this.this$0.getSerializableIrClass();
                if (irClass == null) {
                    boolean $i$a$-requireNotNull-SerializerForEnumsGenerator$generateSave$1$serializableIrClass$22 = false;
                    String $i$a$-requireNotNull-SerializerForEnumsGenerator$generateSave$1$serializableIrClass$22 = "Enums do not support external serialization";
                    throw new IllegalArgumentException($i$a$-requireNotNull-SerializerForEnumsGenerator$generateSave$1$serializableIrClass$22.toString());
                }
                IrClass serializableIrClass = irClass;
                Sequence $this$single$iv = IrUtilsKt.getProperties((IrDeclarationContainer)((IrDeclarationContainer)serializableIrClass));
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (E element$iv : $this$single$iv) {
                    IrProperty it = (IrProperty)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier((String)"ordinal"))) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                IrSimpleFunction irSimpleFunction = ((IrProperty)single$iv).getGetter();
                Intrinsics.checkNotNull((Object)irSimpleFunction);
                IrSimpleFunction ordinalProp = irSimpleFunction;
                IrMemberAccessExpression getOrdinal = IrBuilderWithPluginContext.DefaultImpls.irInvoke$default(this.this$0, (IrBuilderWithScope)$this$addFunctionBody, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionBody), (IrValueDeclaration)((IrValueDeclaration)saveFunc.getValueParameters().get(1))), (IrFunctionSymbol)ordinalProp.getSymbol(), new IrExpression[0], null, 8, null);
                IrExpression[] irExpressionArray = new IrExpression[]{(IrExpression)serialDescGetter, (IrExpression)getOrdinal};
                IrMemberAccessExpression call = IrBuilderWithPluginContext.DefaultImpls.irInvoke$default(this.this$0, (IrBuilderWithScope)$this$addFunctionBody, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionBody), (IrValueDeclaration)((IrValueDeclaration)saveFunc.getValueParameters().get(0))), (IrFunctionSymbol)encodeEnum, irExpressionArray, null, 8, null);
                $this$addFunctionBody.unaryPlus((IrStatement)call);
            }

            private static final IrExpression invoke$irThis(IrBlockBodyBuilder $this_addFunctionBody, IrSimpleFunction $saveFunc) {
                int n = $this_addFunctionBody.getStartOffset();
                int n2 = $this_addFunctionBody.getEndOffset();
                IrValueParameter irValueParameter = $saveFunc.getDispatchReceiverParameter();
                Intrinsics.checkNotNull((Object)irValueParameter);
                return (IrExpression)new IrGetValueImpl(n, n2, (IrValueSymbol)irValueParameter.getSymbol(), null, 8, null);
            }
        });
    }

    @Override
    public void generateLoad(@NotNull IrSimpleFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.addFunctionBody((IrFunction)function, (Function2)new Function2<IrBlockBodyBuilder, IrSimpleFunction, Unit>(this){
            final /* synthetic */ SerializerForEnumsGenerator this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull IrBlockBodyBuilder $this$addFunctionBody, @NotNull IrSimpleFunction loadFunc) {
                void $this$single$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$addFunctionBody, (String)"$this$addFunctionBody");
                Intrinsics.checkNotNullParameter((Object)loadFunc, (String)"loadFunc");
                IrClassSymbol decoderClass = SerializerSearchUtilKt.getClassFromRuntime(this.this$0.getCompilerContext(), "Decoder", new FqName[0]);
                IrProperty irProperty = this.this$0.getIrAnySerialDescProperty();
                Object object = irProperty != null ? irProperty.getGetter() : null;
                Intrinsics.checkNotNull((Object)object);
                IrSimpleFunctionSymbol descriptorGetterSymbol = object.getSymbol();
                IrSimpleFunctionSymbol decode = JvmSymbolsKt.functionByName((IrClassSymbol)decoderClass, (String)"decodeEnum");
                IrCall serialDescGetter = ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionBody), (IrType)((IrSimpleFunction)descriptorGetterSymbol.getOwner()).getReturnType(), (IrExpression)generateLoad.1.invoke$irThis($this$addFunctionBody, loadFunc), (IrFunctionSymbol)((IrFunctionSymbol)descriptorGetterSymbol));
                Sequence $this$single$iv2 = IrUtilsKt.getFunctions((IrClass)this.this$0.getSerializableIrClass());
                boolean $i$f$single = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (E element$iv : $this$single$iv2) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)StandardNames.ENUM_VALUES)) continue;
                    if (found$iv) {
                        throw new IllegalArgumentException("Sequence contains more than one matching element.");
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                if (!found$iv) {
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                IrSimpleFunction valuesF = single$iv;
                IrMemberAccessExpression getValues = IrBuilderWithPluginContext.DefaultImpls.irInvoke$default(this.this$0, (IrBuilderWithScope)$this$addFunctionBody, null, (IrFunctionSymbol)valuesF.getSymbol(), new IrExpression[0], null, 8, null);
                Iterable $this$filterIsInstance$iv = ((IrClass)this.this$0.getCompilerContext().getIrBuiltIns().getArrayClass().getOwner()).getDeclarations();
                boolean $i$f$filterIsInstance = false;
                IrExpression[] irExpressionArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$single2 = false;
                Object single$iv2 = null;
                boolean found$iv2 = false;
                for (T element$iv : $this$single$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"get")) continue;
                    if (found$iv2) {
                        throw new IllegalArgumentException("Collection contains more than one matching element.");
                    }
                    single$iv2 = element$iv;
                    found$iv2 = true;
                }
                if (!found$iv2) {
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                IrSimpleFunction arrayGet = single$iv2;
                IrExpression[] irExpressionArray2 = new IrExpression[1];
                irExpressionArray = new IrExpression[]{(IrExpression)serialDescGetter};
                irExpressionArray2[0] = (IrExpression)IrBuilderWithPluginContext.DefaultImpls.irInvoke$default(this.this$0, (IrBuilderWithScope)$this$addFunctionBody, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionBody), (IrValueDeclaration)((IrValueDeclaration)loadFunc.getValueParameters().get(0))), (IrFunctionSymbol)decode, irExpressionArray, null, 8, null);
                IrMemberAccessExpression<?> getValueByOrdinal = this.this$0.irInvoke((IrBuilderWithScope)$this$addFunctionBody, (IrExpression)getValues, (IrFunctionSymbol)arrayGet.getSymbol(), irExpressionArray2, (IrType)IrUtilsKt.getDefaultType((IrClass)this.this$0.getSerializableIrClass()));
                $this$addFunctionBody.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionBody), (IrExpression)((IrExpression)getValueByOrdinal)));
            }

            private static final IrExpression invoke$irThis(IrBlockBodyBuilder $this_addFunctionBody, IrSimpleFunction $loadFunc) {
                int n = $this_addFunctionBody.getStartOffset();
                int n2 = $this_addFunctionBody.getEndOffset();
                IrValueParameter irValueParameter = $loadFunc.getDispatchReceiverParameter();
                Intrinsics.checkNotNull((Object)irValueParameter);
                return (IrExpression)new IrGetValueImpl(n, n2, (IrValueSymbol)irValueParameter.getSymbol(), null, 8, null);
            }
        });
    }

    @Override
    @NotNull
    protected IrClassSymbol getSerialDescImplClass() {
        return this.serialDescImplClass;
    }

    @Override
    @NotNull
    protected IrExpression instantiateNewDescriptor(@NotNull IrBlockBodyBuilder $this$instantiateNewDescriptor, @NotNull IrClassSymbol serialDescImplClass, @NotNull IrExpression correctThis) {
        Intrinsics.checkNotNullParameter((Object)$this$instantiateNewDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serialDescImplClass, (String)"serialDescImplClass");
        Intrinsics.checkNotNullParameter((Object)correctThis, (String)"correctThis");
        Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClassSymbol)serialDescImplClass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrConstructorSymbol it = (IrConstructorSymbol)element$iv;
            boolean bl = false;
            if (!((IrConstructor)it.getOwner()).isPrimary()) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructorSymbol ctor = single$iv;
        IrExpression[] irExpressionArray = new IrExpression[]{(IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$instantiateNewDescriptor), (String)this.getSerialName()), (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)((IrBuilderWithScope)$this$instantiateNewDescriptor), (int)IrPredicatesKt.enumEntries(this.getSerializableIrClass()).size(), null, (int)2, null)};
        return (IrExpression)IrBuilderWithPluginContext.DefaultImpls.irInvoke$default(this, (IrBuilderWithScope)$this$instantiateNewDescriptor, null, (IrFunctionSymbol)ctor, irExpressionArray, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addElementsContentToDescriptor(@NotNull IrBlockBodyBuilder $this$addElementsContentToDescriptor, @NotNull IrClassSymbol serialDescImplClass, @NotNull IrVariable localDescriptor, @NotNull IrFunctionSymbol addFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$addElementsContentToDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)serialDescImplClass, (String)"serialDescImplClass");
        Intrinsics.checkNotNullParameter((Object)localDescriptor, (String)"localDescriptor");
        Intrinsics.checkNotNullParameter((Object)addFunction, (String)"addFunction");
        List<IrEnumEntry> enumEntries2 = IrPredicatesKt.enumEntries(this.getSerializableIrClass());
        for (IrEnumEntry entry : enumEntries2) {
            Collection<IrConstructorCall> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string = IrPredicatesKt.getSerialNameValue(entry.getAnnotations());
            if (string == null) {
                String string2 = entry.getName().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name.toString()");
            }
            String serialName = string;
            Object object = new IrExpression[]{(IrExpression)ExpressionHelpersKt.irString((IrBuilderWithScope)((IrBuilderWithScope)$this$addElementsContentToDescriptor), (String)serialName), (IrExpression)ExpressionHelpersKt.irBoolean((IrBuilderWithScope)((IrBuilderWithScope)$this$addElementsContentToDescriptor), (boolean)false)};
            IrMemberAccessExpression<?> call = this.irInvoke((IrBuilderWithScope)$this$addElementsContentToDescriptor, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addElementsContentToDescriptor), (IrValueDeclaration)((IrValueDeclaration)localDescriptor)), addFunction, (IrExpression[])object, this.getCompilerContext().getIrBuiltIns().getUnitType());
            $this$addElementsContentToDescriptor.unaryPlus((IrStatement)call);
            object = entry.getAnnotations();
            IrBlockBodyBuilder irBlockBodyBuilder = $this$addElementsContentToDescriptor;
            SerializerForEnumsGenerator serializerForEnumsGenerator = this;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((IrConstructorCall)DeepCopyIrTreeWithDeclarationsKt.deepCopyWithVariables((IrElement)((IrElement)it)));
            }
            collection = (List)destination$iv$iv;
            serializerForEnumsGenerator.copySerialInfoAnnotationsToDescriptor(irBlockBodyBuilder, (List<? extends IrConstructorCall>)collection, localDescriptor, (IrFunctionSymbol)JvmSymbolsKt.functionByName((IrClassSymbol)serialDescImplClass, (String)"pushAnnotation"));
        }
    }
}

