/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.GeneratedDeclarationKey;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrScriptSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializationBaseContext;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerSearchUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.extensions.SerializationPluginContext;
import org.jetbrains.kotlinx.serialization.compiler.fir.SerializationPluginKey;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationPackages;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0001\u001a\u0012\u0010#\u001a\u0004\u0018\u00010\u00012\u0006\u0010$\u001a\u00020\u0001H\u0000\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\f*\u00020&\u001a\u0014\u0010'\u001a\u00020\u000b*\u00020\u00012\u0006\u0010(\u001a\u00020\u000bH\u0002\u001a\f\u0010)\u001a\u0004\u0018\u00010**\u00020\u0007\u001a\u0012\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\f*\u00020\u0001H\u0000\u001a\n\u0010-\u001a\u00020.*\u00020\u0001\u001a\u0016\u0010/\u001a\u0004\u0018\u00010.*\u00020\u00012\u0006\u00100\u001a\u00020\u001bH\u0000\u001a\f\u00101\u001a\u0004\u0018\u00010!*\u00020\u0001\u001a\f\u00102\u001a\u0004\u0018\u00010.*\u00020\u0001\u001a\u0011\u00103\u001a\u0004\u0018\u00010\u000b*\u000204\u00a2\u0006\u0002\u00105\u001a\f\u00106\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\n\u00107\u001a\u00020\u000b*\u00020\u0001\u001a\f\u00108\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a\u0014\u00109\u001a\u00020\u000b*\u00020\u00012\u0006\u0010:\u001a\u00020;H\u0000\u001a\f\u0010<\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a\f\u0010=\u001a\u00020\u000b*\u00020>H\u0000\u001a\f\u0010?\u001a\u00020\u000b*\u00020\u0007H\u0000\u001a\n\u0010@\u001a\u00020\u000b*\u00020\u0007\u001a\f\u0010A\u001a\u00020\u000b*\u00020BH\u0000\u001a\f\u0010C\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a\f\u0010D\u001a\u00020\u000b*\u00020\u0007H\u0000\u001a\f\u0010E\u001a\u00020\u000b*\u00020\u0001H\u0000\u001a\f\u0010F\u001a\u00020\u000b*\u00020GH\u0000\u001a\f\u0010H\u001a\u00020\u000b*\u00020GH\u0000\u001a\u0014\u0010I\u001a\u00020\u000b*\u00020\u00012\u0006\u0010J\u001a\u00020KH\u0000\u001a\n\u0010L\u001a\u00020\u001b*\u00020\u0001\u001a\n\u0010L\u001a\u00020\u001b*\u00020\u0007\u001a\u0014\u0010M\u001a\u00020\u000b*\u00020\u00012\u0006\u0010:\u001a\u00020;H\u0000\u001a \u0010N\u001a\u00020\u000b*\u00020\u00012\u000e\u0010O\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010.0PH\u0080\b\u00f8\u0001\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001e\u0010\n\u001a\u00020\u000b*\b\u0012\u0004\u0012\u00020\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u000f\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0012\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\"\u0018\u0010\u0013\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\"\u0018\u0010\u0014\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0011\"\u0018\u0010\u0015\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011\"\u0018\u0010\u0016\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011\"\u0018\u0010\u0017\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\"\u0018\u0010\u0018\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0011\"\u0018\u0010\u0019\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011\" \u0010\u001a\u001a\u0004\u0018\u00010\u001b*\b\u0012\u0004\u0012\u00020\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0018\u0010\u001e\u001a\u00020\u000b*\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006Q"}, d2={"constructedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "getConstructedClass", "(Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "genericIndex", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getGenericIndex", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Ljava/lang/Integer;", "hasAnySerialAnnotation", "", "", "getHasAnySerialAnnotation", "(Ljava/util/List;)Z", "hasCompanionObjectAsSerializer", "getHasCompanionObjectAsSerializer", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "isAbstractOrSealedSerializableClass", "isInheritableSerialInfoAnnotation", "isInternalSerializable", "isInternallySerializableObject", "isSealedSerializableInterface", "isSerialInfoAnnotation", "isSerializableObject", "isStaticSerializable", "serialNameValue", "", "getSerialNameValue", "(Ljava/util/List;)Ljava/lang/String;", "shouldHaveGeneratedMethodsInCompanion", "getShouldHaveGeneratedMethodsInCompanion", "findSerializerConstructorForTypeArgumentsSerializers", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "serializer", "getSerializableClassDescriptorByCompanion", "companion", "argumentTypesOrUpperBounds", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "checkSerializableOrMetaAnnotationArgs", "mustDoNotHaveArgs", "classOrUpperBound", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "enumEntries", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "findEnumValuesMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "findPluginGeneratedMethod", "name", "findSerializableSyntheticConstructor", "findWriteSelfMethod", "getEncodeDefaultAnnotationValue", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Ljava/lang/Boolean;", "getSuperClassNotAny", "hasSerializableOrMetaAnnotation", "hasSerializableOrMetaAnnotationWithoutArgs", "isEnumWithLegacyGeneratedSerializer", "context", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializationBaseContext;", "isEnumWithSerialInfoAnnotation", "isFromPlugin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isGeneratedKSerializer", "isGeneratedSerializableObject", "isInitializePropertyFromParameter", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isInternallySerializableEnum", "isKSerializer", "isSerializableEnum", "isSerializationCtor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "lastArgumentIsAnnotationArray", "needSerializerFactory", "compilerContext", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "serialName", "shouldHaveGeneratedSerializer", "shouldHaveSpecificSyntheticMethods", "functionPresenceChecker", "Lkotlin/Function0;", "kotlin-maven-serialization"})
@SourceDebugExtension(value={"SMAP\nIrPredicates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrPredicates.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPredicatesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,251:1\n1#2:252\n1#2:306\n1549#3:253\n1620#3,3:254\n1743#3,3:257\n800#3,11:271\n1743#3,3:282\n1603#3,9:296\n1851#3:305\n1852#3:307\n1612#3:308\n661#3,11:309\n800#3,11:320\n661#3,11:331\n1743#3,3:342\n1722#3,3:349\n1559#3:359\n1590#3,4:360\n381#4,11:260\n381#4,11:285\n381#4,4:345\n385#4,7:352\n*S KotlinDebug\n*F\n+ 1 IrPredicates.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPredicatesKt\n*L\n144#1:306\n93#1:253\n93#1:254,3\n94#1:257,3\n129#1:271,11\n135#1:282,3\n144#1:296,9\n144#1:305\n144#1:307\n144#1:308\n145#1:309,11\n170#1:320,11\n170#1:331,11\n201#1:342,3\n228#1:349,3\n245#1:359\n245#1:360,4\n123#1:260,11\n139#1:285,11\n227#1:345,4\n227#1:352,7\n*E\n"})
public final class IrPredicatesKt {
    public static final boolean isKSerializer(@NotNull IrType $this$isKSerializer) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSerializer, (String)"<this>");
        IrSimpleType irSimpleType = $this$isKSerializer instanceof IrSimpleType ? (IrSimpleType)$this$isKSerializer : null;
        if (irSimpleType == null) {
            return false;
        }
        IrSimpleType simpleType = irSimpleType;
        IrClassifierSymbol irClassifierSymbol = simpleType.getClassifier();
        IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (irClassSymbol == null) {
            return false;
        }
        IrClassSymbol classifier = irClassSymbol;
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)classifier.getOwner()));
        return Intrinsics.areEqual((Object)fqName, (Object)SerialEntityNames.INSTANCE.getKSERIALIZER_NAME_FQ()) || Intrinsics.areEqual((Object)fqName, (Object)SerialEntityNames.INSTANCE.getGENERATED_SERIALIZER_FQ());
    }

    public static final boolean isGeneratedKSerializer(@NotNull IrType $this$isGeneratedKSerializer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedKSerializer, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)$this$isGeneratedKSerializer);
        if (irClassifierSymbol != null) {
            FqNameUnsafe fqNameUnsafe = SerialEntityNames.INSTANCE.getGENERATED_SERIALIZER_FQ().toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"SerialEntityNames.GENERA\u2026_SERIALIZER_FQ.toUnsafe()");
            bl = IrTypePredicatesKt.isClassWithFqName((IrClassifierSymbol)irClassifierSymbol, (FqNameUnsafe)fqNameUnsafe);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isInternalSerializable(@NotNull IrClass $this$isInternalSerializable) {
        Intrinsics.checkNotNullParameter((Object)$this$isInternalSerializable, (String)"<this>");
        if ($this$isInternalSerializable.getKind() != ClassKind.CLASS) {
            return false;
        }
        return IrPredicatesKt.hasSerializableOrMetaAnnotationWithoutArgs($this$isInternalSerializable);
    }

    public static final boolean isAbstractOrSealedSerializableClass(@NotNull IrClass $this$isAbstractOrSealedSerializableClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbstractOrSealedSerializableClass, (String)"<this>");
        return IrPredicatesKt.isInternalSerializable($this$isAbstractOrSealedSerializableClass) && ($this$isAbstractOrSealedSerializableClass.getModality() == Modality.ABSTRACT || $this$isAbstractOrSealedSerializableClass.getModality() == Modality.SEALED);
    }

    public static final boolean isStaticSerializable(@NotNull IrClass $this$isStaticSerializable) {
        Intrinsics.checkNotNullParameter((Object)$this$isStaticSerializable, (String)"<this>");
        return $this$isStaticSerializable.getTypeParameters().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasCompanionObjectAsSerializer(@NotNull IrClass $this$hasCompanionObjectAsSerializer) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCompanionObjectAsSerializer, (String)"<this>");
        if (IrPredicatesKt.isInternallySerializableObject($this$hasCompanionObjectAsSerializer)) return true;
        IrClass irClass = AdditionalIrUtilsKt.companionObject((IrClass)$this$hasCompanionObjectAsSerializer);
        if (!Intrinsics.areEqual((Object)(irClass != null ? SerializerSearchUtilKt.getSerializerForClass(irClass) : null), (Object)$this$hasCompanionObjectAsSerializer.getSymbol())) return false;
        return true;
    }

    public static final boolean isInternallySerializableObject(@NotNull IrClass $this$isInternallySerializableObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isInternallySerializableObject, (String)"<this>");
        return $this$isInternallySerializableObject.getKind() == ClassKind.OBJECT && IrPredicatesKt.hasSerializableOrMetaAnnotationWithoutArgs($this$isInternallySerializableObject);
    }

    @Nullable
    public static final IrSimpleFunction findPluginGeneratedMethod(@NotNull IrClass $this$findPluginGeneratedMethod, @NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findPluginGeneratedMethod, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Sequence sequence = IrUtilsKt.getFunctions((IrClass)$this$findPluginGeneratedMethod);
            for (Object e : sequence) {
                IrSimpleFunction it = (IrSimpleFunction)e;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)name) && IrPredicatesKt.isFromPlugin((IrDeclaration)it))) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final boolean isEnumWithLegacyGeneratedSerializer(@NotNull IrClass $this$isEnumWithLegacyGeneratedSerializer, @NotNull SerializationBaseContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnumWithLegacyGeneratedSerializer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return IrPredicatesKt.isInternallySerializableEnum($this$isEnumWithLegacyGeneratedSerializer) && !context.getRuntimeHasEnumSerializerFactoryFunctions();
    }

    public static final boolean isSealedSerializableInterface(@NotNull IrClass $this$isSealedSerializableInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isSealedSerializableInterface, (String)"<this>");
        return $this$isSealedSerializableInterface.getKind() == ClassKind.INTERFACE && $this$isSealedSerializableInterface.getModality() == Modality.SEALED && IrPredicatesKt.hasSerializableOrMetaAnnotation($this$isSealedSerializableInterface);
    }

    public static final boolean isInternallySerializableEnum(@NotNull IrClass $this$isInternallySerializableEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isInternallySerializableEnum, (String)"<this>");
        return $this$isInternallySerializableEnum.getKind() == ClassKind.ENUM_CLASS && IrPredicatesKt.hasSerializableOrMetaAnnotationWithoutArgs($this$isInternallySerializableEnum);
    }

    public static final boolean isGeneratedSerializableObject(@NotNull IrType $this$isGeneratedSerializableObject) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedSerializableObject, (String)"<this>");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)$this$isGeneratedSerializableObject);
        if (irClassSymbol != null) {
            IrClassSymbol $this$isGeneratedSerializableObject_u24lambda_u241 = irClassSymbol;
            boolean bl2 = false;
            bl = ((IrClass)$this$isGeneratedSerializableObject_u24lambda_u241.getOwner()).getKind() == ClassKind.OBJECT && IrPredicatesKt.hasSerializableOrMetaAnnotationWithoutArgs((IrClass)$this$isGeneratedSerializableObject_u24lambda_u241.getOwner());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isSerializableObject(@NotNull IrClass $this$isSerializableObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isSerializableObject, (String)"<this>");
        return $this$isSerializableObject.getKind() == ClassKind.OBJECT && IrPredicatesKt.hasSerializableOrMetaAnnotation($this$isSerializableObject);
    }

    public static final boolean hasSerializableOrMetaAnnotationWithoutArgs(@NotNull IrClass $this$hasSerializableOrMetaAnnotationWithoutArgs) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSerializableOrMetaAnnotationWithoutArgs, (String)"<this>");
        return IrPredicatesKt.checkSerializableOrMetaAnnotationArgs($this$hasSerializableOrMetaAnnotationWithoutArgs, true);
    }

    public static final boolean hasSerializableOrMetaAnnotation(@NotNull IrClass $this$hasSerializableOrMetaAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSerializableOrMetaAnnotation, (String)"<this>");
        return IrPredicatesKt.checkSerializableOrMetaAnnotationArgs($this$hasSerializableOrMetaAnnotation, false);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkSerializableOrMetaAnnotationArgs(IrClass $this$checkSerializableOrMetaAnnotationArgs, boolean mustDoNotHaveArgs) {
        boolean bl;
        block6: {
            void $this$mapTo$iv$iv;
            IrConstructorCall annot = IrUtilsKt.getAnnotation((IrAnnotationContainer)((IrAnnotationContainer)$this$checkSerializableOrMetaAnnotationArgs), (FqName)SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName());
            if (annot != null) {
                if (!mustDoNotHaveArgs) {
                    return true;
                }
                return annot.getValueArgument(0) == null;
            }
            Iterable $this$map$iv = $this$checkSerializableOrMetaAnnotationArgs.getAnnotations();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(IrPredicatesKt.getConstructedClass((IrConstructorCall)it).getAnnotations());
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    List it = (List)element$iv;
                    boolean bl3 = false;
                    if (!AdditionalIrUtilsKt.hasAnnotation((List)it, (FqName)SerializationAnnotations.INSTANCE.getMetaSerializableAnnotationFqName())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isSerialInfoAnnotation(@NotNull IrClass $this$isSerialInfoAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isSerialInfoAnnotation, (String)"<this>");
        return AdditionalIrUtilsKt.hasAnnotation((List)$this$isSerialInfoAnnotation.getAnnotations(), (FqName)SerializationAnnotations.INSTANCE.getSerialInfoFqName()) || AdditionalIrUtilsKt.hasAnnotation((List)$this$isSerialInfoAnnotation.getAnnotations(), (FqName)SerializationAnnotations.INSTANCE.getInheritableSerialInfoFqName()) || AdditionalIrUtilsKt.hasAnnotation((List)$this$isSerialInfoAnnotation.getAnnotations(), (FqName)SerializationAnnotations.INSTANCE.getMetaSerializableAnnotationFqName());
    }

    public static final boolean isInheritableSerialInfoAnnotation(@NotNull IrClass $this$isInheritableSerialInfoAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isInheritableSerialInfoAnnotation, (String)"<this>");
        return AdditionalIrUtilsKt.hasAnnotation((List)$this$isInheritableSerialInfoAnnotation.getAnnotations(), (FqName)SerializationAnnotations.INSTANCE.getInheritableSerialInfoFqName());
    }

    public static final boolean shouldHaveGeneratedSerializer(@NotNull IrClass $this$shouldHaveGeneratedSerializer, @NotNull SerializationBaseContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveGeneratedSerializer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return IrPredicatesKt.isInternalSerializable($this$shouldHaveGeneratedSerializer) && ($this$shouldHaveGeneratedSerializer.getModality() == Modality.FINAL || $this$shouldHaveGeneratedSerializer.getModality() == Modality.OPEN) || IrPredicatesKt.isEnumWithLegacyGeneratedSerializer($this$shouldHaveGeneratedSerializer, context);
    }

    public static final boolean getShouldHaveGeneratedMethodsInCompanion(@NotNull IrClass $this$shouldHaveGeneratedMethodsInCompanion) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveGeneratedMethodsInCompanion, (String)"<this>");
        return IrPredicatesKt.isSerializableObject($this$shouldHaveGeneratedMethodsInCompanion) || IrPredicatesKt.isSerializableEnum($this$shouldHaveGeneratedMethodsInCompanion) || $this$shouldHaveGeneratedMethodsInCompanion.getKind() == ClassKind.CLASS && IrPredicatesKt.hasSerializableOrMetaAnnotation($this$shouldHaveGeneratedMethodsInCompanion) || IrPredicatesKt.isSealedSerializableInterface($this$shouldHaveGeneratedMethodsInCompanion);
    }

    public static final boolean isSerializableEnum(@NotNull IrClass $this$isSerializableEnum) {
        Intrinsics.checkNotNullParameter((Object)$this$isSerializableEnum, (String)"<this>");
        return $this$isSerializableEnum.getKind() == ClassKind.ENUM_CLASS && IrPredicatesKt.hasSerializableOrMetaAnnotation($this$isSerializableEnum);
    }

    @Nullable
    public static final Integer getGenericIndex(@NotNull IrType $this$genericIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$genericIndex, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)$this$genericIndex);
        IrTypeParameterSymbol irTypeParameterSymbol = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
        return irTypeParameterSymbol != null && (irTypeParameterSymbol = (IrTypeParameter)irTypeParameterSymbol.getOwner()) != null ? Integer.valueOf(irTypeParameterSymbol.getIndex()) : null;
    }

    @NotNull
    public static final String serialName(@NotNull IrType $this$serialName) {
        Intrinsics.checkNotNullParameter((Object)$this$serialName, (String)"<this>");
        IrClassSymbol irClassSymbol = IrPredicatesKt.classOrUpperBound($this$serialName);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return IrPredicatesKt.serialName((IrClass)irClassSymbol.getOwner());
    }

    @NotNull
    public static final String serialName(@NotNull IrClass $this$serialName) {
        Intrinsics.checkNotNullParameter((Object)$this$serialName, (String)"<this>");
        String string = IrPredicatesKt.getSerialNameValue($this$serialName.getAnnotations());
        if (string == null) {
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)$this$serialName));
            string = fqName != null ? fqName.asString() : null;
            if (string == null) {
                throw new IllegalStateException((RenderIrElementKt.render((IrElement)((IrElement)$this$serialName)) + " does not have fqName").toString());
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrSimpleFunction findEnumValuesMethod(@NotNull IrClass $this$findEnumValuesMethod) {
        Object object;
        block3: {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)$this$findEnumValuesMethod, (String)"<this>");
            Sequence $this$singleOrNull$iv = IrUtilsKt.getFunctions((IrClass)$this$findEnumValuesMethod);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunction f2 = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)f2.getName(), (Object)Name.identifier((String)"values")) && f2.getValueParameters().isEmpty() && f2.getExtensionReceiverParameter() == null && f2.getDispatchReceiverParameter() == null)) continue;
                if (found$iv) {
                    object = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)object;
        if (irSimpleFunction == null) {
            throw new AssertionError((Object)"Enum class does not have single .values() function");
        }
        return irSimpleFunction;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IrEnumEntry> enumEntries(@NotNull IrClass $this$enumEntries) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$enumEntries, (String)"<this>");
        if (!($this$enumEntries.getKind() == ClassKind.ENUM_CLASS)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Iterable $this$filterIsInstance$iv = $this$enumEntries.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    public static final boolean isEnumWithSerialInfoAnnotation(@NotNull IrClass $this$isEnumWithSerialInfoAnnotation) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$isEnumWithSerialInfoAnnotation, (String)"<this>");
            if ($this$isEnumWithSerialInfoAnnotation.getKind() != ClassKind.ENUM_CLASS) {
                return false;
            }
            if (IrPredicatesKt.getHasAnySerialAnnotation($this$isEnumWithSerialInfoAnnotation.getAnnotations())) {
                return true;
            }
            Iterable $this$any$iv = IrPredicatesKt.enumEntries($this$isEnumWithSerialInfoAnnotation);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrEnumEntry it = (IrEnumEntry)element$iv;
                    boolean bl2 = false;
                    if (!IrPredicatesKt.getHasAnySerialAnnotation(it.getAnnotations())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IrSimpleFunction findWriteSelfMethod(@NotNull IrClass $this$findWriteSelfMethod) {
        Object object;
        block2: {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)$this$findWriteSelfMethod, (String)"<this>");
            Sequence $this$singleOrNull$iv = IrUtilsKt.getFunctions((IrClass)$this$findWriteSelfMethod);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)SerialEntityNames.INSTANCE.getWRITE_SELF_NAME()) && !it.isFakeOverride())) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (IrSimpleFunction)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IrClass getSuperClassNotAny(@NotNull IrClass $this$getSuperClassNotAny) {
        Object v1;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getSuperClassNotAny, (String)"<this>");
            Iterable $this$mapNotNull$iv = $this$getSuperClassNotAny.getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl2 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)it);
                if ((irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
                if (!(it.getKind() == ClassKind.CLASS || it.getKind() == ClassKind.ENUM_CLASS)) continue;
                if (found$iv) {
                    v1 = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        IrClass irClass = v1;
        if (irClass == null) {
            return null;
        }
        IrClass parentClass = irClass;
        return IrTypePredicatesKt.isAny((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)parentClass))) ? null : parentClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFromPlugin(@NotNull IrDeclaration $this$isFromPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromPlugin, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$isFromPlugin.getOrigin(), (Object)new IrDeclarationOrigin.GeneratedByPlugin((GeneratedDeclarationKey)SerializationPluginKey.INSTANCE))) return true;
        DeclarationDescriptor declarationDescriptor = $this$isFromPlugin.getDescriptor();
        CallableMemberDescriptor callableMemberDescriptor = declarationDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor : null;
        if ((callableMemberDescriptor != null ? callableMemberDescriptor.getKind() : null) != CallableMemberDescriptor.Kind.SYNTHESIZED) return false;
        return true;
    }

    public static final boolean isSerializationCtor(@NotNull IrConstructor $this$isSerializationCtor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isSerializationCtor, (String)"<this>");
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.lastOrNull((List)$this$isSerializationCtor.getValueParameters());
        if (irValueParameter != null) {
            IrValueParameter $this$isSerializationCtor_u24lambda_u249 = irValueParameter;
            boolean bl2 = false;
            bl = Intrinsics.areEqual((Object)$this$isSerializationCtor_u24lambda_u249.getName(), (Object)SerialEntityNames.INSTANCE.getDummyParamName()) && Intrinsics.areEqual((Object)IrTypesKt.getClassFqName((IrType)$this$isSerializationCtor_u24lambda_u249.getType()), (Object)SerializationPackages.INSTANCE.getInternalPackageFqName().child(SerialEntityNames.INSTANCE.getSERIAL_CTOR_MARKER_NAME()));
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean lastArgumentIsAnnotationArray(@NotNull IrConstructor $this$lastArgumentIsAnnotationArray) {
        IrType lastArgType;
        Intrinsics.checkNotNullParameter((Object)$this$lastArgumentIsAnnotationArray, (String)"<this>");
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.lastOrNull((List)$this$lastArgumentIsAnnotationArray.getValueParameters());
        Object object = lastArgType = irValueParameter != null ? irValueParameter.getType() : null;
        if (lastArgType == null || !IrTypePredicatesKt.isArray((IrType)lastArgType)) {
            return false;
        }
        Object object2 = lastArgType instanceof IrSimpleType ? (IrSimpleType)lastArgType : null;
        return Intrinsics.areEqual(object2 != null && (object2 = object2.getArguments()) != null && (object2 = (IrTypeArgument)CollectionsKt.firstOrNull((List)object2)) != null && (object2 = IrTypesKt.getTypeOrNull((IrTypeArgument)object2)) != null && (object2 = IrTypesKt.getClassFqName((IrType)object2)) != null ? object2.toString() : null, (Object)"kotlin.Annotation");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IrConstructorSymbol findSerializableSyntheticConstructor(@NotNull IrClass $this$findSerializableSyntheticConstructor) {
        Iterable iterable;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$findSerializableSyntheticConstructor, (String)"<this>");
            Iterable $this$filterIsInstance$iv = $this$findSerializableSyntheticConstructor.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrConstructor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl = false;
                if (!IrPredicatesKt.isSerializationCtor(it)) continue;
                if (found$iv) {
                    iterable = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            iterable = !found$iv ? null : iterable2;
        }
        IrConstructor irConstructor = (IrConstructor)iterable;
        return irConstructor != null ? irConstructor.getSymbol() : null;
    }

    public static final boolean needSerializerFactory(@NotNull IrClass $this$needSerializerFactory, @NotNull SerializationPluginContext compilerContext) {
        Intrinsics.checkNotNullParameter((Object)$this$needSerializerFactory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)compilerContext, (String)"compilerContext");
        TargetPlatform targetPlatform = compilerContext.getPlatform();
        if (!(targetPlatform != null ? NativePlatformKt.isNative((TargetPlatform)targetPlatform) : false) && !JsPlatformKt.isJs((TargetPlatform)compilerContext.getPlatform())) {
            return false;
        }
        IrClass irClass = IrPredicatesKt.getSerializableClassDescriptorByCompanion($this$needSerializerFactory);
        if (irClass == null) {
            return false;
        }
        IrClass serializableClass = irClass;
        if (IrPredicatesKt.isSerializableObject(serializableClass)) {
            return true;
        }
        if (IrPredicatesKt.isSerializableEnum(serializableClass)) {
            return true;
        }
        if (IrPredicatesKt.isAbstractOrSealedSerializableClass(serializableClass)) {
            return true;
        }
        if (IrPredicatesKt.isSealedSerializableInterface(serializableClass)) {
            return true;
        }
        return !serializableClass.getTypeParameters().isEmpty();
    }

    @Nullable
    public static final IrClass getSerializableClassDescriptorByCompanion(@NotNull IrClass companion) {
        Intrinsics.checkNotNullParameter((Object)companion, (String)"companion");
        if (IrPredicatesKt.isSerializableObject(companion)) {
            return companion;
        }
        if (!companion.isCompanion()) {
            return null;
        }
        IrDeclarationParent irDeclarationParent = companion.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return null;
        }
        IrClass classDescriptor = irClass;
        if (!IrPredicatesKt.getShouldHaveGeneratedMethodsInCompanion(classDescriptor)) {
            return null;
        }
        return classDescriptor;
    }

    public static final boolean isInitializePropertyFromParameter(@NotNull IrExpression $this$isInitializePropertyFromParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isInitializePropertyFromParameter, (String)"<this>");
        return $this$isInitializePropertyFromParameter instanceof IrGetValueImpl && Intrinsics.areEqual((Object)((IrGetValueImpl)$this$isInitializePropertyFromParameter).getOrigin(), (Object)IrStatementOrigin.INITIALIZE_PROPERTY_FROM_PARAMETER.INSTANCE);
    }

    @NotNull
    public static final IrClass getConstructedClass(@NotNull IrConstructorCall $this$constructedClass) {
        Intrinsics.checkNotNullParameter((Object)$this$constructedClass, (String)"<this>");
        return AdditionalIrUtilsKt.getConstructedClass((IrConstructor)((IrConstructor)$this$constructedClass.getSymbol().getOwner()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasAnySerialAnnotation(@NotNull List<? extends IrConstructorCall> $this$hasAnySerialAnnotation) {
        IrConstructorCall it;
        Intrinsics.checkNotNullParameter($this$hasAnySerialAnnotation, (String)"<this>");
        if (IrPredicatesKt.getSerialNameValue($this$hasAnySerialAnnotation) != null) return true;
        Iterable $this$any$iv = $this$hasAnySerialAnnotation;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (IrConstructorCall)element$iv;
            boolean bl = false;
        } while (!IrPredicatesKt.isSerialInfoAnnotation(IrPredicatesKt.getConstructedClass(it)));
        return true;
    }

    @Nullable
    public static final String getSerialNameValue(@NotNull List<? extends IrConstructorCall> $this$serialNameValue) {
        Intrinsics.checkNotNullParameter($this$serialNameValue, (String)"<this>");
        IrConstructorCall irConstructorCall = AdditionalIrUtilsKt.findAnnotation($this$serialNameValue, (FqName)SerializationAnnotations.INSTANCE.getSerialNameAnnotationFqName());
        return irConstructorCall != null ? JvmIrUtilsKt.getStringConstArgument((IrMemberAccessExpression)((IrMemberAccessExpression)irConstructorCall), (int)0) : null;
    }

    @Nullable
    public static final Boolean getEncodeDefaultAnnotationValue(@NotNull IrProperty $this$getEncodeDefaultAnnotationValue) {
        Boolean bl;
        String argValue;
        Intrinsics.checkNotNullParameter((Object)$this$getEncodeDefaultAnnotationValue, (String)"<this>");
        IrConstructorCall irConstructorCall = AdditionalIrUtilsKt.findAnnotation((List)$this$getEncodeDefaultAnnotationValue.getAnnotations(), (FqName)SerializationAnnotations.INSTANCE.getEncodeDefaultFqName());
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall call = irConstructorCall;
        IrExpression irExpression = call.getValueArgument(0);
        if (irExpression == null) {
            return true;
        }
        IrExpression arg = irExpression;
        IrGetEnumValue irGetEnumValue = arg instanceof IrGetEnumValue ? (IrGetEnumValue)arg : null;
        if (irGetEnumValue == null) {
            throw new IllegalStateException(("Argument of enum constructor expected to implement IrGetEnumValue, got " + arg).toString());
        }
        String string = ((IrEnumEntry)irGetEnumValue.getSymbol().getOwner()).getName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arg as? IrGetEnumValue\n \u2026bol.owner.name.toString()");
        string = argValue = string;
        if (Intrinsics.areEqual((Object)string, (Object)"ALWAYS")) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)"NEVER")) {
            bl = false;
        } else {
            throw new IllegalStateException(("Unknown EncodeDefaultMode enum value: " + argValue).toString());
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final IrConstructorSymbol findSerializerConstructorForTypeArgumentsSerializers(@NotNull IrClass serializer) {
        block11: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
                var4_1 = serializer.getSuperTypes();
                for (T var6_4 : var4_1) {
                    it = (IrType)var6_4;
                    $i$a$-find-IrPredicatesKt$findSerializerConstructorForTypeArgumentsSerializers$typeParamsCount$1 = false;
                    if (!IrPredicatesKt.isKSerializer(it)) continue;
                    v0 = var6_4;
                    break block9;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            v1 = IrTypesKt.getTypeOrNull((IrTypeArgument)((IrTypeArgument)CollectionsKt.first((List)((IrSimpleType)v0).getArguments())));
            Intrinsics.checkNotNull((Object)v1);
            typeParamsCount = ((IrSimpleType)v1).getArguments().size();
            if (typeParamsCount == 0) {
                return null;
            }
            $this$singleOrNull$iv = IrUtilsKt.getConstructors((IrClass)serializer);
            $i$f$singleOrNull = false;
            single$iv = null;
            found$iv = false;
            for (E element$iv : $this$singleOrNull$iv) {
                block10: {
                    it = (IrConstructor)element$iv;
                    $i$a$-singleOrNull-IrPredicatesKt$findSerializerConstructorForTypeArgumentsSerializers$1 = false;
                    vps = it.getValueParameters();
                    $i$a$-let-IrPredicatesKt$findSerializerConstructorForTypeArgumentsSerializers$1$1 = false;
                    if (vps.size() != typeParamsCount) ** GOTO lbl-1000
                    $this$all$iv = vps;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v2 = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            vp = (IrValueParameter)element$iv;
                            $i$a$-all-IrPredicatesKt$findSerializerConstructorForTypeArgumentsSerializers$1$1$1 = false;
                            if (IrPredicatesKt.isKSerializer(vp.getType())) continue;
                            v2 = false;
                            break block10;
                        }
                        v2 = true;
                    }
                }
                if (v2) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                if (found$iv) {
                    v4 = null;
                    break block11;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = found$iv == false ? null : single$iv;
        }
        var2_21 = v4;
        return var2_21 != null ? var2_21.getSymbol() : null;
    }

    @Nullable
    public static final IrClassSymbol classOrUpperBound(@NotNull IrType $this$classOrUpperBound) {
        Intrinsics.checkNotNullParameter((Object)$this$classOrUpperBound, (String)"<this>");
        IrClassifierSymbol cls = IrTypesKt.getClassifierOrNull((IrType)$this$classOrUpperBound);
        return cls instanceof IrClassSymbol ? (IrClassSymbol)cls : (cls instanceof IrScriptSymbol ? ((IrScript)((IrScriptSymbol)cls).getOwner()).getTargetClass() : (cls instanceof IrTypeParameterSymbol ? IrPredicatesKt.classOrUpperBound(JvmIrTypeUtilsKt.getRepresentativeUpperBound((IrTypeParameter)((IrTypeParameter)((IrTypeParameterSymbol)cls).getOwner()))) : null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<IrType> argumentTypesOrUpperBounds(@NotNull IrSimpleType $this$argumentTypesOrUpperBounds) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$argumentTypesOrUpperBounds, (String)"<this>");
        IrClassSymbol irClassSymbol = IrPredicatesKt.classOrUpperBound((IrType)$this$argumentTypesOrUpperBounds);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        List params = ((IrClass)irClassSymbol.getOwner()).getTypeParameters();
        Iterable $this$mapIndexed$iv = $this$argumentTypesOrUpperBounds.getArguments();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void argument;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)argument);
            if (irType == null) {
                void index;
                irType = JvmIrTypeUtilsKt.getRepresentativeUpperBound((IrTypeParameter)((IrTypeParameter)params.get((int)index)));
            }
            collection.add(irType);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean shouldHaveSpecificSyntheticMethods(@NotNull IrClass $this$shouldHaveSpecificSyntheticMethods, @NotNull Function0<? extends IrSimpleFunction> functionPresenceChecker) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSpecificSyntheticMethods, (String)"<this>");
        Intrinsics.checkNotNullParameter(functionPresenceChecker, (String)"functionPresenceChecker");
        boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
        return !$this$shouldHaveSpecificSyntheticMethods.isValue() && (IrPredicatesKt.isAbstractOrSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods) || functionPresenceChecker.invoke() != null);
    }
}

