/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.common;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializerCodegen;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializablePropertiesKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H$J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u001d\u0010\u0017\u001a\u00020\u0018*\u00020\u00032\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u001aH\u0082\bR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerializableCodegen;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "serializableDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "properties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "getProperties", "()Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "getSerializableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "generate", "", "generateInternalConstructor", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateSyntheticInternalConstructor", "generateSyntheticMethods", "generateWriteSelfMethod", "methodDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "shouldHaveSpecificSyntheticMethods", "", "functionPresenceChecker", "Lkotlin/Function0;", "kotlin-maven-serialization"})
public abstract class SerializableCodegen
extends AbstractSerialGenerator {
    @NotNull
    private final ClassDescriptor serializableDescriptor;
    @NotNull
    private final SerializableProperties properties;

    public SerializableCodegen(@NotNull ClassDescriptor serializableDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)serializableDescriptor, (String)"serializableDescriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        super(bindingContext, serializableDescriptor);
        this.serializableDescriptor = serializableDescriptor;
        this.properties = SerializablePropertiesKt.serializablePropertiesFor$default(bindingContext, this.serializableDescriptor, null, 2, null);
    }

    @NotNull
    protected final ClassDescriptor getSerializableDescriptor() {
        return this.serializableDescriptor;
    }

    @NotNull
    protected final SerializableProperties getProperties() {
        return this.properties;
    }

    public final void generate() {
        this.generateSyntheticInternalConstructor();
        this.generateSyntheticMethods();
    }

    private final boolean shouldHaveSpecificSyntheticMethods(ClassDescriptor $this$shouldHaveSpecificSyntheticMethods, Function0<? extends FunctionDescriptor> functionPresenceChecker) {
        boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
        return !InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)((DeclarationDescriptor)$this$shouldHaveSpecificSyntheticMethods)) && (KSerializationUtilKt.isAbstractOrSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods) || functionPresenceChecker.invoke() != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void generateSyntheticInternalConstructor() {
        Object v1;
        block4: {
            ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.serializableDescriptor);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor serializerDescriptor = classDescriptor;
            SerializableCodegen serializableCodegen = this;
            ClassDescriptor $this$shouldHaveSpecificSyntheticMethods$iv = this.serializableDescriptor;
            boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
            if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)((DeclarationDescriptor)$this$shouldHaveSpecificSyntheticMethods$iv))) return;
            if (!KSerializationUtilKt.isAbstractOrSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv)) {
                boolean bl = false;
                if (SerializerCodegen.Companion.getSyntheticLoadMember(serializerDescriptor) == null) return;
            }
            boolean bl = true;
            if (!bl) return;
            Iterable iterable = DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)this.serializableDescriptor);
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            boolean bl3 = false;
            for (Object t : iterable2) {
                ClassConstructorDescriptor p0 = (ClassConstructorDescriptor)t;
                boolean bl4 = false;
                if (!SearchUtilsKt.isSerializationCtor(p0)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        ClassConstructorDescriptor classConstructorDescriptor = v1;
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = classConstructorDescriptor;
        this.generateInternalConstructor(classConstructorDescriptor2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void generateSyntheticMethods() {
        Object v3;
        block5: {
            ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.serializableDescriptor);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor serializerDescriptor = classDescriptor;
            SerializableCodegen serializableCodegen = this;
            ClassDescriptor $this$shouldHaveSpecificSyntheticMethods$iv = this.serializableDescriptor;
            boolean bl = false;
            if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)((DeclarationDescriptor)$this$shouldHaveSpecificSyntheticMethods$iv))) return;
            if (!KSerializationUtilKt.isAbstractOrSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv)) {
                boolean bl2 = false;
                if (SerializerCodegen.Companion.getSyntheticSaveMember(serializerDescriptor) == null) return;
            }
            boolean bl3 = true;
            if (!bl3) return;
            MemberScope memberScope = this.serializableDescriptor.getUnsubstitutedMemberScope();
            Name name = Name.identifier((String)SerialEntityNames.INSTANCE.getWRITE_SELF_NAME().toString());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(SerialEntityN\u2026ITE_SELF_NAME.toString())");
            Iterable iterable = memberScope.getContributedFunctions(name, (LookupLocation)NoLookupLocation.FROM_BACKEND);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : iterable) {
                boolean bl4;
                KotlinType kotlinType;
                SimpleFunctionDescriptor function = (SimpleFunctionDescriptor)element$iv;
                boolean bl5 = false;
                boolean bl6 = function.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED && function.getModality() == Modality.FINAL && ((kotlinType = function.getReturnType()) == null ? false : (bl4 = TypeUtilsKt.isUnit((KotlinType)kotlinType)));
                if (!bl6) continue;
                if (found$iv) {
                    v3 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = v3;
        if (simpleFunctionDescriptor == null) {
            return;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor2 = simpleFunctionDescriptor;
        this.generateWriteSelfMethod((FunctionDescriptor)simpleFunctionDescriptor2);
    }

    protected abstract void generateInternalConstructor(@NotNull ClassConstructorDescriptor var1);

    protected void generateWriteSelfMethod(@NotNull FunctionDescriptor methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
    }
}

