/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.SerializerCodegen;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.VersionReader;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializerDescriptorResolver;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH$J\b\u0010\u001b\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0004J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0#H\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/SerializableCodegen;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "serializableDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "fieldMissingOptimizationVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "properties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "getProperties", "()Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "getSerializableDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "staticDescriptor", "", "getStaticDescriptor", "()Z", "useFieldMissingOptimization", "getUseFieldMissingOptimization", "canUseFieldMissingOptimization", "generate", "", "generateInternalConstructor", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "generateSyntheticInternalConstructor", "generateSyntheticMethods", "generateWriteSelfMethod", "methodDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getGoldenMask", "", "getGoldenMaskList", "", "kotlin-maven-serialization"})
public abstract class SerializableCodegen
extends AbstractSerialGenerator {
    @NotNull
    private final SerializableProperties properties;
    private final boolean staticDescriptor;
    private final ApiVersion fieldMissingOptimizationVersion;
    private final boolean useFieldMissingOptimization;
    @NotNull
    private final ClassDescriptor serializableDescriptor;

    @NotNull
    protected final SerializableProperties getProperties() {
        return this.properties;
    }

    protected final boolean getStaticDescriptor() {
        return this.staticDescriptor;
    }

    protected final boolean getUseFieldMissingOptimization() {
        return this.useFieldMissingOptimization;
    }

    public final void generate() {
        this.generateSyntheticInternalConstructor();
        this.generateSyntheticMethods();
    }

    private final void generateSyntheticInternalConstructor() {
        ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.serializableDescriptor);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor serializerDescriptor = classDescriptor;
        if (KSerializationUtilKt.isAbstractSerializableClass(this.serializableDescriptor) || KSerializationUtilKt.isSealedSerializableClass(this.serializableDescriptor) || SerializerCodegen.Companion.getSyntheticLoadMember(serializerDescriptor) != null) {
            Object v1;
            block4: {
                Iterable iterable = DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)this.serializableDescriptor);
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    ClassConstructorDescriptor p1 = (ClassConstructorDescriptor)t;
                    boolean bl3 = false;
                    if (!SearchUtilsKt.isSerializationCtor(p1)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            ClassConstructorDescriptor classConstructorDescriptor = v1;
            if (classConstructorDescriptor == null) {
                return;
            }
            ClassConstructorDescriptor constrDesc = classConstructorDescriptor;
            this.generateInternalConstructor(constrDesc);
        }
    }

    private final void generateSyntheticMethods() {
        ClassDescriptor classDescriptor = KSerializationUtilKt.getClassSerializer(this.serializableDescriptor);
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor serializerDescriptor = classDescriptor;
        if (KSerializationUtilKt.isAbstractSerializableClass(this.serializableDescriptor) || KSerializationUtilKt.isSealedSerializableClass(this.serializableDescriptor) || SerializerCodegen.Companion.getSyntheticSaveMember(serializerDescriptor) != null) {
            FunctionDescriptor func = KSerializerDescriptorResolver.INSTANCE.createWriteSelfFunctionDescriptor(this.serializableDescriptor);
            this.generateWriteSelfMethod(func);
        }
    }

    protected final int getGoldenMask() {
        int goldenMask = 0;
        int requiredBit = 1;
        for (SerializableProperty property : this.properties.getSerializableProperties()) {
            if (!property.getOptional()) {
                goldenMask |= requiredBit;
            }
            requiredBit <<= 1;
        }
        return goldenMask;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<Integer> getGoldenMaskList() {
        int maskSlotCount = SerializablePropertiesKt.bitMaskSlotCount(this.properties.getSerializableProperties());
        int n = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(maskSlotCount);
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = maskSlotCount;
        while (n2 < n3) {
            int n4 = n2++;
            boolean bl2 = false;
            int n5 = n4;
            ArrayList<Integer> arrayList2 = arrayList;
            boolean bl3 = false;
            Integer n6 = 0;
            arrayList2.add(n6);
        }
        List goldenMaskList = arrayList;
        n = 0;
        int n7 = ((Collection)this.properties.getSerializableProperties()).size();
        while (n < n7) {
            void i;
            if (!this.properties.getSerializableProperties().get((int)i).getOptional()) {
                void slotNumber = i / 32;
                void bitInSlot = i % 32;
                goldenMaskList.set((int)slotNumber, ((Number)goldenMaskList.get((int)slotNumber)).intValue() | 1 << bitInSlot);
            }
            ++i;
        }
        return goldenMaskList;
    }

    private final boolean canUseFieldMissingOptimization() {
        ApiVersion implementationVersion;
        VersionReader.RuntimeVersions runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromContext(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.serializableDescriptor)), this.getBindingContext());
        Object object = implementationVersion = runtimeVersions != null ? runtimeVersions.getImplementationVersion() : null;
        return implementationVersion != null ? implementationVersion.compareTo(this.fieldMissingOptimizationVersion) >= 0 : false;
    }

    protected abstract void generateInternalConstructor(@NotNull ClassConstructorDescriptor var1);

    protected void generateWriteSelfMethod(@NotNull FunctionDescriptor methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
    }

    @NotNull
    protected final ClassDescriptor getSerializableDescriptor() {
        return this.serializableDescriptor;
    }

    public SerializableCodegen(@NotNull ClassDescriptor serializableDescriptor, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)serializableDescriptor, (String)"serializableDescriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        super(bindingContext, serializableDescriptor);
        this.serializableDescriptor = serializableDescriptor;
        this.properties = SerializablePropertiesKt.serializablePropertiesFor$default(bindingContext, this.serializableDescriptor, null, 2, null);
        this.staticDescriptor = this.serializableDescriptor.getDeclaredTypeParameters().isEmpty();
        ApiVersion apiVersion = ApiVersion.Companion.parse("1.1");
        Intrinsics.checkNotNull((Object)apiVersion);
        this.fieldMissingOptimizationVersion = apiVersion;
        this.useFieldMissingOptimization = this.canUseFieldMissingOptimization();
    }
}

