/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.google.common.base.Joiner;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.maven.IdeaCoreLoggerFactory;
import org.jetbrains.kotlin.maven.KotlinMavenPluginExtension;
import org.jetbrains.kotlin.maven.MavenPluginLogMessageCollector;
import org.jetbrains.kotlin.maven.PluginOption;

public abstract class KotlinCompileMojoBase<A extends CommonCompilerArguments>
extends AbstractMojo {
    @Component
    protected PlexusContainer container;
    @Component
    protected MojoExecution mojoExecution;
    @Component
    protected RepositorySystem system;
    @Parameter
    private List<String> sourceDirs;
    @Parameter
    private List<String> compilerPlugins;
    @Parameter
    private List<String> pluginOptions;
    @Parameter
    private boolean multiPlatform = false;
    @Parameter(defaultValue="false")
    public boolean nowarn;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    public String output;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    public String testOutput;
    @Deprecated
    @Parameter(readonly=true)
    public String module;
    @Deprecated
    @Parameter(readonly=true)
    public String testModule;
    @Parameter(property="kotlin.compiler.languageVersion")
    protected String languageVersion;
    @Parameter(property="kotlin.compiler.apiVersion")
    protected String apiVersion;
    @Parameter(property="kotlin.compiler.experimental.coroutines")
    @Nullable
    protected String experimentalCoroutines;
    @Parameter
    public List<String> args;
    private static final Pattern OPTION_PATTERN = Pattern.compile("([^:]+):([^=]+)=(.*)");

    protected List<String> getSourceFilePaths() {
        if (this.sourceDirs != null && !this.sourceDirs.isEmpty()) {
            return this.sourceDirs;
        }
        return this.project.getCompileSourceRoots();
    }

    @NotNull
    private List<File> getSourceDirs() {
        List<String> sources = this.getSourceFilePaths();
        ArrayList<File> result = new ArrayList<File>(sources.size());
        for (String source : sources) {
            this.addSourceRoots(result, source);
        }
        Map projectReferences = this.project.getProjectReferences();
        if (projectReferences != null) {
            block1: for (Dependency dependency : this.project.getDependencies()) {
                Plugin plugin;
                MavenProject sibling = (MavenProject)projectReferences.get(dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion());
                if (sibling == null || (plugin = sibling.getPlugin("org.jetbrains.kotlin:kotlin-maven-plugin")) == null) continue;
                for (PluginExecution pluginExecution : plugin.getExecutions()) {
                    Iterator<String> iterator;
                    if (pluginExecution.getGoals() == null || !pluginExecution.getGoals().contains("metadata") || !(iterator = KotlinCompileMojoBase.orEmpty(this.getRelatedSourceRoots(sibling)).iterator()).hasNext()) continue;
                    String sourceRoot = iterator.next();
                    this.addSourceRoots(result, sourceRoot);
                    continue block1;
                }
            }
        }
        return result;
    }

    protected abstract List<String> getRelatedSourceRoots(MavenProject var1);

    private void addSourceRoots(List<File> result, String source) {
        File f = new File(source);
        if (f.isAbsolute()) {
            result.add(f);
        } else {
            result.add(new File(this.project.getBasedir(), source));
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Kotlin version 1.1.4-2 (JRE " + System.getProperty("java.runtime.version") + ")"));
        if (!this.hasKotlinFilesInSources()) {
            this.getLog().warn((CharSequence)"No sources found skipping Kotlin compile");
            return;
        }
        A arguments = this.createCompilerArguments();
        CLICompiler<A> compiler = this.createCompiler();
        List<File> sourceRoots = this.getSourceRoots();
        this.configureCompilerArguments(arguments, compiler, sourceRoots);
        this.printCompilerArgumentsIfDebugEnabled(arguments, compiler);
        MavenPluginLogMessageCollector messageCollector = new MavenPluginLogMessageCollector(this.getLog());
        ExitCode exitCode = this.execCompiler(compiler, messageCollector, arguments, sourceRoots);
        if (exitCode != ExitCode.OK) {
            messageCollector.throwKotlinCompilerException();
        }
    }

    @NotNull
    protected ExitCode execCompiler(CLICompiler<A> compiler, MessageCollector messageCollector, A arguments, List<File> sourceRoots) throws MojoExecutionException {
        for (File sourceRoot : sourceRoots) {
            ((CommonCompilerArguments)arguments).freeArgs.add(sourceRoot.getPath());
        }
        return compiler.exec(messageCollector, Services.EMPTY, arguments);
    }

    private boolean hasKotlinFilesInSources() throws MojoExecutionException {
        for (File root : this.getSourceDirs()) {
            boolean sourcesExists;
            if (!root.exists() || !(sourcesExists = !FileUtil.processFilesRecursively((File)root, file -> !file.getName().endsWith(".kt")))) continue;
            return true;
        }
        return false;
    }

    private void printCompilerArgumentsIfDebugEnabled(@NotNull A arguments, @NotNull CLICompiler<A> compiler) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Invoking compiler " + compiler + " with arguments:"));
            try {
                Field[] fields;
                for (Field f : fields = arguments.getClass().getFields()) {
                    Object value = f.get(arguments);
                    String valueString = value instanceof Object[] ? Arrays.deepToString((Object[])value) : (value != null ? String.valueOf(value) : "(null)");
                    this.getLog().debug((CharSequence)(f.getName() + "=" + valueString));
                }
                this.getLog().debug((CharSequence)"End of arguments");
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to print compiler arguments: " + e), (Throwable)e);
            }
        }
    }

    @NotNull
    protected abstract CLICompiler<A> createCompiler();

    @NotNull
    protected abstract A createCompilerArguments();

    protected abstract void configureSpecificCompilerArguments(@NotNull A var1, @NotNull List<File> var2) throws MojoExecutionException;

    private List<String> getCompilerPluginClassPaths() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<File> files = new ArrayList<File>();
        for (Dependency dependency : this.mojoExecution.getPlugin().getDependencies()) {
            Artifact artifact = this.system.createDependencyArtifact(dependency);
            ArtifactResolutionResult resolved = this.system.resolve(new ArtifactResolutionRequest().setArtifact(artifact));
            for (Artifact resolvedArtifact : resolved.getArtifacts()) {
                File file = resolvedArtifact.getFile();
                if (file == null || !file.exists()) continue;
                files.add(file);
            }
        }
        for (File file : files) {
            result.add(file.getAbsolutePath());
        }
        return result;
    }

    @NotNull
    private Map<String, KotlinMavenPluginExtension> loadCompilerPlugins() throws PluginNotFoundException {
        if (this.compilerPlugins == null) {
            return Collections.emptyMap();
        }
        HashMap<String, KotlinMavenPluginExtension> loadedPlugins = new HashMap<String, KotlinMavenPluginExtension>();
        for (String pluginName : this.compilerPlugins) {
            this.getLog().debug((CharSequence)("Looking for plugin " + pluginName));
            try {
                KotlinMavenPluginExtension extension = (KotlinMavenPluginExtension)this.container.lookup(KotlinMavenPluginExtension.class, pluginName);
                loadedPlugins.put(pluginName, extension);
                this.getLog().debug((CharSequence)("Got plugin instance" + pluginName + " of type " + extension.getClass().getName()));
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)("Unable to get plugin instance" + pluginName));
                throw new PluginNotFoundException(pluginName, e);
            }
        }
        return loadedPlugins;
    }

    @NotNull
    private List<String> renderCompilerPluginOptions(@NotNull List<PluginOption> options) {
        ArrayList<String> renderedOptions = new ArrayList<String>(options.size());
        for (PluginOption option : options) {
            renderedOptions.add(option.toString());
        }
        return renderedOptions;
    }

    @NotNull
    private List<PluginOption> getCompilerPluginOptions() throws PluginNotFoundException, PluginOptionIllegalFormatException {
        if (this.mojoExecution == null) {
            throw new IllegalStateException("No mojoExecution injected");
        }
        ArrayList<PluginOption> pluginOptions = new ArrayList<PluginOption>();
        Map<String, KotlinMavenPluginExtension> plugins = this.loadCompilerPlugins();
        for (Map.Entry<String, KotlinMavenPluginExtension> pluginEntry : plugins.entrySet()) {
            String string = pluginEntry.getKey();
            KotlinMavenPluginExtension plugin = pluginEntry.getValue();
            if (!plugin.isApplicable(this.project, this.mojoExecution)) continue;
            this.getLog().info((CharSequence)("Applied plugin: '" + string + "'"));
            List<PluginOption> optionsForPlugin = plugin.getPluginOptions(this.project, this.mojoExecution);
            if (optionsForPlugin.isEmpty()) continue;
            pluginOptions.addAll(optionsForPlugin);
        }
        if (this.pluginOptions != null) {
            pluginOptions.addAll(KotlinCompileMojoBase.parseUserProvidedPluginOptions(this.pluginOptions, plugins));
        }
        LinkedHashMap<String, List> optionsByPluginName = new LinkedHashMap<String, List>();
        for (PluginOption pluginOption : pluginOptions) {
            optionsByPluginName.computeIfAbsent(pluginOption.pluginName, key -> new ArrayList()).add(pluginOption);
        }
        for (Map.Entry entry : optionsByPluginName.entrySet()) {
            assert (!((List)entry.getValue()).isEmpty());
            String pluginName = ((PluginOption)((List)entry.getValue()).get((int)0)).pluginName;
            StringBuilder renderedOptions = new StringBuilder("[");
            for (PluginOption option : (List)entry.getValue()) {
                if (renderedOptions.length() > 1) {
                    renderedOptions.append(", ");
                }
                renderedOptions.append(option.key).append(": ").append(option.value);
            }
            renderedOptions.append("]");
            this.getLog().debug((CharSequence)("Options for plugin " + pluginName + ": " + renderedOptions));
        }
        return pluginOptions;
    }

    @NotNull
    private static List<PluginOption> parseUserProvidedPluginOptions(@NotNull List<String> rawOptions, @NotNull Map<String, KotlinMavenPluginExtension> plugins) throws PluginOptionIllegalFormatException, PluginNotFoundException {
        ArrayList<PluginOption> pluginOptions = new ArrayList<PluginOption>(rawOptions.size());
        for (String rawOption : rawOptions) {
            Matcher matcher = OPTION_PATTERN.matcher(rawOption);
            if (!matcher.matches()) {
                throw new PluginOptionIllegalFormatException(rawOption);
            }
            String pluginName = matcher.group(1);
            String key = matcher.group(2);
            String value = matcher.group(3);
            KotlinMavenPluginExtension plugin = plugins.get(pluginName);
            if (plugin == null) {
                throw new PluginNotFoundException(pluginName);
            }
            pluginOptions.add(new PluginOption(pluginName, plugin.getCompilerPluginId(), key, value));
        }
        return pluginOptions;
    }

    @NotNull
    private List<File> getSourceRoots() throws MojoExecutionException {
        ArrayList<File> sourceRoots = new ArrayList<File>();
        for (File sourceDir : this.getSourceDirs()) {
            if (sourceDir.exists()) {
                sourceRoots.add(sourceDir);
                continue;
            }
            if (sourceDir.getPath().contains("generated-sources")) continue;
            this.getLog().warn((CharSequence)("Source root doesn't exist: " + sourceDir));
        }
        if (sourceRoots.isEmpty()) {
            throw new MojoExecutionException("No source roots to compile");
        }
        this.getLog().info((CharSequence)("Compiling Kotlin sources from " + sourceRoots));
        return sourceRoots;
    }

    private void configureCompilerArguments(@NotNull A arguments, @NotNull CLICompiler<A> compiler, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        List<String> pluginArguments;
        List<String> pluginClassPaths;
        if (this.getLog().isDebugEnabled()) {
            ((CommonCompilerArguments)arguments).verbose = true;
        }
        ((CommonCompilerArguments)arguments).suppressWarnings = this.nowarn;
        ((CommonCompilerArguments)arguments).languageVersion = this.languageVersion;
        ((CommonCompilerArguments)arguments).apiVersion = this.apiVersion;
        ((CommonCompilerArguments)arguments).multiPlatform = this.multiPlatform;
        if (this.experimentalCoroutines != null) {
            ((CommonCompilerArguments)arguments).coroutinesState = this.experimentalCoroutines;
        }
        this.configureSpecificCompilerArguments(arguments, sourceRoots);
        try {
            compiler.parseArguments(ArrayUtil.toStringArray(this.args), arguments);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (((CommonCompilerArguments)arguments).noInline) {
            this.getLog().info((CharSequence)"Method inlining is turned off");
        }
        if ((pluginClassPaths = this.getCompilerPluginClassPaths()) != null && !pluginClassPaths.isEmpty()) {
            if (((CommonCompilerArguments)arguments).pluginClasspaths == null || ((CommonCompilerArguments)arguments).pluginClasspaths.length == 0) {
                ((CommonCompilerArguments)arguments).pluginClasspaths = pluginClassPaths.toArray(new String[pluginClassPaths.size()]);
            } else {
                for (String path : pluginClassPaths) {
                    if (ArrayUtil.indexOf((Object[])((CommonCompilerArguments)arguments).pluginClasspaths, (Object)path) >= 0) continue;
                    ((CommonCompilerArguments)arguments).pluginClasspaths = (String[])ArrayUtil.append((Object[])((CommonCompilerArguments)arguments).pluginClasspaths, (Object)path);
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Plugin classpaths are: " + Joiner.on((String)", ").join((Object[])((CommonCompilerArguments)arguments).pluginClasspaths)));
            }
        }
        try {
            pluginArguments = this.renderCompilerPluginOptions(this.getCompilerPluginOptions());
        }
        catch (PluginNotFoundException | PluginOptionIllegalFormatException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (!pluginArguments.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Plugin options are: " + Joiner.on((String)", ").join(pluginArguments)));
            }
            ((CommonCompilerArguments)arguments).pluginOptions = pluginArguments.toArray(new String[pluginArguments.size()]);
        }
    }

    @NotNull
    private static <T> List<T> orEmpty(@Nullable List<T> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return in;
    }

    static {
        if (System.getProperty("kotlin.compiler.X.enable.idea.logger") != null) {
            Logger.setFactory(IdeaCoreLoggerFactory.class);
        }
    }

    public static class PluginOptionIllegalFormatException
    extends Exception {
        PluginOptionIllegalFormatException(String option) {
            super("Plugin option has an illegal format: " + option);
        }
    }

    public static class PluginNotFoundException
    extends Exception {
        PluginNotFoundException(String pluginId, Throwable cause) {
            super("Plugin not found: " + pluginId, cause);
        }

        PluginNotFoundException(String pluginId) {
            super("Plugin not found: " + pluginId);
        }
    }
}

