/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.IncrementalJvmCompilerRunnerKt;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.maven.Util;
import org.jetbrains.kotlin.maven.incremental.MavenICReporter;
import org.jetbrains.kotlin.maven.kapt.AnnotationProcessingManager;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class K2JVMCompileMojo
extends KotlinCompileMojoBase<K2JVMCompilerArguments> {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String moduleName;
    @Parameter(defaultValue="${project.artifactId}-test", required=true, readonly=true)
    protected String testModuleName;
    @Parameter(property="kotlin.compiler.jvmTarget", required=false, readonly=false)
    protected String jvmTarget;
    @Parameter(property="kotlin.compiler.jdkHome", required=false, readonly=false)
    protected String jdkHome;
    @Parameter(property="kotlin.compiler.scriptTemplates", required=false, readonly=false)
    protected List<String> scriptTemplates;
    @Parameter(property="kotlin.compiler.incremental", defaultValue="false", required=false, readonly=false)
    private boolean myIncremental;
    @Parameter(property="kotlin.compiler.incremental.cache.root", defaultValue="${project.build.directory}/kotlin-ic", required=false, readonly=false)
    public String incrementalCachesRoot;
    @Parameter(property="kotlin.compiler.javaParameters", required=false, readonly=false)
    protected boolean javaParameters;

    @NotNull
    private File getCachesDir() {
        return new File(this.incrementalCachesRoot, this.getSourceSetName());
    }

    protected boolean isIncremental() {
        return this.myIncremental;
    }

    private boolean isIncrementalSystemProperty() {
        String value = System.getProperty("kotlin.incremental");
        return value != null && value.equals("true");
    }

    @Override
    protected List<String> getRelatedSourceRoots(MavenProject project) {
        return project.getCompileSourceRoots();
    }

    @NotNull
    protected K2JVMCompiler createCompiler() {
        return new K2JVMCompiler();
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    protected List<String> getSourceFilePaths() {
        List<String> paths = super.getSourceFilePaths();
        File sourcesDir = AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, this.getSourceSetName());
        if (sourcesDir.isDirectory()) {
            paths = new ArrayList<String>(paths);
            paths.add(sourcesDir.getAbsolutePath());
        }
        return paths;
    }

    @NotNull
    protected String getSourceSetName() {
        return "compile";
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments) throws MojoExecutionException {
        List<String> classpathList;
        arguments.destination = this.output;
        arguments.noStdlib = true;
        arguments.javaParameters = this.javaParameters;
        if (this.module != null || this.testModule != null) {
            this.getLog().warn((CharSequence)"Parameters module and testModule are deprecated and ignored, they will be removed in further release.");
        }
        if (!(classpathList = Util.filterClassPath(this.project.getBasedir(), this.classpath)).isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            this.getLog().debug((CharSequence)("Classpath: " + classPathString));
            arguments.classpath = classPathString;
        }
        this.getLog().debug((CharSequence)("Classes directory is " + this.output));
        arguments.destination = this.output;
        arguments.moduleName = this.moduleName;
        this.getLog().info((CharSequence)("Module name is " + this.moduleName));
        if (arguments.noOptimize) {
            this.getLog().info((CharSequence)"Optimization is turned off");
        }
        arguments.jvmTarget = this.jvmTarget;
        if (this.jdkHome != null) {
            this.getLog().info((CharSequence)("Overriding JDK home path with: " + this.jdkHome));
            arguments.jdkHome = this.jdkHome;
        }
        if (this.scriptTemplates != null && !this.scriptTemplates.isEmpty()) {
            arguments.scriptTemplates = this.scriptTemplates.toArray(new String[0]);
        }
    }

    @Override
    protected ExitCode execCompiler(CLICompiler<K2JVMCompilerArguments> compiler, MessageCollector messageCollector, K2JVMCompilerArguments arguments, List<File> sourceRoots) throws MojoExecutionException {
        if (this.isIncremental()) {
            return this.runIncrementalCompiler(messageCollector, arguments, sourceRoots);
        }
        return super.execCompiler(compiler, messageCollector, arguments, sourceRoots);
    }

    @NotNull
    private ExitCode runIncrementalCompiler(MessageCollector messageCollector, K2JVMCompilerArguments arguments, List<File> sourceRoots) throws MojoExecutionException {
        this.getLog().warn((CharSequence)"Using experimental Kotlin incremental compilation");
        File cachesDir = this.getCachesDir();
        cachesDir.mkdirs();
        MavenICReporter icReporter = MavenICReporter.get(this.getLog());
        try {
            IncrementalJvmCompilerRunnerKt.makeIncrementally((File)cachesDir, sourceRoots, (K2JVMCompilerArguments)arguments, (MessageCollector)messageCollector, (ICReporter)icReporter);
            int compiledKtFilesCount = icReporter.getCompiledKotlinFiles().size();
            this.getLog().info((CharSequence)("Compiled " + icReporter.getCompiledKotlinFiles().size() + " Kotlin files using incremental compiler"));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return ExitCode.INTERNAL_ERROR;
        }
        if (messageCollector.hasErrors()) {
            return ExitCode.COMPILATION_ERROR;
        }
        return ExitCode.OK;
    }
}

