/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.maven.K2JVMCompileMojo;

@Mojo(name="test-compile", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresDependencyResolution=ResolutionScope.TEST)
public class KotlinTestCompileMojo
extends K2JVMCompileMojo {
    @Parameter(property="maven.test.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", required=true)
    private List<String> defaultSourceDirs;
    @Parameter
    private List<String> sourceDirs;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", required=true, readonly=true)
    private List<String> defaultSourceDir;

    @Override
    public List<String> getSourceFilePaths() {
        if (this.sourceDirs != null && !this.sourceDirs.isEmpty()) {
            return this.sourceDirs;
        }
        return this.defaultSourceDirs;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Test compilation is skipped");
        } else {
            super.execute();
        }
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments) throws MojoExecutionException {
        this.module = this.testModule;
        this.classpath = this.testClasspath;
        arguments.friendPaths = new String[]{this.output};
        this.output = this.testOutput;
        super.configureSpecificCompilerArguments(arguments);
    }

    @Override
    protected List<String> getRelatedSourceRoots(MavenProject project) {
        return project.getTestCompileSourceRoots();
    }
}

