/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.maven.Util;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class K2JVMCompileMojo
extends KotlinCompileMojoBase<K2JVMCompilerArguments> {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String moduleName;
    @Parameter(defaultValue="${project.artifactId}-test", required=true, readonly=true)
    protected String testModuleName;
    @Parameter(property="kotlin.compiler.jvmTarget", required=false, readonly=false)
    protected String jvmTarget;
    @Parameter(property="kotlin.compiler.jdkHome", required=false, readonly=false)
    protected String jdkHome;
    @Parameter(property="kotlin.compiler.scriptTemplates", required=false, readonly=false)
    protected List<String> scriptTemplates;

    @Override
    protected List<String> getRelatedSourceRoots(MavenProject project) {
        return project.getCompileSourceRoots();
    }

    @NotNull
    protected K2JVMCompiler createCompiler() {
        return new K2JVMCompiler();
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments) throws MojoExecutionException {
        List<String> classpathList;
        arguments.destination = this.output;
        arguments.noStdlib = true;
        if (this.module != null) {
            this.getLog().info((CharSequence)("Compiling Kotlin module " + this.module));
            arguments.module = this.module;
        }
        if (!(classpathList = Util.filterClassPath(this.project.getBasedir(), this.classpath)).isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            this.getLog().debug((CharSequence)("Classpath: " + classPathString));
            arguments.classpath = classPathString;
        }
        this.getLog().debug((CharSequence)("Classes directory is " + this.output));
        arguments.destination = this.output;
        arguments.moduleName = this.moduleName;
        this.getLog().info((CharSequence)("Module name is " + this.moduleName));
        if (arguments.noOptimize) {
            this.getLog().info((CharSequence)"Optimization is turned off");
        }
        arguments.jvmTarget = this.jvmTarget;
        if (this.jdkHome != null) {
            this.getLog().info((CharSequence)("Overriding JDK home path with: " + this.jdkHome));
            arguments.jdkHome = this.jdkHome;
        }
        if (this.scriptTemplates != null && !this.scriptTemplates.isEmpty()) {
            arguments.scriptTemplates = this.scriptTemplates.toArray(new String[0]);
        }
    }
}

