/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.google.common.base.Joiner;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.maven.KotlinMavenPluginExtension;
import org.jetbrains.kotlin.maven.MavenPluginLogMessageCollector;
import org.jetbrains.kotlin.maven.PluginOption;

public abstract class KotlinCompileMojoBase<A extends CommonCompilerArguments>
extends AbstractMojo {
    @Component
    protected PlexusContainer container;
    @Component
    protected MojoExecution mojoExecution;
    @Component
    protected RepositorySystem system;
    @Parameter
    private List<String> sourceDirs;
    @Parameter
    private List<String> compilerPlugins;
    @Parameter
    private List<String> pluginOptions;
    @Parameter(defaultValue="false")
    public boolean nowarn;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    public String output;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    public String testOutput;
    @Parameter
    public String module;
    @Parameter
    public String testModule;
    @Parameter
    public List<String> args;
    private static final Pattern OPTION_PATTERN = Pattern.compile("([^:]+):([^=]+)=(.*)");

    private List<String> getAppliedCompilerPlugins() {
        return this.compilerPlugins == null ? Collections.emptyList() : this.compilerPlugins;
    }

    protected List<String> getSourceFilePaths() {
        if (this.sourceDirs != null && !this.sourceDirs.isEmpty()) {
            return this.sourceDirs;
        }
        return this.project.getCompileSourceRoots();
    }

    public List<File> getSourceDirs() {
        List<String> sources = this.getSourceFilePaths();
        ArrayList<File> result = new ArrayList<File>(sources.size());
        File baseDir = this.project.getBasedir();
        for (String source : sources) {
            File f = new File(source);
            if (f.isAbsolute()) {
                result.add(f);
                continue;
            }
            result.add(new File(baseDir, source));
        }
        return result;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Kotlin Compiler version 1.0.7-release-1");
        if (!this.hasKotlinFilesInSources()) {
            this.getLog().warn((CharSequence)"No sources found skipping Kotlin compile");
            return;
        }
        A arguments = this.createCompilerArguments();
        CLICompiler<A> compiler = this.createCompiler();
        this.configureCompilerArguments(arguments, compiler);
        this.printCompilerArgumentsIfDebugEnabled(arguments, compiler);
        MavenPluginLogMessageCollector messageCollector = new MavenPluginLogMessageCollector(this.getLog());
        ExitCode exitCode = compiler.exec((MessageCollector)messageCollector, Services.EMPTY, arguments);
        if (exitCode != ExitCode.OK) {
            messageCollector.throwKotlinCompilerException();
        }
    }

    private boolean hasKotlinFilesInSources() throws MojoExecutionException {
        List<File> sources = this.getSourceDirs();
        if (sources == null || sources.isEmpty()) {
            return false;
        }
        for (File root : sources) {
            boolean sourcesExists;
            if (!root.exists() || !(sourcesExists = !FileUtil.processFilesRecursively((File)root, (Processor)new Processor<File>(){

                public boolean process(File file) {
                    return !file.getName().endsWith(".kt");
                }
            }))) continue;
            return true;
        }
        return false;
    }

    private void printCompilerArgumentsIfDebugEnabled(@NotNull A arguments, @NotNull CLICompiler<A> compiler) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Invoking compiler " + compiler + " with arguments:"));
            try {
                Field[] fields;
                for (Field f : fields = arguments.getClass().getFields()) {
                    Object value = f.get(arguments);
                    String valueString = value instanceof Object[] ? Arrays.deepToString((Object[])value) : (value != null ? String.valueOf(value) : "(null)");
                    this.getLog().debug((CharSequence)(f.getName() + "=" + valueString));
                }
                this.getLog().debug((CharSequence)"End of arguments");
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to print compiler arguments: " + e), (Throwable)e);
            }
        }
    }

    @NotNull
    protected abstract CLICompiler<A> createCompiler();

    @NotNull
    protected abstract A createCompilerArguments();

    protected abstract void configureSpecificCompilerArguments(@NotNull A var1) throws MojoExecutionException;

    private List<String> getCompilerPluginClassPaths() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<File> files = new ArrayList<File>();
        for (Dependency dependency : this.mojoExecution.getPlugin().getDependencies()) {
            Artifact artifact = this.system.createDependencyArtifact(dependency);
            ArtifactResolutionResult resolved = this.system.resolve(new ArtifactResolutionRequest().setArtifact(artifact));
            for (Artifact resolvedArtifact : resolved.getArtifacts()) {
                File file = resolvedArtifact.getFile();
                if (file == null || !file.exists()) continue;
                files.add(file);
            }
        }
        for (File file : files) {
            result.add(file.getAbsolutePath());
        }
        return result;
    }

    @NotNull
    private Map<String, KotlinMavenPluginExtension> loadCompilerPlugins() throws PluginNotFoundException {
        HashMap<String, KotlinMavenPluginExtension> loadedPlugins = new HashMap<String, KotlinMavenPluginExtension>();
        for (String pluginName : this.getAppliedCompilerPlugins()) {
            this.getLog().debug((CharSequence)("Looking for plugin " + pluginName));
            try {
                KotlinMavenPluginExtension extension = (KotlinMavenPluginExtension)this.container.lookup(KotlinMavenPluginExtension.class, pluginName);
                loadedPlugins.put(pluginName, extension);
                this.getLog().debug((CharSequence)("Got plugin instance" + pluginName + " of type " + extension.getClass().getName()));
            }
            catch (ComponentLookupException e) {
                this.getLog().debug((CharSequence)("Unable to get plugin instance" + pluginName));
                throw new PluginNotFoundException(pluginName, e);
            }
        }
        return loadedPlugins;
    }

    @NotNull
    private List<String> renderCompilerPluginOptions(@NotNull List<PluginOption> options) {
        ArrayList<String> renderedOptions = new ArrayList<String>(options.size());
        for (PluginOption option : options) {
            renderedOptions.add(option.toString());
        }
        return renderedOptions;
    }

    @NotNull
    private List<PluginOption> getCompilerPluginOptions() throws PluginNotFoundException, PluginOptionIllegalFormatException {
        if (this.mojoExecution == null) {
            throw new IllegalStateException("No mojoExecution injected");
        }
        ArrayList<PluginOption> pluginOptions = new ArrayList<PluginOption>();
        Map<String, KotlinMavenPluginExtension> plugins = this.loadCompilerPlugins();
        for (Map.Entry<String, KotlinMavenPluginExtension> pluginEntry : plugins.entrySet()) {
            String pluginName = pluginEntry.getKey();
            KotlinMavenPluginExtension plugin = pluginEntry.getValue();
            if (!plugin.isApplicable(this.project, this.mojoExecution)) continue;
            List<PluginOption> optionsForPlugin = plugin.getPluginOptions(this.project, this.mojoExecution);
            this.getLog().info((CharSequence)("Options for plugin " + pluginName + ": " + optionsForPlugin));
            pluginOptions.addAll(optionsForPlugin);
        }
        if (this.pluginOptions != null) {
            pluginOptions.addAll(KotlinCompileMojoBase.parseUserProvidedPluginOptions(this.pluginOptions, plugins));
        }
        return pluginOptions;
    }

    @NotNull
    private static List<PluginOption> parseUserProvidedPluginOptions(@NotNull List<String> rawOptions, @NotNull Map<String, KotlinMavenPluginExtension> plugins) throws PluginOptionIllegalFormatException, PluginNotFoundException {
        ArrayList<PluginOption> pluginOptions = new ArrayList<PluginOption>(rawOptions.size());
        for (String rawOption : rawOptions) {
            Matcher matcher = OPTION_PATTERN.matcher(rawOption);
            if (!matcher.matches()) {
                throw new PluginOptionIllegalFormatException(rawOption);
            }
            String pluginName = matcher.group(1);
            String key = matcher.group(2);
            String value = matcher.group(3);
            KotlinMavenPluginExtension plugin = plugins.get(pluginName);
            if (plugin == null) {
                throw new PluginNotFoundException(pluginName);
            }
            pluginOptions.add(new PluginOption(plugin.getCompilerPluginId(), key, value));
        }
        return pluginOptions;
    }

    private void configureCompilerArguments(@NotNull A arguments, @NotNull CLICompiler<A> compiler) throws MojoExecutionException {
        List<String> pluginArguments;
        List<String> pluginClassPaths;
        if (this.getLog().isDebugEnabled()) {
            ((CommonCompilerArguments)arguments).verbose = true;
        }
        ArrayList<String> sources = new ArrayList<String>();
        for (File source : this.getSourceDirs()) {
            if (source.exists()) {
                sources.add(source.getPath());
                continue;
            }
            this.getLog().warn((CharSequence)("Source root doesn't exist: " + source));
        }
        if (sources.isEmpty()) {
            throw new MojoExecutionException("No source roots to compile");
        }
        ((CommonCompilerArguments)arguments).suppressWarnings = this.nowarn;
        this.getLog().info((CharSequence)("Compiling Kotlin sources from " + sources));
        this.configureSpecificCompilerArguments(arguments);
        try {
            compiler.parseArguments(ArrayUtil.toStringArray(this.args), arguments);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        ((CommonCompilerArguments)arguments).freeArgs.addAll(sources);
        if (((CommonCompilerArguments)arguments).noInline) {
            this.getLog().info((CharSequence)"Method inlining is turned off");
        }
        if ((pluginClassPaths = this.getCompilerPluginClassPaths()) != null && !pluginClassPaths.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Plugin classpaths are: " + Joiner.on((String)", ").join(pluginClassPaths)));
            }
            ((CommonCompilerArguments)arguments).pluginClasspaths = pluginClassPaths.toArray(new String[pluginClassPaths.size()]);
        }
        try {
            pluginArguments = this.renderCompilerPluginOptions(this.getCompilerPluginOptions());
        }
        catch (PluginNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (PluginOptionIllegalFormatException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (!pluginArguments.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Plugin options are: " + Joiner.on((String)", ").join(pluginArguments)));
            }
            ((CommonCompilerArguments)arguments).pluginOptions = pluginArguments.toArray(new String[pluginArguments.size()]);
        }
    }

    public static class PluginOptionIllegalFormatException
    extends Exception {
        PluginOptionIllegalFormatException(String option) {
            super("Plugin option has an illegal format: " + option);
        }
    }

    public static class PluginNotFoundException
    extends Exception {
        PluginNotFoundException(String pluginId, Throwable cause) {
            super("Plugin not found: " + pluginId, cause);
        }

        PluginNotFoundException(String pluginId) {
            super("Plugin not found: " + pluginId);
        }
    }
}

