/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.sampullara.cli.Args;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class K2JVMCompileMojo
extends KotlinCompileMojoBase<K2JVMCompilerArguments> {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String moduleName;
    @Parameter(defaultValue="${project.artifactId}-test", required=true, readonly=true)
    protected String testModuleName;

    @NotNull
    protected K2JVMCompiler createCompiler() {
        return new K2JVMCompiler();
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments) throws MojoExecutionException {
        List<String> classpathList;
        arguments.destination = this.output;
        arguments.noStdlib = true;
        if (this.module != null) {
            this.getLog().info((CharSequence)("Compiling Kotlin module " + this.module));
            arguments.module = this.module;
        }
        if (!(classpathList = this.filterClassPath(this.classpath)).isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            this.getLog().info((CharSequence)("Classpath: " + classPathString));
            arguments.classpath = classPathString;
        }
        this.getLog().info((CharSequence)("Classes directory is " + this.output));
        arguments.destination = this.output;
        arguments.moduleName = this.moduleName;
        this.getLog().info((CharSequence)("Module name is " + this.moduleName));
        try {
            Args.parse((Object)arguments, (String[])ArrayUtil.toStringArray((Collection)this.args));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (arguments.noOptimize) {
            this.getLog().info((CharSequence)"Optimization is turned off");
        }
    }

    protected List<String> filterClassPath(List<String> classpath) {
        return CollectionsKt.filter(classpath, (Function1)new Function1<String, Boolean>(){

            public Boolean invoke(String s) {
                return new File(s).exists() || new File(K2JVMCompileMojo.this.project.getBasedir(), s).exists();
            }
        });
    }
}

