/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.jet.cli.js.K2JSCompiler;
import org.jetbrains.k2js.config.MetaInfServices;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;

public class K2JSCompilerMojo
extends KotlinCompileMojoBase<K2JSCompilerArguments> {
    public static final String KOTLIN_JS_MAPS = "kotlin-maps.js";
    public static final String KOTLIN_JS_LONG = "kotlin-long.js";
    public static final String KOTLIN_JS_LIB = "kotlin-lib.js";
    public static final String KOTLIN_JS_LIB_ECMA5 = "kotlin-lib-ecma5.js";
    private String outputFile;
    private File outputKotlinJSDir;
    private Boolean copyLibraryJS;
    private Boolean appendLibraryJS;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.appendLibraryJS != null && this.appendLibraryJS.booleanValue()) {
            try {
                Charset charset = Charset.defaultCharset();
                File file = new File(this.outputFile);
                String text = Files.toString((File)file, (Charset)charset);
                StringBuilder builder = new StringBuilder();
                this.appendFile(KOTLIN_JS_LIB_ECMA5, builder);
                this.appendFile(KOTLIN_JS_LIB, builder);
                this.appendFile(KOTLIN_JS_MAPS, builder);
                this.appendFile(KOTLIN_JS_LONG, builder);
                builder.append("\n");
                builder.append(text);
                Files.write((CharSequence)builder.toString(), (File)file, (Charset)charset);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.copyLibraryJS != null && this.copyLibraryJS.booleanValue()) {
            this.LOG.info((CharSequence)("Copying kotlin JS library to " + this.outputKotlinJSDir));
            this.copyJsLibraryFile(KOTLIN_JS_MAPS);
            this.copyJsLibraryFile(KOTLIN_JS_LONG);
            this.copyJsLibraryFile(KOTLIN_JS_LIB);
            this.copyJsLibraryFile(KOTLIN_JS_LIB_ECMA5);
        }
    }

    private void appendFile(String jsLib, StringBuilder builder) throws MojoExecutionException {
        try {
            final InputStream inputStream = MetaInfServices.loadClasspathResource((String)jsLib);
            if (inputStream == null) {
                this.LOG.warn((CharSequence)("Could not find " + jsLib + " on the classpath!"));
            } else {
                InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return inputStream;
                    }
                };
                String text = "\n" + FileUtil.loadTextAndClose((InputStream)inputStream);
                builder.append(text);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void copyJsLibraryFile(String jsLib) throws MojoExecutionException {
        try {
            final InputStream inputStream = MetaInfServices.loadClasspathResource((String)jsLib);
            if (inputStream == null) {
                this.LOG.warn((CharSequence)("Could not find " + jsLib + " on the classpath!"));
            } else {
                if (!this.outputKotlinJSDir.exists() && !this.outputKotlinJSDir.mkdirs()) {
                    throw new MojoExecutionException("Could not create output directory '" + this.outputKotlinJSDir + "'.");
                }
                InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return inputStream;
                    }
                };
                Files.copy((InputSupplier)inputSupplier, (File)new File(this.outputKotlinJSDir, jsLib));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JSCompilerArguments arguments) throws MojoExecutionException {
        arguments.outputFile = this.outputFile;
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createCompilerArguments() {
        return new K2JSCompilerArguments();
    }

    @NotNull
    protected K2JSCompiler createCompiler() {
        return new K2JSCompiler();
    }
}

