/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jetbrains.jet.cli.common.CLICompiler;
import org.jetbrains.jet.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.jet.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.jet.cli.js.K2JSCompiler;
import org.jetbrains.k2js.config.MetaInfServices;
import org.jetbrains.kotlin.maven.KotlinCompileMojo;

public class K2JSCompilerMojo
extends KotlinCompileMojo {
    public static final String KOTLIN_JS_MAPS = "kotlin-maps.js";
    public static final String KOTLIN_JS_LIB = "kotlin-lib.js";
    public static final String KOTLIN_JS_LIB_ECMA3 = "kotlin-lib-ecma3.js";
    public static final String KOTLIN_JS_LIB_ECMA5 = "kotlin-lib-ecma5.js";
    private String outputFile;
    private File outputKotlinJSDir;
    private Boolean copyLibraryJS;
    private Boolean appendLibraryJS;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.appendLibraryJS != null && this.appendLibraryJS.booleanValue()) {
            try {
                Charset charset = Charset.defaultCharset();
                File file = new File(this.outputFile);
                String text = Files.toString((File)file, (Charset)charset);
                StringBuilder builder = new StringBuilder();
                K2JSCompilerMojo.appendFile(KOTLIN_JS_LIB_ECMA3, builder);
                K2JSCompilerMojo.appendFile(KOTLIN_JS_LIB, builder);
                K2JSCompilerMojo.appendFile(KOTLIN_JS_MAPS, builder);
                builder.append("\n");
                builder.append(text);
                Files.write((CharSequence)builder.toString(), (File)file, (Charset)charset);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.copyLibraryJS != null && this.copyLibraryJS.booleanValue()) {
            this.getLog().info((CharSequence)("Copying kotlin JS library to " + this.outputKotlinJSDir));
            this.copyJsLibraryFile(KOTLIN_JS_MAPS);
            this.copyJsLibraryFile(KOTLIN_JS_LIB);
            this.copyJsLibraryFile(KOTLIN_JS_LIB_ECMA3);
            this.copyJsLibraryFile(KOTLIN_JS_LIB_ECMA5);
        }
    }

    private static void appendFile(String jsLib, StringBuilder builder) throws MojoExecutionException {
        try {
            final InputStream inputStream = MetaInfServices.loadClasspathResource((String)jsLib);
            if (inputStream == null) {
                System.out.println("WARNING: Could not find " + jsLib + " on the classpath!");
            } else {
                InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return inputStream;
                    }
                };
                String text = "\n" + FileUtil.loadTextAndClose((InputStream)inputStream);
                builder.append(text);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void copyJsLibraryFile(String jsLib) throws MojoExecutionException {
        try {
            this.outputKotlinJSDir.mkdirs();
            final InputStream inputStream = MetaInfServices.loadClasspathResource((String)jsLib);
            if (inputStream == null) {
                System.out.println("WARNING: Could not find " + jsLib + " on the classpath!");
            } else {
                InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return inputStream;
                    }
                };
                Files.copy((InputSupplier)inputSupplier, (File)new File(this.outputKotlinJSDir, jsLib));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    @Override
    protected void configureCompilerArguments(CommonCompilerArguments arguments) throws MojoExecutionException {
        super.configureCompilerArguments(arguments);
        if (arguments instanceof K2JSCompilerArguments) {
            K2JSCompilerArguments k2jsArgs = (K2JSCompilerArguments)arguments;
            k2jsArgs.outputFile = this.outputFile;
            if (this.getLog().isDebugEnabled()) {
                k2jsArgs.verbose = true;
            }
            List<String> sources = this.getSources();
            k2jsArgs.freeArgs.addAll(sources);
            this.getLog().info((CharSequence)("Compiling Kotlin src from " + sources + " to JavaScript at: " + this.outputFile));
        }
    }

    @Override
    protected CommonCompilerArguments createCompilerArguments() {
        return new K2JSCompilerArguments();
    }

    @Override
    protected CLICompiler createCompiler() {
        return new K2JSCompiler();
    }
}

