/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class JSSourceJarMojo
extends AbstractMojo {
    private File librarySourceDir;
    private File definitionSourceDir;
    public File outputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PrintWriter writer;
        File metaInfFile;
        if (this.librarySourceDir != null) {
            if (!this.librarySourceDir.exists()) {
                this.getLog().warn((CharSequence)("Source directory does not exist: " + this.librarySourceDir));
            } else {
                try {
                    metaInfFile = new File(this.outputDir, "META-INF/services/org.jetbrains.kotlin.js.librarySource");
                    metaInfFile.getParentFile().mkdirs();
                    FileUtils.copyDirectoryStructure((File)this.librarySourceDir, (File)this.outputDir);
                    writer = new PrintWriter(new FileWriter(metaInfFile));
                    this.appendSourceFiles(writer, this.outputDir.getCanonicalPath(), this.outputDir);
                    writer.close();
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.definitionSourceDir != null) {
            if (!this.definitionSourceDir.exists()) {
                this.getLog().warn((CharSequence)("Definition directory does not exist: " + this.definitionSourceDir));
            } else {
                try {
                    metaInfFile = new File(this.outputDir, "META-INF/services/org.jetbrains.kotlin.js.libraryDefinitions");
                    metaInfFile.getParentFile().mkdirs();
                    FileUtils.copyDirectoryStructure((File)this.definitionSourceDir, (File)this.outputDir);
                    writer = new PrintWriter(new FileWriter(metaInfFile));
                    this.appendSourceFiles(writer, this.definitionSourceDir.getCanonicalPath(), this.definitionSourceDir);
                    writer.close();
                }
                catch (IOException e) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void appendSourceFiles(PrintWriter writer, String rootPath, File currentDir) throws IOException {
        File[] files = currentDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.appendSourceFiles(writer, rootPath, file);
                    continue;
                }
                String name = file.getName();
                if (!name.toLowerCase().endsWith(".kt")) continue;
                String fullPath = file.getCanonicalPath();
                if (fullPath.startsWith(rootPath)) {
                    String relativePath = fullPath.substring(rootPath.length());
                    if (relativePath.startsWith("/") || relativePath.startsWith(File.separator)) {
                        relativePath = relativePath.substring(1).replace(File.separatorChar, '/');
                    }
                    writer.println(relativePath);
                    continue;
                }
                this.getLog().warn((CharSequence)("Could not remove the root path " + rootPath + " from file: " + fullPath));
            }
        }
    }
}

