/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.google.common.base.Joiner;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.CLICompiler;
import org.jetbrains.jet.cli.common.CompilerArguments;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.jvm.K2JVMCompiler;
import org.jetbrains.jet.cli.jvm.K2JVMCompilerArguments;

public abstract class KotlinCompileMojoBase
extends AbstractMojo {
    private List<String> defaultSourceDirs;
    private List<String> sourceDirs;
    public List<String> annotationPaths;
    public MavenProject project;
    public boolean scanForAnnotations;
    public List<String> classpath;
    protected List<String> testClasspath;
    public String output;
    public String testOutput;
    public String module;
    public String testModule;

    public List<String> getSources() {
        if (this.sourceDirs != null && !this.sourceDirs.isEmpty()) {
            return this.sourceDirs;
        }
        return this.defaultSourceDirs;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Kotlin Compiler version 0.6.31");
        List<String> sources = this.getSources();
        if (sources != null && sources.size() > 0) {
            boolean sourcesExists = false;
            for (String source : sources) {
                if (!new File(source).exists()) continue;
                sourcesExists = true;
                break;
            }
            if (!sourcesExists) {
                this.getLog().warn((CharSequence)"No sources found skipping Kotlin compile");
                return;
            }
        }
        CompilerArguments arguments = this.createCompilerArguments();
        this.configureCompilerArguments(arguments);
        CLICompiler compiler = this.createCompiler();
        this.printCompilerArgumentsIfDebugEnabled(arguments, compiler);
        final Log log = this.getLog();
        MessageCollector messageCollector = new MessageCollector(){

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
                String path = location.getPath();
                String position = path == null ? "" : path + ": (" + location.getLine() + ", " + location.getColumn() + ") ";
                String text = position + message;
                if (CompilerMessageSeverity.VERBOSE.contains(severity)) {
                    log.debug((CharSequence)text);
                } else if (CompilerMessageSeverity.ERRORS.contains(severity)) {
                    log.error((CharSequence)text);
                } else if (severity == CompilerMessageSeverity.INFO) {
                    log.info((CharSequence)text);
                } else {
                    log.warn((CharSequence)text);
                }
            }
        };
        ExitCode exitCode = compiler.exec(messageCollector, arguments);
        switch (exitCode) {
            case COMPILATION_ERROR: {
                throw new MojoExecutionException("Compilation error. See log for more details");
            }
            case INTERNAL_ERROR: {
                throw new MojoExecutionException("Internal compiler error. See log for more details");
            }
        }
    }

    private void printCompilerArgumentsIfDebugEnabled(CompilerArguments arguments, CLICompiler compiler) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Invoking compiler " + compiler + " with arguments:"));
            try {
                Field[] fields;
                for (Field f : fields = arguments.getClass().getFields()) {
                    Object value = f.get(arguments);
                    String valueString = value instanceof Object[] ? Arrays.deepToString((Object[])value) : (value != null ? String.valueOf(value) : "(null)");
                    this.getLog().debug((CharSequence)(f.getName() + "=" + valueString));
                }
                this.getLog().debug((CharSequence)"End of arguments");
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to print compiler arguments: " + e), (Throwable)e);
            }
        }
    }

    protected CLICompiler createCompiler() {
        return new K2JVMCompiler();
    }

    protected CompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    protected abstract void configureCompilerArguments(CompilerArguments var1) throws MojoExecutionException;

    protected void configureBaseCompilerArguments(Log log, K2JVMCompilerArguments arguments, String module, List<String> sources, List<String> classpath, String output) throws MojoExecutionException {
        arguments.noStdlib = true;
        ArrayList<String> classpathList = new ArrayList<String>();
        if (module != null) {
            log.info((CharSequence)("Compiling Kotlin module " + module));
            arguments.setModule(module);
        } else {
            if (sources.size() <= 0) {
                throw new MojoExecutionException("No source roots to compile");
            }
            arguments.setSourceDirs(sources);
            log.info((CharSequence)("Compiling Kotlin sources from " + arguments.getSourceDirs()));
            classpathList.addAll(sources);
        }
        classpathList.addAll(classpath);
        if (classpathList.remove(output)) {
            log.debug((CharSequence)("Removed target directory from compiler classpath (" + output + ")"));
        }
        if (classpathList.size() > 0) {
            String classPathString = Joiner.on((String)File.pathSeparator).join(classpathList);
            log.info((CharSequence)("Classpath: " + classPathString));
            arguments.setClasspath(classPathString);
        }
        log.info((CharSequence)("Classes directory is " + output));
        arguments.setOutputDir(output);
        arguments.noJdkAnnotations = true;
        arguments.annotations = this.getFullAnnotationsPath(log, this.annotationPaths);
        log.info((CharSequence)("Using kotlin annotations from " + arguments.annotations));
    }

    protected String getFullAnnotationsPath(Log log, List<String> annotations) {
        String jdkAnnotation = this.getJdkAnnotations().getPath();
        ArrayList<String> list = new ArrayList<String>();
        list.add(jdkAnnotation);
        if (annotations != null) {
            for (String annotationPath : annotations) {
                if (new File(annotationPath).exists()) {
                    list.add(annotationPath);
                    continue;
                }
                log.info((CharSequence)("annotation path " + annotationPath + " does not exist"));
            }
        }
        if (this.scanForAnnotations) {
            for (String path : this.scanAnnotations(log)) {
                if (list.contains(path)) continue;
                list.add(path);
            }
        }
        return StringUtil.join(list, (String)File.pathSeparator);
    }

    protected File getJdkAnnotations() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new RuntimeException("Kotlin plugin`s classloader is not URLClassLoader");
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        for (URL url : urlClassLoader.getURLs()) {
            File file;
            String path = url.getPath();
            if (StringUtil.isEmpty((String)path) || !(file = new File(path)).getName().startsWith("kotlin-jdk-annotations")) continue;
            return file;
        }
        throw new RuntimeException("Could not get jdk annotations from Kotlin plugin`s classpath");
    }

    protected List<String> scanAnnotations(Log log) {
        ArrayList<String> annotations = new ArrayList<String>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            if (!this.containsAnnotations(file, log)) continue;
            log.info((CharSequence)("Discovered kotlin annotations in: " + file));
            try {
                annotations.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                log.warn((CharSequence)("Error extracting canonical path from: " + file), (Throwable)e);
            }
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsAnnotations(File file, Log log) {
        log.debug((CharSequence)("Scanning for kotlin annotations in " + file));
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith("/annotations.xml")) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("Error reading contents of jar: " + file), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.warn((CharSequence)("Error closing: " + zipFile), (Throwable)e);
                }
            }
        }
        return false;
    }
}

