/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.sampullara.cli.Args;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class K2JVMCompileMojo
extends KotlinCompileMojoBase<K2JVMCompilerArguments> {
    @Parameter
    public List<String> annotationPaths;
    @Parameter(defaultValue="true")
    public boolean scanForAnnotations;
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    public List<String> classpath;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    protected List<String> testClasspath;
    @Parameter(defaultValue="${project.artifactId}", required=true, readonly=true)
    protected String moduleName;
    @Parameter(defaultValue="${project.artifactId}-test", required=true, readonly=true)
    protected String testModuleName;

    @NotNull
    protected K2JVMCompiler createCompiler() {
        return new K2JVMCompiler();
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createCompilerArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments) throws MojoExecutionException {
        List<String> classpathList;
        arguments.destination = this.output;
        arguments.noStdlib = true;
        if (this.module != null) {
            this.getLog().info((CharSequence)("Compiling Kotlin module " + this.module));
            arguments.module = this.module;
        }
        if (!(classpathList = this.filterClassPath(this.classpath)).isEmpty()) {
            String classPathString = StringUtil.join(classpathList, (String)File.pathSeparator);
            this.getLog().info((CharSequence)("Classpath: " + classPathString));
            arguments.classpath = classPathString;
        }
        this.getLog().info((CharSequence)("Classes directory is " + this.output));
        arguments.destination = this.output;
        arguments.noJdkAnnotations = true;
        arguments.annotations = this.getFullAnnotationsPath(this.getLog(), this.annotationPaths);
        this.getLog().info((CharSequence)("Using kotlin annotations from " + arguments.annotations));
        arguments.moduleName = this.moduleName;
        this.getLog().info((CharSequence)("Module name is " + this.moduleName));
        try {
            Args.parse((Object)arguments, (String[])ArrayUtil.toStringArray((Collection)this.args));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (arguments.noOptimize) {
            this.getLog().info((CharSequence)"Optimization is turned off");
        }
    }

    protected List<String> filterClassPath(List<String> classpath) {
        return KotlinPackage.filter(classpath, (Function1)new Function1<String, Boolean>(){

            public Boolean invoke(String s) {
                return new File(s).exists() || new File(K2JVMCompileMojo.this.project.getBasedir(), s).exists();
            }
        });
    }

    protected String getFullAnnotationsPath(Log log, List<String> annotations) {
        String jdkAnnotation = K2JVMCompileMojo.getJdkAnnotations().getPath();
        ArrayList<String> list = new ArrayList<String>();
        list.add(jdkAnnotation);
        if (annotations != null) {
            for (String annotationPath : annotations) {
                if (new File(annotationPath).exists()) {
                    list.add(annotationPath);
                    continue;
                }
                log.info((CharSequence)("annotation path " + annotationPath + " does not exist"));
            }
        }
        if (this.scanForAnnotations) {
            for (String path : this.scanAnnotations(log)) {
                if (list.contains(path)) continue;
                list.add(path);
            }
        }
        return StringUtil.join(list, (String)File.pathSeparator);
    }

    @NotNull
    private static File getJdkAnnotations() {
        ClassLoader classLoader = KotlinCompileMojoBase.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new RuntimeException("Kotlin plugin`s class loader is not URLClassLoader");
        }
        for (URL url : ((URLClassLoader)classLoader).getURLs()) {
            File file;
            String path = url.getPath();
            if (StringUtil.isEmpty((String)path) || !(file = new File(path)).getName().startsWith("kotlin-jdk-annotations")) continue;
            return file;
        }
        throw new RuntimeException("Could not get jdk annotations from Kotlin plugin`s classpath");
    }

    private List<String> scanAnnotations(Log log) {
        ArrayList<String> annotations = new ArrayList<String>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            if (!file.isFile() || !K2JVMCompileMojo.containsAnnotations(file, log)) continue;
            log.info((CharSequence)("Discovered kotlin annotations in: " + file));
            try {
                annotations.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                log.warn((CharSequence)("Error extracting canonical path from: " + file), (Throwable)e);
            }
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsAnnotations(File file, Log log) {
        log.debug((CharSequence)("Scanning for kotlin annotations in " + file));
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith("/annotations.xml")) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("Error reading contents of jar: " + file), (Throwable)e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    log.warn((CharSequence)("Error closing: " + zipFile), (Throwable)e);
                }
            }
        }
        return false;
    }
}

