/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.KotlinPackage;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.utils.LibraryUtils;

@Mojo(name="js", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class K2JSCompilerMojo
extends KotlinCompileMojoBase<K2JSCompilerArguments> {
    private static final String OUTPUT_DIRECTORIES_COLLECTOR_PROPERTY_NAME = "outputDirectoriesCollector";
    private static final Lock lock = new ReentrantLock();
    @Parameter(defaultValue="${project.build.directory}/js/${project.artifactId}.js", required=true)
    private String outputFile;
    @Parameter(defaultValue="true")
    private boolean metaInfo;
    @Parameter(defaultValue="false")
    private boolean sourceMap;

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JSCompilerArguments arguments) throws MojoExecutionException {
        arguments.outputFile = this.outputFile;
        arguments.noStdlib = true;
        arguments.metaInfo = this.metaInfo;
        List<String> libraries = this.getKotlinJavascriptLibraryFiles();
        this.LOG.debug((CharSequence)("libraryFiles: " + libraries));
        arguments.libraryFiles = ArrayUtil.toStringArray(libraries);
        arguments.sourceMap = this.sourceMap;
        Set<String> collector = this.getOutputDirectoriesCollector();
        if (this.outputFile != null) {
            collector.add(new File(this.outputFile).getParent());
        }
        if (this.metaInfo) {
            String metaFile = KotlinPackage.substringBeforeLast((String)this.outputFile, (String)".js", (String)this.outputFile) + ".meta.js";
            collector.add(new File(metaFile).getParent());
        }
    }

    @NotNull
    private List<String> getKotlinJavascriptLibraryFiles() {
        ArrayList<String> libraries = new ArrayList<String>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifact.getScope().equals("compile")) continue;
            File file = artifact.getFile();
            if (LibraryUtils.isKotlinJavascriptLibrary((File)file)) {
                libraries.add(file.getAbsolutePath());
                continue;
            }
            this.LOG.warn((CharSequence)("artifact " + artifact + " is not a Kotlin Javascript Library"));
        }
        for (String file : this.getOutputDirectoriesCollector()) {
            if (new File(file).exists()) {
                libraries.add(file);
                continue;
            }
            this.LOG.warn((CharSequence)("JS output directory missing: " + file));
        }
        return libraries;
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createCompilerArguments() {
        return new K2JSCompilerArguments();
    }

    @NotNull
    protected K2JSCompiler createCompiler() {
        return new K2JSCompiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getOutputDirectoriesCollector() {
        lock.lock();
        try {
            ConcurrentSkipListSet<String> collector = (ConcurrentSkipListSet<String>)this.getPluginContext().get(OUTPUT_DIRECTORIES_COLLECTOR_PROPERTY_NAME);
            if (collector == null) {
                collector = new ConcurrentSkipListSet<String>();
                this.getPluginContext().put(OUTPUT_DIRECTORIES_COLLECTOR_PROPERTY_NAME, collector);
            }
            ConcurrentSkipListSet<String> concurrentSkipListSet = collector;
            return concurrentSkipListSet;
        }
        finally {
            lock.unlock();
        }
    }
}

