/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.util.ArrayUtil;
import com.sampullara.cli.Args;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.Services;

public abstract class KotlinCompileMojoBase<A extends CommonCompilerArguments>
extends AbstractMojo {
    @Parameter(defaultValue="${project.compileSourceRoots}", required=true)
    private List<String> defaultSourceDirs;
    @Parameter
    private List<String> sourceDirs;
    @Parameter(defaultValue="false")
    public boolean nowarn;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    public String output;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    public String testOutput;
    @Parameter
    public String module;
    @Parameter
    public String testModule;
    @Parameter
    public List<String> args;
    protected final Log LOG = this.getLog();

    public List<String> getSources() {
        if (this.sourceDirs != null && !this.sourceDirs.isEmpty()) {
            return this.sourceDirs;
        }
        return this.defaultSourceDirs;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.LOG.info((CharSequence)"Kotlin Compiler version 0.12.1218");
        List<String> sources = this.getSources();
        if (sources != null && sources.size() > 0) {
            boolean sourcesExists = false;
            for (String source : sources) {
                if (!new File(source).exists()) continue;
                sourcesExists = true;
                break;
            }
            if (!sourcesExists) {
                this.LOG.warn((CharSequence)"No sources found skipping Kotlin compile");
                return;
            }
        }
        A arguments = this.createCompilerArguments();
        this.configureCompilerArguments(arguments);
        CLICompiler<A> compiler = this.createCompiler();
        this.printCompilerArgumentsIfDebugEnabled(arguments, compiler);
        MessageCollector messageCollector = new MessageCollector(){

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
                String path = location.getPath();
                String position = path == null ? "" : path + ": (" + location.getLine() + ", " + location.getColumn() + ") ";
                String text = position + message;
                if (CompilerMessageSeverity.VERBOSE.contains(severity)) {
                    KotlinCompileMojoBase.this.LOG.debug((CharSequence)text);
                } else if (CompilerMessageSeverity.ERRORS.contains(severity)) {
                    KotlinCompileMojoBase.this.LOG.error((CharSequence)text);
                } else if (severity == CompilerMessageSeverity.INFO) {
                    KotlinCompileMojoBase.this.LOG.info((CharSequence)text);
                } else {
                    KotlinCompileMojoBase.this.LOG.warn((CharSequence)text);
                }
            }
        };
        ExitCode exitCode = this.executeCompiler(compiler, arguments, messageCollector);
        switch (exitCode) {
            case COMPILATION_ERROR: {
                throw new MojoExecutionException("Compilation error. See log for more details");
            }
            case INTERNAL_ERROR: {
                throw new MojoExecutionException("Internal compiler error. See log for more details");
            }
        }
    }

    private void printCompilerArgumentsIfDebugEnabled(@NotNull A arguments, @NotNull CLICompiler<A> compiler) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Invoking compiler " + compiler + " with arguments:"));
            try {
                Field[] fields;
                for (Field f : fields = arguments.getClass().getFields()) {
                    Object value = f.get(arguments);
                    String valueString = value instanceof Object[] ? Arrays.deepToString((Object[])value) : (value != null ? String.valueOf(value) : "(null)");
                    this.getLog().debug((CharSequence)(f.getName() + "=" + valueString));
                }
                this.getLog().debug((CharSequence)"End of arguments");
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to print compiler arguments: " + e), (Throwable)e);
            }
        }
    }

    @NotNull
    protected abstract CLICompiler<A> createCompiler();

    @NotNull
    protected abstract A createCompilerArguments();

    @NotNull
    protected ExitCode executeCompiler(@NotNull CLICompiler<A> compiler, @NotNull A arguments, @NotNull MessageCollector messageCollector) {
        return compiler.exec(messageCollector, Services.EMPTY, arguments);
    }

    protected abstract void configureSpecificCompilerArguments(@NotNull A var1) throws MojoExecutionException;

    private void configureCompilerArguments(@NotNull A arguments) throws MojoExecutionException {
        if (this.LOG.isDebugEnabled()) {
            ((CommonCompilerArguments)arguments).verbose = true;
        }
        ArrayList<String> sources = new ArrayList<String>();
        for (String source : this.getSources()) {
            if (new File(source).exists()) {
                sources.add(source);
                continue;
            }
            this.LOG.warn((CharSequence)("Source root doesn't exist: " + source));
        }
        if (sources == null || sources.isEmpty()) {
            throw new MojoExecutionException("No source roots to compile");
        }
        ((CommonCompilerArguments)arguments).suppressWarnings = this.nowarn;
        ((CommonCompilerArguments)arguments).freeArgs.addAll(sources);
        this.LOG.info((CharSequence)("Compiling Kotlin sources from " + sources));
        this.configureSpecificCompilerArguments(arguments);
        try {
            Args.parse(arguments, (String[])ArrayUtil.toStringArray(this.args));
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        if (((CommonCompilerArguments)arguments).noInline) {
            this.LOG.info((CharSequence)"Method inlining is turned off");
        }
    }
}

