/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.maven.KotlinCompileMojoBase;
import org.jetbrains.kotlin.utils.LibraryUtils;

public class K2JSCompilerMojo
extends KotlinCompileMojoBase<K2JSCompilerArguments> {
    private String outputFile;
    private String metaFile;

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JSCompilerArguments arguments) throws MojoExecutionException {
        arguments.outputFile = this.outputFile;
        arguments.noStdlib = true;
        arguments.metaInfo = this.metaFile;
        List<String> libraries = this.getKotlinJavascriptLibraryFiles();
        this.LOG.info((CharSequence)("libraryFiles: " + libraries));
        arguments.libraryFiles = libraries.toArray(new String[0]);
    }

    @NotNull
    private List<String> getKotlinJavascriptLibraryFiles() {
        ArrayList<String> libraries = new ArrayList<String>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if (!artifact.getScope().equals("compile")) continue;
            File file = artifact.getFile();
            if (LibraryUtils.isKotlinJavascriptLibrary((File)file)) {
                libraries.add(file.getAbsolutePath());
                continue;
            }
            this.LOG.warn((CharSequence)("artifact " + artifact + " is not a Kotlin Javascript Library"));
        }
        return libraries;
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createCompilerArguments() {
        return new K2JSCompilerArguments();
    }

    @NotNull
    protected K2JSCompiler createCompiler() {
        return new K2JSCompiler();
    }
}

