/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.lombok.processor;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.load.java.lazy.LazyJavaResolverContext;
import org.jetbrains.kotlin.load.java.lazy.descriptors.SyntheticJavaClassDescriptor;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt;
import org.jetbrains.kotlin.lombok.config.AccessLevelUtilsKt;
import org.jetbrains.kotlin.lombok.config.LombokAnnotations;
import org.jetbrains.kotlin.lombok.config.LombokConfig;
import org.jetbrains.kotlin.lombok.processor.Processor;
import org.jetbrains.kotlin.lombok.processor.SyntheticPartsBuilder;
import org.jetbrains.kotlin.lombok.utils.LombokNames;
import org.jetbrains.kotlin.lombok.utils.LombokValueParameter;
import org.jetbrains.kotlin.lombok.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J)\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020#*\u00020#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010$\u001a\u00020\u001f*\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/lombok/processor/BuilderProcessor;", "Lorg/jetbrains/kotlin/lombok/processor/Processor;", "config", "Lorg/jetbrains/kotlin/lombok/config/LombokConfig;", "(Lorg/jetbrains/kotlin/lombok/config/LombokConfig;)V", "singularForm", "", "getSingularForm", "(Ljava/lang/String;)Ljava/lang/String;", "contribute", "", "Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "partsBuilder", "Lorg/jetbrains/kotlin/lombok/processor/SyntheticPartsBuilder;", "(Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/lombok/processor/SyntheticPartsBuilder;)V", "contributeToAnnotatedClass", "builder", "Lorg/jetbrains/kotlin/lombok/config/LombokAnnotations$Builder;", "(Lorg/jetbrains/kotlin/load/java/lazy/LazyJavaResolverContext;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/lombok/config/LombokAnnotations$Builder;Lorg/jetbrains/kotlin/lombok/processor/SyntheticPartsBuilder;)V", "contributeToBuilderClass", "builderClass", "constructingClass", "createMethodsForSingularField", "singular", "Lorg/jetbrains/kotlin/lombok/config/LombokAnnotations$Singular;", "field", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "createSetterMethod", "parameterType", "Lorg/jetbrains/kotlin/types/KotlinType;", "index", "", "toMethodName", "Lorg/jetbrains/kotlin/name/Name;", "withProperNullability", "allowNull", "", "BuilderData", "Companion", "kotlin-lombok-compiler-plugin.k1"})
@SourceDebugExtension(value={"SMAP\nBuilderProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuilderProcessor.kt\norg/jetbrains/kotlin/lombok/processor/BuilderProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1#2:270\n*E\n"})
public final class BuilderProcessor
implements Processor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LombokConfig config;
    @NotNull
    private static final String BUILDER_DATA = "Lombok.BuilderData";
    @NotNull
    private static final String TO_BUILDER = "toBuilder";

    public BuilderProcessor(@NotNull LombokConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Override
    public void contribute(@NotNull LazyJavaResolverContext $context_receiver_0, @NotNull ClassDescriptor classDescriptor, @NotNull SyntheticPartsBuilder partsBuilder) {
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)partsBuilder, (String)"partsBuilder");
        if (classDescriptor instanceof SyntheticJavaClassDescriptor) {
            Object v = ((SyntheticJavaClassDescriptor)classDescriptor).getAttributes().get(BUILDER_DATA);
            BuilderData builderData = v instanceof BuilderData ? (BuilderData)v : null;
            if (builderData == null) {
                return;
            }
            BuilderData builderData2 = builderData;
            this.contributeToBuilderClass(classDescriptor, builderData2.getConstructingClass(), builderData2.getBuilder(), partsBuilder);
        } else {
            LombokAnnotations.Builder builder2 = (LombokAnnotations.Builder)LombokAnnotations.Builder.Companion.getIfAnnotated((Annotated)classDescriptor, this.config);
            if (builder2 == null) {
                return;
            }
            LombokAnnotations.Builder builder3 = builder2;
            this.contributeToAnnotatedClass($context_receiver_0, classDescriptor, builder3, partsBuilder);
        }
    }

    private final void contributeToAnnotatedClass(LazyJavaResolverContext $context_receiver_0, ClassDescriptor classDescriptor, LombokAnnotations.Builder builder2, SyntheticPartsBuilder partsBuilder) {
        String string = builder2.getBuilderClassName();
        String string2 = classDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        Name name = Name.identifier((String)StringsKt.replace$default((String)string, (String)"*", (String)string2, (boolean)false, (int)4, null));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        Name builderName = name;
        DescriptorVisibility visibility = AccessLevelUtilsKt.toDescriptorVisibility(builder2.getVisibility());
        SyntheticJavaClassDescriptor builderDescriptor = new SyntheticJavaClassDescriptor($context_receiver_0, builderName, classDescriptor, ClassKind.CLASS, Modality.FINAL, visibility, false, false, Annotations.Companion.getEMPTY(), CollectionsKt.emptyList(), (Collection)CollectionsKt.emptyList(), CollectionsKt.listOf((Object)$context_receiver_0.getComponents().getModule().getBuiltIns().getAnyType()), MapsKt.mapOf((Pair)TuplesKt.to((Object)BUILDER_DATA, (Object)new BuilderData(builder2, classDescriptor))));
        partsBuilder.addClass((ClassDescriptor)builderDescriptor);
        Name name2 = Name.identifier((String)builder2.getBuilderMethodName());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        SimpleFunctionDescriptor builderFunction = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createFunction$default(classDescriptor, name2, CollectionsKt.emptyList(), (KotlinType)builderDescriptor.getDefaultType(), null, Modality.FINAL, visibility, null, 8, null);
        partsBuilder.addStaticFunction(builderFunction);
        if (builder2.getRequiresToBuilder()) {
            Name name3 = Name.identifier((String)TO_BUILDER);
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            SimpleFunctionDescriptor toBuilderFunction = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createFunction$default(classDescriptor, name3, CollectionsKt.emptyList(), (KotlinType)builderDescriptor.getDefaultType(), null, Modality.FINAL, visibility, null, 72, null);
            partsBuilder.addMethod(toBuilderFunction);
        }
    }

    private final void contributeToBuilderClass(ClassDescriptor builderClass, ClassDescriptor constructingClass, LombokAnnotations.Builder builder2, SyntheticPartsBuilder partsBuilder) {
        List list = CollectionsKt.emptyList();
        DescriptorVisibility descriptorVisibility = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PACKAGE_VISIBILITY");
        ClassConstructorDescriptor constructor = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createJavaConstructor(builderClass, list, descriptorVisibility);
        partsBuilder.addConstructor(constructor);
        DescriptorVisibility visibility = AccessLevelUtilsKt.toDescriptorVisibility(builder2.getVisibility());
        Name name = Name.identifier((String)builder2.getBuildMethodName());
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        SimpleFunctionDescriptor buildFunction = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createFunction$default(builderClass, name, CollectionsKt.emptyList(), (KotlinType)constructingClass.getDefaultType(), null, null, visibility, null, 88, null);
        partsBuilder.addMethod(buildFunction);
        for (PropertyDescriptor field : org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.getJavaFields(constructingClass)) {
            this.createSetterMethod(builder2, field, builderClass, partsBuilder);
        }
    }

    private final void createSetterMethod(LombokAnnotations.Builder builder2, PropertyDescriptor field, ClassDescriptor builderClass, SyntheticPartsBuilder partsBuilder) {
        LombokAnnotations.Singular singular = (LombokAnnotations.Singular)LombokAnnotations.Singular.Companion.getOrNull((Annotated)field);
        if (singular != null) {
            LombokAnnotations.Singular singular2 = singular;
            boolean bl = false;
            this.createMethodsForSingularField(builder2, singular2, field, builderClass, partsBuilder);
            return;
        }
        Name name = field.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        Name fieldName = name;
        Name setterName = this.toMethodName(fieldName, builder2);
        KotlinType kotlinType = field.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        SimpleFunctionDescriptor setFunction = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createFunction$default(builderClass, setterName, CollectionsKt.listOf((Object)new LombokValueParameter(fieldName, kotlinType)), (KotlinType)builderClass.getDefaultType(), null, Modality.FINAL, AccessLevelUtilsKt.toDescriptorVisibility(builder2.getVisibility()), null, 72, null);
        partsBuilder.addMethod(setFunction);
    }

    private final void createMethodsForSingularField(LombokAnnotations.Builder builder2, LombokAnnotations.Singular singular, PropertyDescriptor field, ClassDescriptor builderClass, SyntheticPartsBuilder partsBuilder) {
        Object[] baseType;
        String string;
        block19: {
            block18: {
                String string2 = singular.getSingularName();
                if (string2 == null) {
                    String string3 = field.getName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
                    string2 = string = this.getSingularForm(string3);
                }
                if (string2 == null) break block18;
                String p0 = string;
                boolean bl = false;
                Name name = Name.identifier((String)p0);
                string = name;
                if (name != null) break block19;
            }
            return;
        }
        String nameInSingularForm = string;
        Object object = field.getType().getConstructor().getDeclarationDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
            return;
        }
        Object typeName = object;
        KotlinType addMultipleParameterType = null;
        List valueParameters = null;
        Object object2 = typeName;
        if (LombokNames.INSTANCE.getSUPPORTED_COLLECTIONS().contains(object2)) {
            KotlinType kotlinType = this.parameterType(field, 0);
            if (kotlinType == null) {
                return;
            }
            KotlinType parameterType = kotlinType;
            valueParameters = CollectionsKt.listOf((Object)new LombokValueParameter((Name)nameInSingularForm, parameterType));
            KotlinBuiltIns builtIns = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)field)).getBuiltIns();
            Object object3 = typeName;
            Object[] objectArray = LombokNames.INSTANCE.getSUPPORTED_GUAVA_COLLECTIONS().contains(object3) ? builtIns.getIterable().getDefaultType() : builtIns.getCollection().getDefaultType();
            Intrinsics.checkNotNull((Object)objectArray);
            baseType = objectArray;
            addMultipleParameterType = TypeSubstitutionKt.replace$default((KotlinType)this.withProperNullability((KotlinType)baseType, singular.getAllowNull()), (List)CollectionsKt.listOf((Object)new TypeProjectionImpl(parameterType)), null, null, (int)6, null);
        } else if (LombokNames.INSTANCE.getSUPPORTED_MAPS().contains(object2)) {
            KotlinType kotlinType = this.parameterType(field, 0);
            if (kotlinType == null) {
                return;
            }
            KotlinType keyType = kotlinType;
            KotlinType kotlinType2 = this.parameterType(field, 1);
            if (kotlinType2 == null) {
                return;
            }
            KotlinType valueType = kotlinType2;
            baseType = new LombokValueParameter[2];
            Name name = Name.identifier((String)"key");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            baseType[0] = new LombokValueParameter(name, keyType);
            Name name2 = Name.identifier((String)"value");
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            baseType[1] = new LombokValueParameter(name2, valueType);
            valueParameters = CollectionsKt.listOf((Object[])baseType);
            SimpleType simpleType = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)field)).getBuiltIns().getMap().getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
            baseType = new TypeProjectionImpl[]{new TypeProjectionImpl(keyType), new TypeProjectionImpl(valueType)};
            addMultipleParameterType = TypeSubstitutionKt.replace$default((KotlinType)this.withProperNullability((KotlinType)simpleType, singular.getAllowNull()), (List)CollectionsKt.listOf((Object[])baseType), null, null, (int)6, null);
        } else if (LombokNames.INSTANCE.getSUPPORTED_TABLES().contains(object2)) {
            KotlinType kotlinType = this.parameterType(field, 0);
            if (kotlinType == null) {
                return;
            }
            KotlinType rowKeyType = kotlinType;
            KotlinType kotlinType3 = this.parameterType(field, 1);
            if (kotlinType3 == null) {
                return;
            }
            KotlinType columnKeyType = kotlinType3;
            KotlinType kotlinType4 = this.parameterType(field, 2);
            if (kotlinType4 == null) {
                return;
            }
            KotlinType valueType = kotlinType4;
            ClassDescriptor classDescriptor = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)field)), (FqName)LombokNames.INSTANCE.getTABLE(), (LookupLocation)((LookupLocation)NoLookupLocation.FROM_SYNTHETIC_SCOPE));
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor tableDescriptor = classDescriptor;
            Object[] objectArray = new LombokValueParameter[3];
            Name name = Name.identifier((String)"rowKey");
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            objectArray[0] = new LombokValueParameter(name, rowKeyType);
            Name name3 = Name.identifier((String)"columnKey");
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            objectArray[1] = new LombokValueParameter(name3, columnKeyType);
            Name name4 = Name.identifier((String)"value");
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            objectArray[2] = new LombokValueParameter(name4, valueType);
            valueParameters = CollectionsKt.listOf((Object[])objectArray);
            SimpleType simpleType = tableDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
            objectArray = new TypeProjectionImpl[]{new TypeProjectionImpl(rowKeyType), new TypeProjectionImpl(columnKeyType), new TypeProjectionImpl(valueType)};
            addMultipleParameterType = TypeSubstitutionKt.replace$default((KotlinType)this.withProperNullability((KotlinType)simpleType, singular.getAllowNull()), (List)CollectionsKt.listOf((Object[])objectArray), null, null, (int)6, null);
        } else {
            return;
        }
        SimpleType simpleType = builderClass.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        SimpleType builderType = simpleType;
        DescriptorVisibility visibility = AccessLevelUtilsKt.toDescriptorVisibility(builder2.getVisibility());
        SimpleFunctionDescriptor addSingleFunction = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createFunction$default(builderClass, this.toMethodName((Name)nameInSingularForm, builder2), valueParameters, (KotlinType)builderType, null, Modality.FINAL, visibility, null, 72, null);
        partsBuilder.addMethod(addSingleFunction);
        Name name = field.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        Name name5 = this.toMethodName(name, builder2);
        Name name6 = field.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"getName(...)");
        SimpleFunctionDescriptor addMultipleFunction = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createFunction$default(builderClass, name5, CollectionsKt.listOf((Object)new LombokValueParameter(name6, addMultipleParameterType)), (KotlinType)builderType, null, Modality.FINAL, visibility, null, 72, null);
        partsBuilder.addMethod(addMultipleFunction);
        StringBuilder stringBuilder = new StringBuilder().append("clear");
        String string4 = field.getName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getIdentifier(...)");
        Name name7 = Name.identifier((String)stringBuilder.append(UtilsKt.capitalize(string4)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(...)");
        SimpleFunctionDescriptor clearFunction = org.jetbrains.kotlin.lombok.utils.DescriptorUtilsKt.createFunction$default(builderClass, name7, CollectionsKt.emptyList(), (KotlinType)builderType, null, Modality.FINAL, visibility, null, 72, null);
        partsBuilder.addMethod(clearFunction);
    }

    private final String getSingularForm(String $this$singularForm) {
        return StringUtil.unpluralize((String)$this$singularForm);
    }

    private final KotlinType parameterType(PropertyDescriptor $this$parameterType, int index) {
        Object object = $this$parameterType.getReturnType();
        if (object == null || (object = object.getArguments()) == null || (object = (TypeProjection)CollectionsKt.getOrNull((List)object, (int)index)) == null || (object = object.getType()) == null) {
            return null;
        }
        Object type = object;
        Annotations[] annotationsArray = new Annotations[]{type.getAnnotations(), TypeEnhancementKt.getENHANCED_NULLABILITY_ANNOTATIONS()};
        return TypeUtilsKt.replaceAnnotations((KotlinType)type, (Annotations)((Annotations)new CompositeAnnotations(annotationsArray)));
    }

    private final KotlinType withProperNullability(KotlinType $this$withProperNullability, boolean allowNull) {
        return allowNull ? TypeUtilsKt.makeNullable((KotlinType)$this$withProperNullability) : TypeUtilsKt.makeNotNullable((KotlinType)$this$withProperNullability);
    }

    private final Name toMethodName(Name $this$toMethodName, LombokAnnotations.Builder builder2) {
        Object object;
        String prefix = builder2.getSetterPrefix();
        CharSequence charSequence = prefix;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            object = $this$toMethodName;
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(prefix);
            String string = $this$toMethodName.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
            charSequence = Name.identifier((String)stringBuilder.append(UtilsKt.capitalize(string)).toString());
            Intrinsics.checkNotNull((Object)charSequence);
            object = charSequence;
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/lombok/processor/BuilderProcessor$BuilderData;", "", "builder", "Lorg/jetbrains/kotlin/lombok/config/LombokAnnotations$Builder;", "constructingClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "(Lorg/jetbrains/kotlin/lombok/config/LombokAnnotations$Builder;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)V", "getBuilder", "()Lorg/jetbrains/kotlin/lombok/config/LombokAnnotations$Builder;", "getConstructingClass", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "kotlin-lombok-compiler-plugin.k1"})
    private static final class BuilderData {
        @NotNull
        private final LombokAnnotations.Builder builder;
        @NotNull
        private final ClassDescriptor constructingClass;

        public BuilderData(@NotNull LombokAnnotations.Builder builder2, @NotNull ClassDescriptor constructingClass) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)constructingClass, (String)"constructingClass");
            this.builder = builder2;
            this.constructingClass = constructingClass;
        }

        @NotNull
        public final LombokAnnotations.Builder getBuilder() {
            return this.builder;
        }

        @NotNull
        public final ClassDescriptor getConstructingClass() {
            return this.constructingClass;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/lombok/processor/BuilderProcessor$Companion;", "", "()V", "BUILDER_DATA", "", "TO_BUILDER", "kotlin-lombok-compiler-plugin.k1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

