/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.CirClassOrTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirFlexibleType;
import org.jetbrains.kotlin.commonizer.cir.CirRegularTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.CirSimpleType;
import org.jetbrains.kotlin.commonizer.cir.CirStarTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeParameterType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.UtilsKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0007H\u0002\u001a\u0016\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0007H\u0002\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"renderTypeForUnsafeNumberAnnotation", "", "type", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "renderFlexibleType", "Lorg/jetbrains/kotlin/commonizer/cir/CirFlexibleType;", "renderSimpleType", "Lorg/jetbrains/kotlin/commonizer/cir/CirSimpleType;", "renderArguments", "arguments", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirTypeProjection;", "renderTypeArgument", "typeArgument", "renderVariance", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "renderNullable", "NULLABLE", "STAR_PROJECTION", "TYPE_PARAMETER_TYPE_PREFIX", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nCirTypeRendererForUnsafeNumberAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CirTypeRendererForUnsafeNumberAnnotation.kt\norg/jetbrains/kotlin/commonizer/core/CirTypeRendererForUnsafeNumberAnnotationKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n207#2:48\n294#2:50\n1#3:49\n*S KotlinDebug\n*F\n+ 1 CirTypeRendererForUnsafeNumberAnnotation.kt\norg/jetbrains/kotlin/commonizer/core/CirTypeRendererForUnsafeNumberAnnotationKt\n*L\n30#1:48\n42#1:50\n*E\n"})
public final class CirTypeRendererForUnsafeNumberAnnotationKt {
    @NotNull
    private static final String NULLABLE = "?";
    @NotNull
    private static final String STAR_PROJECTION = "*";
    @NotNull
    private static final String TYPE_PARAMETER_TYPE_PREFIX = "#";

    @NotNull
    public static final String renderTypeForUnsafeNumberAnnotation(@NotNull CirType type) {
        String string;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CirType cirType = type;
        if (cirType instanceof CirSimpleType) {
            string = CirTypeRendererForUnsafeNumberAnnotationKt.renderSimpleType((CirSimpleType)type);
        } else if (cirType instanceof CirFlexibleType) {
            string = CirTypeRendererForUnsafeNumberAnnotationKt.renderFlexibleType((CirFlexibleType)type);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String renderFlexibleType(CirFlexibleType type) {
        return CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeForUnsafeNumberAnnotation(type.getLowerBound()) + ".." + CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeForUnsafeNumberAnnotation(type.getUpperBound());
    }

    private static final String renderSimpleType(CirSimpleType type) {
        String string;
        CirSimpleType cirSimpleType = type;
        if (cirSimpleType instanceof CirTypeAliasType) {
            string = CirTypeRendererForUnsafeNumberAnnotationKt.renderSimpleType(UtilsKt.expandedType((CirClassOrTypeAliasType)type));
        } else if (cirSimpleType instanceof CirClassType) {
            string = ((CirClassType)type).getClassifierId().toQualifiedNameString() + CirTypeRendererForUnsafeNumberAnnotationKt.renderArguments(((CirClassType)type).getArguments()) + CirTypeRendererForUnsafeNumberAnnotationKt.renderNullable(type);
        } else if (cirSimpleType instanceof CirTypeParameterType) {
            string = "" + '#' + ((CirTypeParameterType)type).getIndex() + CirTypeRendererForUnsafeNumberAnnotationKt.renderNullable(type);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String renderArguments(List<? extends CirTypeProjection> arguments) {
        String string;
        String string2;
        Collection $this$ifNotEmpty$iv = arguments;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$renderArguments_u24lambda_u240 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            string2 = CollectionsKt.joinToString$default((Iterable)$this$renderArguments_u24lambda_u240, null, (CharSequence)"<", (CharSequence)">", (int)0, null, CirTypeRendererForUnsafeNumberAnnotationKt::renderArguments$lambda$0$0, (int)25, null);
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    private static final String renderTypeArgument(CirTypeProjection typeArgument) {
        String string;
        CirTypeProjection cirTypeProjection = typeArgument;
        if (cirTypeProjection instanceof CirRegularTypeProjection) {
            string = CirTypeRendererForUnsafeNumberAnnotationKt.renderVariance(((CirRegularTypeProjection)typeArgument).getProjectionKind()) + CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeForUnsafeNumberAnnotation(((CirRegularTypeProjection)typeArgument).getType());
        } else if (Intrinsics.areEqual((Object)cirTypeProjection, (Object)CirStarTypeProjection.INSTANCE)) {
            string = STAR_PROJECTION;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private static final String renderVariance(Variance variance) {
        String string;
        String it = string = "" + variance + ' ';
        boolean bl = false;
        String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final String renderNullable(CirSimpleType $this$renderNullable) {
        String string;
        String string2;
        boolean $this$ifTrue$iv = $this$renderNullable.isMarkedNullable();
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            string2 = NULLABLE;
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        return string;
    }

    private static final CharSequence renderArguments$lambda$0$0(CirTypeProjection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeArgument(it);
    }
}

