/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.library.loader;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.internal.library.KotlinAbiVersion;
import kotlin.metadata.internal.library.loader.KlibLoaderResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001aB\u0010\u0003\u001a\u00020\u0004*\u00020\u000526\u0010\u0006\u001a2\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0007\u00a8\u0006\u000e"}, d2={"computeMessageText", "", "Lkotlin/metadata/internal/library/loader/KlibLoaderResult$ProblematicLibrary;", "reportLoadingProblemsIfAny", "", "Lkotlin/metadata/internal/library/loader/KlibLoaderResult;", "reporter", "Lkotlin/Function2;", "Lkotlin/metadata/internal/library/loader/KlibLoaderResult$ProblemSeverity;", "Lkotlin/ParameterName;", "name", "defaultSeverity", "message", "", "kotlin-util-klib"})
@SourceDebugExtension(value={"SMAP\nKlibLoaderResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibLoaderResult.kt\norg/jetbrains/kotlin/library/loader/KlibLoaderResultKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1869#2,2:184\n1#3:186\n*S KotlinDebug\n*F\n+ 1 KlibLoaderResult.kt\norg/jetbrains/kotlin/library/loader/KlibLoaderResultKt\n*L\n125#1:184,2\n*E\n"})
public final class KlibLoaderResultKt {
    public static final boolean reportLoadingProblemsIfAny(@NotNull KlibLoaderResult $this$reportLoadingProblemsIfAny, @NotNull Function2<? super KlibLoaderResult.ProblemSeverity, ? super String, Unit> reporter) {
        Intrinsics.checkNotNullParameter((Object)$this$reportLoadingProblemsIfAny, (String)"<this>");
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        if ($this$reportLoadingProblemsIfAny.getProblematicLibraries().isEmpty()) {
            return false;
        }
        Iterable $this$forEach$iv = $this$reportLoadingProblemsIfAny.getProblematicLibraries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KlibLoaderResult.ProblematicLibrary problematicLibrary = (KlibLoaderResult.ProblematicLibrary)element$iv;
            boolean bl = false;
            reporter.invoke((Object)problematicLibrary.getProblemCase().getDefaultSeverity(), (Object)KlibLoaderResultKt.computeMessageText(problematicLibrary));
        }
        return true;
    }

    private static final String computeMessageText(KlibLoaderResult.ProblematicLibrary $this$computeMessageText) {
        String string;
        KlibLoaderResult.ProblemCase problemCase = $this$computeMessageText.getProblemCase();
        if (Intrinsics.areEqual((Object)problemCase, (Object)KlibLoaderResult.ProblemCase.LibraryNotFound.INSTANCE)) {
            string = "Library not found: " + $this$computeMessageText.getLibraryPath();
        } else if (Intrinsics.areEqual((Object)problemCase, (Object)KlibLoaderResult.ProblemCase.InvalidLibraryFormat.INSTANCE)) {
            string = "Not a Kotlin library, or a library with invalid format: " + $this$computeMessageText.getLibraryPath();
        } else if (problemCase instanceof KlibLoaderResult.ProblemCase.PlatformCheckMismatch) {
            KlibLoaderResult.ProblemCase.PlatformCheckMismatch $this$computeMessageText_u24lambda_u241 = (KlibLoaderResult.ProblemCase.PlatformCheckMismatch)problemCase;
            boolean bl = false;
            string = "Library failed platform-specific check: " + $this$computeMessageText.getLibraryPath() + "\nExpected " + $this$computeMessageText_u24lambda_u241.getProperty() + " is " + $this$computeMessageText_u24lambda_u241.getExpected() + " while found " + $this$computeMessageText_u24lambda_u241.getActual() + '.';
        } else if (problemCase instanceof KlibLoaderResult.ProblemCase.IncompatibleAbiVersion) {
            List list;
            Object[] objectArray;
            String string2;
            KlibLoaderResult.ProblemCase.IncompatibleAbiVersion $this$computeMessageText_u24lambda_u243 = (KlibLoaderResult.ProblemCase.IncompatibleAbiVersion)problemCase;
            boolean bl = false;
            String string3 = $this$computeMessageText_u24lambda_u243.getLibraryVersions().getCompilerVersion();
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                string2 = "The library was produced by " + it + " compiler.";
            } else {
                string2 = null;
            }
            String libraryCompilerLine = string2;
            String abiVersionCheckExplanation = $this$computeMessageText_u24lambda_u243.getMinPermittedAbiVersion() != null && $this$computeMessageText_u24lambda_u243.getMaxPermittedAbiVersion() != null ? "ABI version in the range [" + $this$computeMessageText_u24lambda_u243.getMinPermittedAbiVersion() + ", " + $this$computeMessageText_u24lambda_u243.getMaxPermittedAbiVersion() + ']' : ($this$computeMessageText_u24lambda_u243.getMaxPermittedAbiVersion() != null ? "ABI version <= " + $this$computeMessageText_u24lambda_u243.getMaxPermittedAbiVersion() : "ABI version >= " + $this$computeMessageText_u24lambda_u243.getMinPermittedAbiVersion());
            KotlinAbiVersion libraryAbiVersion = $this$computeMessageText_u24lambda_u243.getLibraryVersions().getAbiVersion();
            if (libraryAbiVersion != null) {
                objectArray = new String[]{"Incompatible ABI version " + libraryAbiVersion + " in library: " + $this$computeMessageText.getLibraryPath(), libraryCompilerLine, "The current Kotlin compiler can consume libraries having " + abiVersionCheckExplanation, "Please upgrade your Kotlin compiler version to consume this library."};
                list = CollectionsKt.listOfNotNull((Object[])objectArray);
            } else {
                objectArray = new String[]{"Library with unknown ABI version: " + $this$computeMessageText.getLibraryPath(), libraryCompilerLine, "The current Kotlin compiler can consume libraries having " + abiVersionCheckExplanation + ", but it's not possible to determine the exact ABI version."};
                list = CollectionsKt.listOfNotNull((Object[])objectArray);
            }
            List lines = list;
            string = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String messageText = string;
        return "KLIB loader: " + messageText;
    }
}

