/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.library.impl;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.metadata.internal.konan.file.File;
import kotlin.metadata.internal.library.KotlinLibraryLayout;
import kotlin.metadata.internal.library.impl.FromZipBaseLibraryImpl;
import kotlin.metadata.internal.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u0015"}, d2={"Lkotlin/metadata/internal/library/impl/KotlinLibraryLayoutImpl;", "Lkotlin/metadata/internal/library/KotlinLibraryLayout;", "klib", "Lkotlin/metadata/internal/konan/file/File;", "component", "", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "getComponent", "()Ljava/lang/String;", "isZipped", "", "()Z", "getKlib", "()Lorg/jetbrains/kotlin/konan/file/File;", "libFile", "getLibFile", "libraryName", "getLibraryName", "directlyFromZip", "zipFileSystem", "Ljava/nio/file/FileSystem;", "kotlin-util-klib"})
public class KotlinLibraryLayoutImpl
implements KotlinLibraryLayout {
    @NotNull
    private final File klib;
    @Nullable
    private final String component;
    private final boolean isZipped;
    @NotNull
    private final File libFile;

    public KotlinLibraryLayoutImpl(@NotNull File klib, @Nullable String component) {
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        this.klib = klib;
        this.component = component;
        this.isZipped = this.klib.isFile();
        this.libFile = this.isZipped ? new File("/") : this.klib;
    }

    @NotNull
    public final File getKlib() {
        return this.klib;
    }

    @Override
    @Nullable
    public String getComponent() {
        return this.component;
    }

    public final boolean isZipped() {
        return this.isZipped;
    }

    @Override
    @NotNull
    public File getLibFile() {
        return this.libFile;
    }

    @Override
    @NotNull
    public String getLibraryName() {
        return this.isZipped ? UtilKt.removeSuffixIfPresent(this.klib.getPath(), ".klib") : this.getLibFile().getPath();
    }

    @NotNull
    public KotlinLibraryLayout directlyFromZip(@NotNull FileSystem zipFileSystem) {
        Intrinsics.checkNotNullParameter((Object)zipFileSystem, (String)"zipFileSystem");
        return new FromZipBaseLibraryImpl(this, zipFileSystem);
    }
}

