/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.konan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerParameters;
import org.jetbrains.kotlin.commonizer.CommonizerSettings;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.FacadeKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.ModulesProvider;
import org.jetbrains.kotlin.commonizer.ResultsConsumer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.commonizer.TargetDependent;
import org.jetbrains.kotlin.commonizer.TargetDependentKt;
import org.jetbrains.kotlin.commonizer.TargetProvider;
import org.jetbrains.kotlin.commonizer.cli.CliLoggerAdapterKt;
import org.jetbrains.kotlin.commonizer.konan.DefaultModulesProvider;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrariesToCommonize;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.commonizer.konan.NativeLibraryKt;
import org.jetbrains.kotlin.commonizer.konan.NativeManifestDataProvider;
import org.jetbrains.kotlin.commonizer.repository.Repository;
import org.jetbrains.kotlin.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.commonizer.utils.ProgressLoggerKt;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BI\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0015H\u0002J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/commonizer/konan/LibraryCommonizer;", "", "outputTargets", "", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "repository", "Lorg/jetbrains/kotlin/commonizer/repository/Repository;", "dependencies", "resultsConsumer", "Lorg/jetbrains/kotlin/commonizer/ResultsConsumer;", "statsCollector", "Lorg/jetbrains/kotlin/commonizer/stats/StatsCollector;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "settings", "Lorg/jetbrains/kotlin/commonizer/CommonizerSettings;", "<init>", "(Ljava/util/Set;Lorg/jetbrains/kotlin/commonizer/repository/Repository;Lorg/jetbrains/kotlin/commonizer/repository/Repository;Lorg/jetbrains/kotlin/commonizer/ResultsConsumer;Lorg/jetbrains/kotlin/commonizer/stats/StatsCollector;Lorg/jetbrains/kotlin/util/Logger;Lorg/jetbrains/kotlin/commonizer/CommonizerSettings;)V", "run", "", "loadLibraries", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrariesToCommonize;", "commonizeAndSaveResults", "libraries", "createTargetProvider", "Lorg/jetbrains/kotlin/commonizer/TargetProvider;", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "createDependenciesProvider", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider;", "createManifestProvider", "Lorg/jetbrains/kotlin/commonizer/konan/NativeManifestDataProvider;", "checkPreconditions", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nLibraryCommonizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryCommonizer.kt\norg/jetbrains/kotlin/commonizer/konan/LibraryCommonizer\n+ 2 ProgressLogger.kt\norg/jetbrains/kotlin/commonizer/utils/ProgressLoggerKt\n+ 3 TargetDependent.kt\norg/jetbrains/kotlin/commonizer/TargetDependentKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n18#2,9:105\n18#2,2:114\n21#2,3:127\n25#2,2:138\n100#3:116\n84#3:123\n85#3:126\n84#3:134\n85#3:137\n1285#4,2:117\n1299#4,2:119\n1302#4:122\n1869#4,2:124\n1299#4,4:130\n1869#4,2:135\n1869#4,2:140\n1617#4,9:142\n1869#4:151\n1870#4:153\n1626#4:154\n195#5:121\n1#6:152\n*S KotlinDebug\n*F\n+ 1 LibraryCommonizer.kt\norg/jetbrains/kotlin/commonizer/konan/LibraryCommonizer\n*L\n27#1:105,9\n35#1:114,2\n35#1:127,3\n35#1:138,2\n36#1:116\n40#1:123\n40#1:126\n40#1:134\n40#1:137\n36#1:117,2\n36#1:119,2\n36#1:122\n40#1:124,2\n36#1:130,4\n40#1:135,2\n96#1:140,2\n89#1:142,9\n89#1:151\n89#1:153\n89#1:154\n37#1:121\n89#1:152\n*E\n"})
public final class LibraryCommonizer {
    @NotNull
    private final Set<SharedCommonizerTarget> outputTargets;
    @NotNull
    private final Repository repository;
    @NotNull
    private final Repository dependencies;
    @NotNull
    private final ResultsConsumer resultsConsumer;
    @Nullable
    private final StatsCollector statsCollector;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CommonizerSettings settings;

    public LibraryCommonizer(@NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull Repository repository, @NotNull Repository dependencies, @NotNull ResultsConsumer resultsConsumer, @Nullable StatsCollector statsCollector, @NotNull Logger logger, @NotNull CommonizerSettings settings) {
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)resultsConsumer, (String)"resultsConsumer");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.outputTargets = outputTargets;
        this.repository = repository;
        this.dependencies = dependencies;
        this.resultsConsumer = resultsConsumer;
        this.statsCollector = statsCollector;
        this.logger = logger;
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void run() {
        void $this$progress$iv;
        Logger logger = this.logger;
        String message$iv = "Commonized all targets";
        boolean $i$f$progress = false;
        if ($this$progress$iv == null) {
            boolean bl = false;
            this.checkPreconditions();
            TargetDependent<NativeLibrariesToCommonize> allLibraries = this.loadLibraries();
            this.commonizeAndSaveResults(allLibraries);
        } else {
            long timeMark$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            try {
                boolean bl = false;
                this.checkPreconditions();
                TargetDependent<NativeLibrariesToCommonize> allLibraries = this.loadLibraries();
                this.commonizeAndSaveResults(allLibraries);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                String duration$iv = ProgressLoggerKt.access$toPrettyString-LRDsOJo(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)timeMark$iv));
                $this$progress$iv.log(message$iv + " \u001b[36min " + duration$iv + "\u001b[0m");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final TargetDependent<NativeLibrariesToCommonize> loadLibraries() {
        TargetDependent<NativeLibrariesToCommonize> targetDependent;
        void $this$progress$iv;
        Logger logger = this.logger;
        String message$iv = "Resolved all libraries for commonization";
        boolean $i$f$progress = false;
        if ($this$progress$iv == null) {
            TargetDependent<NativeLibrariesToCommonize> libraries;
            void $this$associateWithTo$iv$iv$iv;
            boolean bl = false;
            Iterable keys$iv = CommonizerTargetKt.allLeaves((Iterable<? extends CommonizerTarget>)this.outputTargets);
            boolean $i$f$EagerTargetDependent = false;
            Iterable $this$associateWith$iv$iv = keys$iv;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv$iv;
            Map destination$iv$iv$iv = result$iv$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv$iv : $this$associateWithTo$iv$iv$iv) {
                NativeLibrariesToCommonize nativeLibrariesToCommonize;
                void target;
                CommonizerTarget commonizerTarget = (CommonizerTarget)element$iv$iv$iv;
                Object t = element$iv$iv$iv;
                Map map = destination$iv$iv$iv;
                boolean bl2 = false;
                Collection $this$ifNotEmpty$iv = CollectionsKt.toList((Iterable)this.repository.getLibraries((CommonizerTarget)target));
                boolean $i$f$ifNotEmpty = false;
                if (!$this$ifNotEmpty$iv.isEmpty()) {
                    List $this$loadLibraries_u24lambda_u244_u24lambda_u242_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
                    boolean bl3 = false;
                    nativeLibrariesToCommonize = new NativeLibrariesToCommonize((CommonizerTarget)target, $this$loadLibraries_u24lambda_u244_u24lambda_u242_u24lambda_u241);
                } else {
                    nativeLibrariesToCommonize = null;
                }
                NativeLibrariesToCommonize nativeLibrariesToCommonize2 = nativeLibrariesToCommonize;
                map.put(t, nativeLibrariesToCommonize2);
            }
            TargetDependent<NativeLibrariesToCommonize> $this$forEachWithTarget$iv = libraries = TargetDependentKt.toTargetDependent(destination$iv$iv$iv);
            boolean $i$f$forEachWithTarget = false;
            Iterable $this$forEach$iv$iv = $this$forEachWithTarget$iv.getTargets();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                void librariesOrNull;
                CommonizerTarget target$iv = (CommonizerTarget)element$iv$iv;
                boolean bl4 = false;
                NativeLibrariesToCommonize nativeLibrariesToCommonize = $this$forEachWithTarget$iv.get(target$iv);
                CommonizerTarget target = target$iv;
                boolean bl5 = false;
                if (librariesOrNull != null) continue;
                this.logger.warning("No libraries found for target " + target + ". This target will be excluded from commonization.");
            }
            targetDependent = libraries;
        } else {
            long timeMark$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            try {
                TargetDependent libraries;
                void $this$associateWithTo$iv$iv$iv;
                boolean bl = false;
                Iterable keys$iv = CommonizerTargetKt.allLeaves((Iterable<? extends CommonizerTarget>)this.outputTargets);
                boolean $i$f$EagerTargetDependent = false;
                Iterable $this$associateWith$iv$iv = keys$iv;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv$iv, (int)10)), (int)16));
                Iterable target$iv = $this$associateWith$iv$iv;
                Map destination$iv$iv$iv = result$iv$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv$iv : $this$associateWithTo$iv$iv$iv) {
                    NativeLibrariesToCommonize nativeLibrariesToCommonize;
                    void target;
                    CommonizerTarget commonizerTarget = (CommonizerTarget)element$iv$iv$iv;
                    Object t = element$iv$iv$iv;
                    Map map = destination$iv$iv$iv;
                    boolean bl6 = false;
                    Collection $this$ifNotEmpty$iv = CollectionsKt.toList((Iterable)this.repository.getLibraries((CommonizerTarget)target));
                    boolean $i$f$ifNotEmpty = false;
                    if (!$this$ifNotEmpty$iv.isEmpty()) {
                        List $this$loadLibraries_u24lambda_u244_u24lambda_u242_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
                        boolean bl7 = false;
                        nativeLibrariesToCommonize = new NativeLibrariesToCommonize((CommonizerTarget)target, $this$loadLibraries_u24lambda_u244_u24lambda_u242_u24lambda_u241);
                    } else {
                        nativeLibrariesToCommonize = null;
                    }
                    NativeLibrariesToCommonize nativeLibrariesToCommonize3 = nativeLibrariesToCommonize;
                    map.put(t, nativeLibrariesToCommonize3);
                }
                TargetDependent $this$forEachWithTarget$iv = libraries = TargetDependentKt.toTargetDependent(destination$iv$iv$iv);
                boolean $i$f$forEachWithTarget = false;
                Iterable $this$forEach$iv$iv = $this$forEachWithTarget$iv.getTargets();
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    void librariesOrNull;
                    CommonizerTarget target$iv2 = (CommonizerTarget)element$iv$iv;
                    boolean bl8 = false;
                    NativeLibrariesToCommonize target = (NativeLibrariesToCommonize)$this$forEachWithTarget$iv.get(target$iv2);
                    CommonizerTarget target2 = target$iv2;
                    boolean bl9 = false;
                    if (librariesOrNull != null) continue;
                    this.logger.warning("No libraries found for target " + target2 + ". This target will be excluded from commonization.");
                }
                TargetDependent targetDependent2 = libraries;
                targetDependent = targetDependent2;
            }
            finally {
                String duration$iv = ProgressLoggerKt.access$toPrettyString-LRDsOJo(TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)timeMark$iv));
                $this$progress$iv.log(message$iv + " \u001b[36min " + duration$iv + "\u001b[0m");
            }
        }
        return targetDependent;
    }

    private final void commonizeAndSaveResults(TargetDependent<NativeLibrariesToCommonize> libraries) {
        Set<SharedCommonizerTarget> set = this.outputTargets;
        TargetDependent targetDependent = libraries.map((arg_0, arg_1) -> LibraryCommonizer.commonizeAndSaveResults$lambda$5(this, arg_0, arg_1));
        TargetDependent<NativeManifestDataProvider> targetDependent2 = this.createManifestProvider(libraries);
        TargetDependent<ModulesProvider> targetDependent3 = this.createDependenciesProvider();
        ResultsConsumer resultsConsumer = this.resultsConsumer;
        StatsCollector statsCollector = this.statsCollector;
        Logger logger = this.logger;
        CommonizerSettings commonizerSettings = this.settings;
        FacadeKt.runCommonization(new CommonizerParameters(set, targetDependent2, targetDependent3, targetDependent, resultsConsumer, null, statsCollector, logger, commonizerSettings, 32, null));
    }

    private final TargetProvider createTargetProvider(CommonizerTarget target, NativeLibrariesToCommonize libraries) {
        if (libraries == null) {
            return null;
        }
        return new TargetProvider(target, DefaultModulesProvider.Companion.create(libraries));
    }

    private final TargetDependent<ModulesProvider> createDependenciesProvider() {
        return TargetDependentKt.TargetDependent(SetsKt.plus(this.outputTargets, (Iterable)CommonizerTargetKt.allLeaves((Iterable<? extends CommonizerTarget>)this.outputTargets)), arg_0 -> LibraryCommonizer.createDependenciesProvider$lambda$6(this, arg_0));
    }

    private final TargetDependent<NativeManifestDataProvider> createManifestProvider(TargetDependent<NativeLibrariesToCommonize> libraries) {
        return TargetDependentKt.TargetDependent((Iterable<? extends CommonizerTarget>)this.outputTargets, arg_0 -> LibraryCommonizer.createManifestProvider$lambda$8(libraries, arg_0));
    }

    private final void checkPreconditions() {
        Iterable $this$forEach$iv = this.outputTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedCommonizerTarget outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            switch (CommonizerTargetKt.allLeaves(outputTarget).size()) {
                case 0: {
                    CliLoggerAdapterKt.errorAndExitJvmProcess(this.logger, "No targets specified");
                    throw new KotlinNothingValueException();
                }
                case 1: {
                    CliLoggerAdapterKt.errorAndExitJvmProcess(this.logger, "Too few targets specified: " + outputTarget);
                    throw new KotlinNothingValueException();
                }
            }
        }
    }

    private static final TargetProvider commonizeAndSaveResults$lambda$5(LibraryCommonizer this$0, CommonizerTarget target, NativeLibrariesToCommonize targetLibraries) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this$0.createTargetProvider(target, targetLibraries);
    }

    private static final ModulesProvider createDependenciesProvider$lambda$6(LibraryCommonizer this$0, CommonizerTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return DefaultModulesProvider.Companion.forDependencies((Iterable<NativeLibrary>)this$0.dependencies.getLibraries(target), this$0.logger);
    }

    /*
     * WARNING - void declaration
     */
    private static final NativeManifestDataProvider createManifestProvider$lambda$8(TargetDependent $libraries, CommonizerTarget target) {
        NativeManifestDataProvider nativeManifestDataProvider;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CommonizerTarget commonizerTarget = target;
        if (commonizerTarget instanceof LeafCommonizerTarget) {
            NativeLibrariesToCommonize nativeLibrariesToCommonize = (NativeLibrariesToCommonize)$libraries.get(target);
            if (nativeLibrariesToCommonize == null) {
                throw new IllegalStateException(("Can't provide manifest for missing target " + target).toString());
            }
            nativeManifestDataProvider = nativeLibrariesToCommonize;
        } else if (commonizerTarget instanceof SharedCommonizerTarget) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = CommonizerTargetKt.allLeaves(target);
            CommonizerTarget commonizerTarget2 = target;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                NativeLibrariesToCommonize it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                LeafCommonizerTarget leafTarget = (LeafCommonizerTarget)element$iv$iv;
                boolean bl2 = false;
                if ((NativeLibrariesToCommonize)$libraries.getOrNull(leafTarget) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            nativeManifestDataProvider = NativeLibraryKt.NativeManifestDataProvider(commonizerTarget2, (List)destination$iv$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nativeManifestDataProvider;
    }
}

