/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.utils;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u0010\u001a\u00020\bJ\f\u0010\u0011\u001a\u00020\b*\u00020\u0012H\u0002J<\u0010\u0013\u001a\u00020\b*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/commonizer/utils/CommonizerMemoryTracker;", "", "<init>", "()V", "activeRunner", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/kotlin/commonizer/utils/CommonizerMemoryTracker$CommonizerMemoryTrackerRunner;", "startTracking", "", "phaseName", "", "intervalMillis", "", "forceGC", "", "updatePhase", "stopTracking", "writeHeader", "Ljava/io/Writer;", "writeRow", "time", "used", "free", "total", "max", "CommonizerMemoryTrackerRunner", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nCommonizerMemoryTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonizerMemoryTracker.kt\norg/jetbrains/kotlin/commonizer/utils/CommonizerMemoryTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class CommonizerMemoryTracker {
    @NotNull
    public static final CommonizerMemoryTracker INSTANCE = new CommonizerMemoryTracker();
    @NotNull
    private static final AtomicReference<CommonizerMemoryTrackerRunner> activeRunner = new AtomicReference();

    private CommonizerMemoryTracker() {
    }

    public final void startTracking(@NotNull String phaseName, long intervalMillis, boolean forceGC) {
        Intrinsics.checkNotNullParameter((Object)phaseName, (String)"phaseName");
        CommonizerMemoryTrackerRunner runner = new CommonizerMemoryTrackerRunner(phaseName, intervalMillis, forceGC, (Function0<? extends Writer>)((Function0)CommonizerMemoryTracker::startTracking$lambda$0));
        if (!activeRunner.compareAndSet(null, runner)) {
            boolean bl = false;
            String string2 = "There is another active runner";
            throw new IllegalStateException(string2.toString());
        }
        runner.start();
    }

    public final void updatePhase(@NotNull String phaseName) {
        Intrinsics.checkNotNullParameter((Object)phaseName, (String)"phaseName");
        CommonizerMemoryTrackerRunner commonizerMemoryTrackerRunner = activeRunner.get();
        if (commonizerMemoryTrackerRunner == null) {
            throw new IllegalStateException("No active runner".toString());
        }
        commonizerMemoryTrackerRunner.updatePhase(phaseName);
    }

    public final void stopTracking() {
        CommonizerMemoryTrackerRunner commonizerMemoryTrackerRunner = activeRunner.getAndSet(null);
        if (commonizerMemoryTrackerRunner == null) {
            throw new IllegalStateException("No active runner".toString());
        }
        CommonizerMemoryTrackerRunner runner = commonizerMemoryTrackerRunner;
        runner.interrupt();
    }

    private final void writeHeader(Writer $this$writeHeader) {
        $this$writeHeader.write("time;phase;used;free;total;max\n");
    }

    private final void writeRow(Writer $this$writeRow, long time, String phaseName, long used, long free, long total, long max) {
        $this$writeRow.write(String.valueOf(time));
        $this$writeRow.write(";");
        $this$writeRow.write(phaseName);
        $this$writeRow.write(";");
        $this$writeRow.write(CommonizerMemoryTracker.writeRow$toMBs(used));
        $this$writeRow.write(";");
        $this$writeRow.write(CommonizerMemoryTracker.writeRow$toMBs(free));
        $this$writeRow.write(";");
        $this$writeRow.write(CommonizerMemoryTracker.writeRow$toMBs(total));
        $this$writeRow.write(";");
        $this$writeRow.write(CommonizerMemoryTracker.writeRow$toMBs(max));
        $this$writeRow.write("\n");
    }

    private static final Writer startTracking$lambda$0() {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        OutputStream outputStream = printStream;
        Charset charset = Charsets.UTF_8;
        return new OutputStreamWriter(outputStream, charset);
    }

    private static final String writeRow$toMBs(long $this$writeRow_u24toMBs) {
        return String.valueOf($this$writeRow_u24toMBs / (long)1024 / (long)1024);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00030\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/commonizer/utils/CommonizerMemoryTracker$CommonizerMemoryTrackerRunner;", "Ljava/lang/Thread;", "phaseName", "", "intervalMillis", "", "forceGC", "", "writerFactory", "Lkotlin/Function0;", "Ljava/io/Writer;", "<init>", "(Ljava/lang/String;JZLkotlin/jvm/functions/Function0;)V", "runtime", "Ljava/lang/Runtime;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/atomic/AtomicReference;", "updatePhase", "", "run", "kotlin-klib-commonizer"})
    private static final class CommonizerMemoryTrackerRunner
    extends Thread {
        private final long intervalMillis;
        private final boolean forceGC;
        @NotNull
        private final Function0<Writer> writerFactory;
        private final Runtime runtime;
        @NotNull
        private final AtomicReference<String> phaseName;

        public CommonizerMemoryTrackerRunner(@NotNull String phaseName, long intervalMillis, boolean forceGC, @NotNull Function0<? extends Writer> writerFactory) {
            Intrinsics.checkNotNullParameter((Object)phaseName, (String)"phaseName");
            Intrinsics.checkNotNullParameter(writerFactory, (String)"writerFactory");
            super("CommonizerMemoryTrackerRunner");
            this.intervalMillis = intervalMillis;
            this.forceGC = forceGC;
            this.writerFactory = writerFactory;
            this.runtime = Runtime.getRuntime();
            this.phaseName = new AtomicReference<String>(phaseName);
        }

        public final void updatePhase(@NotNull String phaseName) {
            Intrinsics.checkNotNullParameter((Object)phaseName, (String)"phaseName");
            this.phaseName.set(phaseName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Closeable closeable = (Closeable)this.writerFactory.invoke();
            Throwable throwable = null;
            try {
                Writer writer = (Writer)closeable;
                boolean bl = false;
                INSTANCE.writeHeader(writer);
                long startTime = System.currentTimeMillis();
                try {
                    while (!Thread.interrupted()) {
                        if (this.forceGC) {
                            this.runtime.gc();
                        }
                        long currentTime = System.currentTimeMillis() - startTime;
                        long free = this.runtime.freeMemory();
                        long total = this.runtime.totalMemory();
                        long used = total - free;
                        long max = this.runtime.maxMemory();
                        String string2 = this.phaseName.get();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
                        INSTANCE.writeRow(writer, currentTime, string2, used, free, total, max);
                        Thread.sleep(this.intervalMillis);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

