/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerSettings;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.OptimisticNumberCommonizationEnabledKey;
import org.jetbrains.kotlin.commonizer.cir.CirAnnotation;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirHasAnnotations;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAttachment;
import org.jetbrains.kotlin.commonizer.core.BasicCirTypeVisitor;
import org.jetbrains.kotlin.commonizer.core.CirTypeRendererForUnsafeNumberAnnotationKt;
import org.jetbrains.kotlin.commonizer.core.CirTypeVisitorKt;
import org.jetbrains.kotlin.commonizer.core.OptimisticNumbersTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.UnsafeNumberAnnotation;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u001aB\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\u000b\u001a\u00020\n\u001a&\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0002*\f\b\u0002\u0010\u000e\"\u00020\u000f2\u00020\u000f\u00a8\u0006\u0010"}, d2={"createUnsafeNumberAnnotationIfNecessary", "Lorg/jetbrains/kotlin/commonizer/cir/CirAnnotation;", "targets", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "settings", "Lorg/jetbrains/kotlin/commonizer/CommonizerSettings;", "inputDeclarations", "Lorg/jetbrains/kotlin/commonizer/cir/CirHasAnnotations;", "inputTypes", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "commonizedType", "shouldCreateAnnotation", "", "RenderedType", "", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nUnsafeNumberAnnotationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeNumberAnnotationUtils.kt\norg/jetbrains/kotlin/commonizer/core/UnsafeNumberAnnotationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,100:1\n1863#2:101\n1863#2,2:102\n1864#2:104\n1863#2:105\n1864#2:108\n1755#2,2:109\n1755#2,3:111\n1757#2:114\n21#3,2:106\n*S KotlinDebug\n*F\n+ 1 UnsafeNumberAnnotationUtils.kt\norg/jetbrains/kotlin/commonizer/core/UnsafeNumberAnnotationUtilsKt\n*L\n27#1:101\n28#1:102,2\n27#1:104\n33#1:105\n33#1:108\n55#1:109,2\n56#1:111,3\n55#1:114\n34#1:106,2\n*E\n"})
public final class UnsafeNumberAnnotationUtilsKt {
    @Nullable
    public static final CirAnnotation createUnsafeNumberAnnotationIfNecessary(@NotNull List<? extends CommonizerTarget> targets, @NotNull CommonizerSettings settings, @NotNull List<? extends CirHasAnnotations> inputDeclarations, @NotNull List<? extends CirType> inputTypes, @NotNull CirType commonizedType) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(inputDeclarations, (String)"inputDeclarations");
        Intrinsics.checkNotNullParameter(inputTypes, (String)"inputTypes");
        Intrinsics.checkNotNullParameter((Object)commonizedType, (String)"commonizedType");
        if (!UnsafeNumberAnnotationUtilsKt.shouldCreateAnnotation(settings, commonizedType, inputDeclarations)) {
            return null;
        }
        Map actualPlatformTypes = new LinkedHashMap();
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)inputTypes, (Iterable)targets);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            CirType type2 = (CirType)pair.component1();
            CommonizerTarget target = (CommonizerTarget)pair.component2();
            Iterable $this$forEach$iv2 = CommonizerTargetKt.allLeaves(target);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                LeafCommonizerTarget leafCommonizerTarget = (LeafCommonizerTarget)element$iv2;
                boolean bl2 = false;
                actualPlatformTypes.put(leafCommonizerTarget.getName(), CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeForUnsafeNumberAnnotation(type2));
            }
        }
        $this$forEach$iv = inputDeclarations;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UnsafeNumberAnnotation existingAnnotation;
            Object v0;
            block6: {
                CirHasAnnotations annotated = (CirHasAnnotations)element$iv;
                boolean bl = false;
                Iterable $this$firstIsInstanceOrNull$iv = annotated.getAnnotations();
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv3 : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv3 instanceof UnsafeNumberAnnotation)) continue;
                    v0 = element$iv3;
                    break block6;
                }
                v0 = null;
            }
            if ((existingAnnotation = (UnsafeNumberAnnotation)v0) == null) continue;
            actualPlatformTypes.putAll(existingAnnotation.getActualPlatformTypes());
        }
        if (CollectionsKt.distinct((Iterable)actualPlatformTypes.values()).size() > 1) {
            return new UnsafeNumberAnnotation(actualPlatformTypes);
        }
        return null;
    }

    private static final boolean shouldCreateAnnotation(CommonizerSettings settings, CirType commonizedType, List<? extends CirHasAnnotations> inputDeclarations) {
        boolean bl;
        block8: {
            if (!((Boolean)settings.getSetting(OptimisticNumberCommonizationEnabledKey.INSTANCE)).booleanValue()) {
                return false;
            }
            Iterable $this$any$iv = inputDeclarations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block7: {
                        CirHasAnnotations declaration = (CirHasAnnotations)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = declaration.getAnnotations();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                CirAnnotation annotation = (CirAnnotation)element$iv2;
                                boolean bl4 = false;
                                if (!(annotation instanceof UnsafeNumberAnnotation)) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean isDerivedFromOptimisticallyCommonizedType = bl;
        Ref.BooleanRef isOptimisticallyCommonizedType = new Ref.BooleanRef();
        Ref.BooleanRef isOptimisticallyCommonizableNumberType = new Ref.BooleanRef();
        CirTypeVisitorKt.accept(commonizedType, new BasicCirTypeVisitor(isOptimisticallyCommonizedType, isOptimisticallyCommonizableNumberType){
            final /* synthetic */ Ref.BooleanRef $isOptimisticallyCommonizedType;
            final /* synthetic */ Ref.BooleanRef $isOptimisticallyCommonizableNumberType;
            {
                this.$isOptimisticallyCommonizedType = $isOptimisticallyCommonizedType;
                this.$isOptimisticallyCommonizableNumberType = $isOptimisticallyCommonizableNumberType;
            }

            public void visit(CirClassType classType) {
                Object v0;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
                    CirClassType this_$iv = classType;
                    boolean $i$f$getAttachment = false;
                    Iterable $this$firstIsInstanceOrNull$iv$iv = this_$iv.getAttachments();
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (T element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                        if (!(element$iv$iv instanceof OptimisticNumbersTypeCommonizer.OptimisticCommonizationMarker)) continue;
                        v0 = element$iv$iv;
                        break block3;
                    }
                    v0 = null;
                }
                if ((CirTypeAttachment)v0 != null) {
                    this.$isOptimisticallyCommonizedType.element = true;
                }
                if (OptimisticNumbersTypeCommonizer.INSTANCE.isOptimisticallyCommonizableNumber(classType.getClassifierId())) {
                    this.$isOptimisticallyCommonizableNumberType.element = true;
                }
                super.visit(classType);
            }
        });
        return isOptimisticallyCommonizedType.element || isDerivedFromOptimisticallyCommonizedType && isOptimisticallyCommonizableNumberType.element;
    }
}

