/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.CirClass;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.cir.CirProvided;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.SimpleCirSupertypesResolver;
import org.jetbrains.kotlin.commonizer.core.ClassSuperTypeCommonizerKt;
import org.jetbrains.kotlin.commonizer.core.SingleInvocationCommonizer;
import org.jetbrains.kotlin.commonizer.core.SupertypesGroup;
import org.jetbrains.kotlin.commonizer.core.SupertypesTree;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeNode;
import org.jetbrains.kotlin.commonizer.mergedtree.CirClassifierIndex;
import org.jetbrains.kotlin.commonizer.mergedtree.CirClassifierIndexKt;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;
import org.jetbrains.kotlin.descriptors.ClassKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00042\u0016\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0002H\u0096\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00022\u0016\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00040\u0002H\u0002J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/ClassSuperTypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/SingleInvocationCommonizer;", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "Lorg/jetbrains/kotlin/commonizer/core/Supertypes;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "typeCommonizer", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;", "<init>", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;)V", "invoke", "values", "resolveSupertypesTree", "Lorg/jetbrains/kotlin/commonizer/core/SupertypesTree;", "buildSupertypesGroups", "Lorg/jetbrains/kotlin/commonizer/core/SupertypesGroup;", "trees", "containsAnyClassKind", "", "group", "isClassKind", "node", "Lorg/jetbrains/kotlin/commonizer/core/TypeNode;", "assignGroupToNodes", "", "buildTypeGroup", "classifierId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nClassSuperTypeCommonizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassSuperTypeCommonizer.kt\norg/jetbrains/kotlin/commonizer/core/ClassSuperTypeCommonizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1734#2,3:196\n1611#2,9:199\n1863#2:208\n1864#2:210\n1620#2:211\n1567#2:212\n1598#2,3:213\n808#2,11:216\n1557#2:227\n1628#2,3:228\n1601#2:231\n1368#2:232\n1454#2,5:233\n1863#2,2:238\n1755#2,3:240\n1557#2:243\n1628#2,3:244\n2669#2,7:247\n1863#2:254\n1863#2,2:255\n1864#2:257\n1557#2:258\n1628#2,2:259\n1630#2:262\n1#3:209\n1#3:261\n*S KotlinDebug\n*F\n+ 1 ClassSuperTypeCommonizer.kt\norg/jetbrains/kotlin/commonizer/core/ClassSuperTypeCommonizer\n*L\n46#1:196,3\n51#1:199,9\n51#1:208\n51#1:210\n51#1:211\n79#1:212\n79#1:213,3\n82#1:216,11\n82#1:227\n82#1:228,3\n79#1:231\n101#1:232\n101#1:233,5\n101#1:238,2\n116#1:240,3\n133#1:243\n133#1:244,3\n134#1:247,7\n136#1:254\n137#1:255,2\n136#1:257\n146#1:258\n146#1:259,2\n146#1:262\n51#1:209\n*E\n"})
public final class ClassSuperTypeCommonizer
implements SingleInvocationCommonizer<List<? extends CirType>> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    @NotNull
    private final TypeCommonizer typeCommonizer;

    public ClassSuperTypeCommonizer(@NotNull CirKnownClassifiers classifiers2, @NotNull TypeCommonizer typeCommonizer) {
        Intrinsics.checkNotNullParameter((Object)classifiers2, (String)"classifiers");
        Intrinsics.checkNotNullParameter((Object)typeCommonizer, (String)"typeCommonizer");
        this.classifiers = classifiers2;
        this.typeCommonizer = typeCommonizer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CirType> invoke(@NotNull List<? extends List<? extends CirType>> values) {
        void $this$mapNotNullTo$iv$iv;
        Iterable it;
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            if (values.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$all$iv = values;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (List)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return CollectionsKt.emptyList();
        }
        List<SupertypesTree> supertypesTrees = this.resolveSupertypesTree(values);
        List<SupertypesGroup> supertypesGroups = this.buildSupertypesGroups(supertypesTrees);
        Iterable $this$mapNotNull$iv = supertypesGroups;
        boolean $i$f$mapNotNull = false;
        it = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            SupertypesGroup supertypesGroup = (SupertypesGroup)element$iv$iv;
            boolean bl4 = false;
            if (this.typeCommonizer.invoke(supertypesGroup.getTypes()) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SupertypesTree> resolveSupertypesTree(List<? extends List<? extends CirType>> values) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = values;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv;
            void supertypes;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CirClassifierIndex classifierIndex = this.classifiers.getClassifierIndices().get((int)index);
            SimpleCirSupertypesResolver resolver = new SimpleCirSupertypesResolver(this.classifiers.getClassifierIndices().get((int)index), this.classifiers.getCommonDependencies());
            Iterable $this$filterIsInstance$iv = (Iterable)supertypes;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CirClassType)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void type2;
                CirClassType cirClassType = (CirClassType)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(ClassSuperTypeCommonizerKt.access$createTypeNode(classifierIndex, resolver, (CirClassType)type2));
            }
            List nodes = (List)destination$iv$iv2;
            collection.add(new SupertypesTree(nodes));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SupertypesGroup> buildSupertypesGroups(List<SupertypesTree> trees) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        List groups = new ArrayList();
        boolean allowClassTypes = false;
        allowClassTypes = true;
        Iterable $this$flatMap$iv = trees;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SupertypesTree tree = (SupertypesTree)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = tree.getAllNodes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SupertypesGroup candidateGroup;
            TypeNode node = (TypeNode)element$iv;
            boolean bl = false;
            if (node.isConsumed() || this.buildTypeGroup(trees, node.getType().getClassifierId()) == null) continue;
            if (this.containsAnyClassKind(candidateGroup)) {
                if (!allowClassTypes) continue;
                allowClassTypes = false;
            }
            this.assignGroupToNodes(candidateGroup);
            groups.add(candidateGroup);
        }
        return groups;
    }

    private final boolean containsAnyClassKind(SupertypesGroup group) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = group.getNodes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeNode node = (TypeNode)element$iv;
                    boolean bl2 = false;
                    if (!this.isClassKind(node)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isClassKind(TypeNode node) {
        CirClass cirClass = CirClassifierIndexKt.findClass(node.getIndex(), node.getType().getClassifierId());
        if ((cirClass != null ? cirClass.getKind() : null) == ClassKind.CLASS) {
            return true;
        }
        CirProvided.Classifier classifier = this.classifiers.getCommonDependencies().classifier(node.getType().getClassifierId());
        if (classifier == null) {
            return false;
        }
        CirProvided.Classifier providedClassifier = classifier;
        return providedClassifier instanceof CirProvided.ExportedForwardDeclarationClass || providedClassifier instanceof CirProvided.RegularClass && ((CirProvided.RegularClass)providedClassifier).getKind() == ClassKind.CLASS;
    }

    /*
     * WARNING - void declaration
     */
    private final void assignGroupToNodes(SupertypesGroup group) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = group.getNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void rootNode;
            TypeNode typeNode = (TypeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = rootNode.getAllNodes();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                TypeNode typeNode2 = (TypeNode)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(it.getType().getClassifierId());
            }
            collection.add(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        }
        List classifiersIds = (List)destination$iv$iv;
        Iterable $this$reduce$iv = classifiersIds;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void list;
            Set set = (Set)iterator$iv.next();
            Set acc = (Set)accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.intersect((Iterable)acc, (Iterable)((Iterable)list));
        }
        Set coveredClassifierIds = (Set)accumulator$iv;
        Iterable $this$forEach$iv = group.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeNode rootNode = (TypeNode)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = rootNode.getAllNodes();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TypeNode visitingNode = (TypeNode)element$iv2;
                boolean bl3 = false;
                if (!coveredClassifierIds.contains(visitingNode.getType().getClassifierId())) continue;
                visitingNode.setConsumed(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SupertypesGroup buildTypeGroup(List<SupertypesTree> trees, CirEntityId classifierId) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = trees;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object v0;
            Collection collection;
            block3: {
                void otherTree;
                SupertypesTree supertypesTree = (SupertypesTree)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = otherTree.getAllNodes();
                for (Object t : iterable2) {
                    TypeNode otherNode = (TypeNode)t;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)otherNode.getType().getClassifierId(), (Object)classifierId) && !otherNode.isConsumed())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            TypeNode typeNode = v0;
            if (typeNode == null) {
                return null;
            }
            collection.add(typeNode);
        }
        List nodes = (List)destination$iv$iv;
        return new SupertypesGroup(classifierId, nodes);
    }
}

