/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.io.File;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00020\f*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerOutputFileLayout;", "", "<init>", "()V", "maxFileNameLength", "", "resolveCommonizedDirectory", "Ljava/io/File;", "root", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "fileName", "", "getFileName", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)Ljava/lang/String;", "ensureMaxFileNameLength", "base64Hash", "value", "kotlin-klib-commonizer-api"})
public final class CommonizerOutputFileLayout {
    @NotNull
    public static final CommonizerOutputFileLayout INSTANCE = new CommonizerOutputFileLayout();
    public static final int maxFileNameLength = 150;

    private CommonizerOutputFileLayout() {
    }

    @NotNull
    public final File resolveCommonizedDirectory(@NotNull File root, @NotNull CommonizerTarget target) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return FilesKt.resolve((File)root, (String)this.getFileName(target));
    }

    @NotNull
    public final String getFileName(@NotNull CommonizerTarget $this$fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$fileName, (String)"<this>");
        return this.ensureMaxFileNameLength(CommonizerTargetKt.getIdentityString($this$fileName));
    }

    @NotNull
    public final String ensureMaxFileNameLength(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (fileName.length() > 150) {
            String hashSuffix = "[--" + this.base64Hash(fileName) + ']';
            return StringsKt.take((String)fileName, (int)(150 - hashSuffix.length())) + hashSuffix;
        }
        return fileName;
    }

    @NotNull
    public final String base64Hash(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MessageDigest sha = MessageDigest.getInstance("SHA-1");
        Base64.Encoder base64 = Base64.getUrlEncoder();
        byte[] byArray = base64.encode(sha.digest(StringsKt.encodeToByteArray((String)value)));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        return StringsKt.decodeToString((byte[])byArray);
    }
}

