/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0006j\u0002`\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0086\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rR\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0006j\u0002`\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/SubstitutableNumbers;", "", "numbers", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "Lorg/jetbrains/kotlin/commonizer/core/BitWidth;", "", "<init>", "(Ljava/util/Map;)V", "contains", "", "id", "choose", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassType;", "first", "second", "kotlin-klib-commonizer"})
final class SubstitutableNumbers {
    @NotNull
    private final Map<CirEntityId, Integer> numbers;

    public SubstitutableNumbers(@NotNull Map<CirEntityId, Integer> numbers) {
        Intrinsics.checkNotNullParameter(numbers, (String)"numbers");
        this.numbers = numbers;
    }

    public final boolean contains(@NotNull CirEntityId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.numbers.containsKey(id);
    }

    @Nullable
    public final CirClassType choose(@NotNull CirClassType first, @NotNull CirClassType second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        Integer n = this.numbers.get(first.getClassifierId());
        if (n == null) {
            return null;
        }
        int firstBitWidth = n;
        Integer n2 = this.numbers.get(second.getClassifierId());
        if (n2 == null) {
            return null;
        }
        int secondBitWidth = n2;
        return Intrinsics.compare((int)secondBitWidth, (int)firstBitWidth) < 0 ? second : first;
    }
}

