/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.util;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.metadata.internal.util.AbstractArrayMapOwner;
import kotlinx.metadata.internal.util.ArrayMap;
import kotlinx.metadata.internal.util.ArrayMapImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002J\u001e\u0010\u0010\u001a\u00028\u00012\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000fH\u0084\u0002\u00a2\u0006\u0002\u0010\u0012J%\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000f2\u0006\u0010\u0015\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lkotlinx/metadata/internal/util/ComponentArrayOwner;", "K", "", "V", "Lkotlinx/metadata/internal/util/AbstractArrayMapOwner;", "()V", "arrayMap", "Lkotlinx/metadata/internal/util/ArrayMap;", "getArrayMap", "()Lorg/jetbrains/kotlin/util/ArrayMap;", "createDiagnosticMessage", "", "id", "", "tClass", "Lkotlin/reflect/KClass;", "get", "key", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "registerComponent", "", "value", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "compiler.common"})
public abstract class ComponentArrayOwner<K, V>
extends AbstractArrayMapOwner<K, V> {
    @NotNull
    private final ArrayMap<V> arrayMap = new ArrayMapImpl();

    @Override
    @NotNull
    protected final ArrayMap<V> getArrayMap() {
        return this.arrayMap;
    }

    @Override
    protected final void registerComponent(@NotNull KClass<? extends K> tClass, @NotNull V value) {
        Intrinsics.checkNotNullParameter(tClass, (String)"tClass");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int id = this.getTypeRegistry().getId(tClass);
        try {
            this.arrayMap.set(id, value);
        }
        catch (Exception e) {
            throw new RuntimeException(this.createDiagnosticMessage(id, tClass), e);
        }
    }

    @NotNull
    protected final V get(@NotNull KClass<? extends K> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int id = this.getTypeRegistry().getId(key);
        V v = this.arrayMap.get(id);
        if (v == null) {
            throw new IllegalStateException(("No '" + key + "'(" + id + ") component in array: " + this).toString());
        }
        return v;
    }

    private final String createDiagnosticMessage(int id, KClass<?> tClass) {
        StringBuilder stringBuilder;
        StringBuilder $this$createDiagnosticMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$createDiagnosticMessage_u24lambda_u240.append("Error occurred during registration of component in array");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = $this$createDiagnosticMessage_u24lambda_u240.append("Currently registered");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder4 = $this$createDiagnosticMessage_u24lambda_u240.append("  " + id + ": " + tClass);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder5 = $this$createDiagnosticMessage_u24lambda_u240.append("Registrar:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        for (Map.Entry<String, Integer> entry : this.getTypeRegistry().allValuesThreadUnsafeForRendering().entrySet()) {
            String kClass = entry.getKey();
            int x = ((Number)entry.getValue()).intValue();
            StringBuilder stringBuilder6 = $this$createDiagnosticMessage_u24lambda_u240.append("  " + x + ": " + kClass);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder7 = $this$createDiagnosticMessage_u24lambda_u240.append("Array map:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        int n = this.arrayMap.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = this.arrayMap.get(i);
            if (element != null) {
                element = Reflection.getOrCreateKotlinClass(element.getClass());
            }
            StringBuilder stringBuilder8 = $this$createDiagnosticMessage_u24lambda_u240.append("  " + i + ": " + element);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }
}

